package iDSS.beans2;


import java.beans.*;



import iDSS.*;
import iDSS.utils.*;




public class StatusJBean {




    private String dem;
    private String lcGrid;
    private String tidalModels;
    private String isoMov;
    private String vegMod;
    private String slrScen;


    private PropertyChangeSupport pcs;



    public StatusJBean() {

        pcs = new PropertyChangeSupport(this);
        getStatus();

    } //public StatusJBean()



    public void getStatus() {

        setDem(IDSSAppConstants.notDoneText);
        setLcGrid(IDSSAppConstants.notDoneText);
        setTidalModels(IDSSAppConstants.notDoneText);
        setIsoMov(IDSSAppConstants.notDoneText);
        setVegMod(IDSSAppConstants.notDoneText);
        setSlrScen(IDSSAppConstants.notDoneText);

    } //public void getStatus()





    public void addPropertyChangeListener(PropertyChangeListener l) {

        pcs.addPropertyChangeListener(l);

    } //public void addPropertyChangeListener(PropertyChangeListener l)





    public void removePropertyChangeListener(PropertyChangeListener l) {

        pcs.removePropertyChangeListener(l);

    } //public void removePropertyChangeListener(PropertyChangeListener l)









    public void setDem(String s) {

        dem = s;
        pcs.firePropertyChange(IDSSAppConstants.setDemStatus,null,dem);
        fireStatusNotice();

    } //public void setDem(String s)




    public String getDem() {

        return dem;

    } //public String getDem()





    public void setLcGrid(String s) {

        lcGrid = s;
        pcs.firePropertyChange(IDSSAppConstants.setLcGridStatus,null,lcGrid);
        fireStatusNotice();

    } //public void setLcGrid(String s)



    public String getLcGrid() {

        return lcGrid;

    } //public String getLcGrid()



    public void setTidalModels(String s) {

        tidalModels = s;
        pcs.firePropertyChange(IDSSAppConstants.setTidalModelsStatus,null,tidalModels);
        fireStatusNotice();

    } //public void setTidalModels(String s)




    public String getTidalModels() {

        return tidalModels;

    } //public String getTidalModels()







    public void setIsoMov(String s) {

        isoMov = s;
        pcs.firePropertyChange(IDSSAppConstants.setIsoMovStatus,null,isoMov);
        fireStatusNotice();

    } //public void setIsoMov(String s)




    public String getIsoMov() {

        return isoMov;

    } //public String getIsoMov()




    public void setVegMod(String s) {

        vegMod = s;
        pcs.firePropertyChange(IDSSAppConstants.setVegModStatus,null,vegMod);
        fireStatusNotice();

    } //public void setVegMod(String s)




    public String getVegMod() {

        return vegMod;

    } //public String getVegMod()





    public void setSlrScen(String s) {

        slrScen = s;
        pcs.firePropertyChange(IDSSAppConstants.setSlrScenStatus,null,slrScen);
        fireStatusNotice();

    } //public void setSlrScen(String s)



    public String getSlrScen() {

        return slrScen;

    } //public String getSlrScen()






    private void fireStatusNotice() {


        boolean status = checkStatus();

        if(status) {

            pcs.firePropertyChange(IDSSAppConstants.proceedWithSimulation,new Boolean(false),new Boolean(true));

        } //if(status)


    } //private void fireStatusNotice()





    public boolean checkStatus() {


        boolean status = true;

        if (dem.equals(IDSSAppConstants.notDoneText))
            status = false;

        else if (lcGrid.equals(IDSSAppConstants.notDoneText))
            status = false;

        else if (tidalModels.equals(IDSSAppConstants.notDoneText))
            status = false;

        else if (isoMov.equals(IDSSAppConstants.notDoneText))
            status = false;

        else if (vegMod.equals(IDSSAppConstants.notDoneText))
            status = false;

        else if (slrScen.equals(IDSSAppConstants.notDoneText))
            status = false;


        return status;

    } //public boolean checkStatus()



} //public class StatusJBean

