package iDSS.gridDisp;

import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.util.*;
import java.awt.image.BufferedImage;

import iDSS.*;
import iDSS.disp.*;
import iDSS.grids.*;
import iDSS.utils.*;



public class GridDisplay extends DisplayFrame implements ActionListener {

    private DrawingPanel2 drawingArea;

    private int drawingAreaX = 400;
    private int drawingAreaY = 400;

    private InfoAction infoAction;
    private ZoomInAction zoomInAction;
    private ZoomOutAction zoomOutAction;
    private AboutAction aboutAction;

    private Vector actions;

    private JTextField coordsTextField;
    private JLabel statusLabel;

    private MouseHandler mouseHandler;
    private JPopupMenu popup;


    //public GridDisplay (Grid aGrid) {
    public GridDisplay (String title) {

        super(title,true,true,true,true,null);

        initActions();
        statusLabel = createStatusBar();
        mouseHandler = new MouseHandler(statusLabel);

        setJMenuBar(createMenu());

        getContentPane().add(createToolBar(),BorderLayout.NORTH);
        getContentPane().add(createPanel(),BorderLayout.CENTER);
        getContentPane().add(statusLabel,BorderLayout.SOUTH);

        popup = createPopupMenu();

        coordsTextField = new JTextField(20);


        pack();
        setVisible(true);

    } //public GridDisplay (Grid aGrid)






/*
    public void drawGrid(Grid grid) {

        System.out.println("In GridDisplay, calling DrawingPanel2.drawGrid()");
        drawingArea.drawGrid(grid);

    } //public void drawGrid(Grid grid)

*/

/**

    public void drawGrid(Vector gridsVector,SurfaceColor sc) {

        //drawingArea.drawGrid(gridsVector,sc);

        for(int i=0;i<gridsVector.size();i++){
            Grid aGrid = (Grid) gridsVector.elementAt(i);
            setTitle(aGrid.getName());
            drawGrid(aGrid,sc);
        }


    } //public void drawGrid(Vector gridsVector,SurfaceColor sc)

**/



/*** This method and DrawingPanel2.drawGrid(Grid,SurfaceColor) is taken to class Grid
    public void drawGrid(Grid grid,SurfaceColor sc) {

        System.out.println("In GridDisplay, calling DrawingPanel2.drawGrid(Grid grid,SurfaceColor sc)");
        drawingArea.drawGrid(grid,sc);

    } //public void drawGrid(Grid grid,SurfaceColor sc)

**/





    private void initActions() {


        actions = new Vector();

        infoAction = new InfoAction();
        registerAction(infoAction);

        zoomInAction = new ZoomInAction();
        registerAction(zoomInAction);

        zoomOutAction = new ZoomOutAction();
        registerAction(zoomOutAction);

        aboutAction = new AboutAction();
        registerAction(aboutAction);


    } //private void initActions()




    private void registerAction(JLFAbstractAction action) {

        action.addActionListener(this);
        actions.addElement(action);

    } //private void registerAction()





    //creates the menu bar
    private JMenuBar createMenu() {


        JMenuBar menuBar = new JMenuBar();
        JMenuItem menuItem;

        //Build the View menu
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');

        menuItem = viewMenu.add(zoomInAction);
        menuItem.addMouseListener(mouseHandler);

        menuItem = viewMenu.add(zoomOutAction);
        menuItem.addMouseListener(mouseHandler);

        menuItem = viewMenu.add(infoAction);
        menuItem.addMouseListener(mouseHandler);

        //Build the About menu
        JMenu aboutMenu = new JMenu("About");

        aboutMenu.setMnemonic('A');

        menuItem = aboutMenu.add(aboutAction);
        menuItem.addMouseListener(mouseHandler);

        //Add menus to the menu bar
        menuBar.add(viewMenu);
        menuBar.add(aboutMenu);

        return menuBar;

    } //private JMenuBar createMenu()






    //creates the tool bar
    private JToolBar createToolBar() {


        JToolBar toolBar = new JToolBar();

        JButton button;

        button = toolBar.add(zoomInAction);
        button.addMouseListener(mouseHandler);

        button = toolBar.add(zoomOutAction);
        button.addMouseListener(mouseHandler);

        button = toolBar.add(infoAction);
        button.addMouseListener(mouseHandler);

        toolBar.addSeparator();

        button = toolBar.add(aboutAction);
        button.addMouseListener(mouseHandler);

        return toolBar;

    } //private JToolBar createToolBar()







    private JPopupMenu createPopupMenu() {

        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem;

        menuItem = menu.add(zoomInAction);
        menuItem.addMouseListener(mouseHandler);

        menuItem = menu.add(zoomOutAction);
        menuItem.addMouseListener(mouseHandler);

        menuItem = menu.add(infoAction);
        menuItem.addMouseListener(mouseHandler);

        menu.addSeparator();

        menuItem = menu.add(aboutAction);
        menuItem.addMouseListener(mouseHandler);

        return menu;

    } //private JPopupMenu createPopupMenu() 






    private JPanel createPanel() {

        coordsTextField = new JTextField(50);

        drawingArea = new DrawingPanel2(drawingAreaX,drawingAreaY);

        JScrollPane scrollPane = new JScrollPane(drawingArea);

        drawingArea.addMouseListener(new MouseAdapter() {

            public void mousePressed(MouseEvent e) {
                if(e.isPopupTrigger()) {
                    popup.show(drawingArea,e.getX(),e.getY());
                } //if(e.isPopupTrigger())
            } //public void mousePressed(MouseEvent e)


            public void mouseReleased(MouseEvent e) {
                if(e.isPopupTrigger()) {
                    popup.show(drawingArea,e.getX(),e.getY());
                } //if(e.isPopupTrigger())
            } //public void mousePressed(MouseEvent e)


        });

        JPanel panel = new JPanel(new BorderLayout());

        panel.setPreferredSize(new Dimension(drawingAreaX,drawingAreaY));
        panel.add(coordsTextField,BorderLayout.NORTH);
        panel.add(scrollPane,BorderLayout.CENTER);

        return panel;

    } //private JPanel createPanel()



    //creates the status bar
    private JLabel createStatusBar() {

        statusLabel = new JLabel("...");
        statusLabel.setBorder(BorderFactory.createEtchedBorder());

        return statusLabel;

    } //rivate JLabel createStatusBar()



    //This methos acts as the action handler delegate for all the actions
    public void actionPerformed(ActionEvent evt) {

        String command = evt.getActionCommand();

        //compare this actionCommand to the known actions
        if(command.equals(aboutAction.getActionCommand())) {
            JOptionPane.showMessageDialog(this, aboutAction.getLongDescription(),
                                                aboutAction.getShortDescription(),
                                                JOptionPane.INFORMATION_MESSAGE);

        }

        else if(command.equals(zoomInAction.getActionCommand())) {

        }

        else if(command.equals(zoomOutAction.getActionCommand())) {

        }

        else if(command.equals(infoAction.getActionCommand())) {

        }


    } //public void actionPerformed(ActionEvent evt) 




    //this adapter is constructed to handle mouseOver component events
    private class MouseHandler extends MouseAdapter {


        private JLabel label;

        public MouseHandler(JLabel label) {
            setLabel(label);
        }

        private void setLabel(JLabel label) {
            this.label = label;
        }

        public void mouseEntered(MouseEvent evt) {

            if(evt.getSource() instanceof AbstractButton) {
                AbstractButton button = (AbstractButton) evt.getSource();
                Action action = button.getAction();

                if (action != null) {
                    String message = (String) action.getValue(Action.LONG_DESCRIPTION);
                    label.setText(message);
                } //if (action != null)



            } //if(evt.getSource() instanceof AbstractButton)

        } //public void mouseEntered(MouseEvent evt)


    } //private class MouseHandler extends MouseAdapter






    public static void main(String args[]) {

        JFrame aFrame = new JFrame("GridDisplay test");

        aFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });


        GridDisplay aGrid = new GridDisplay("GridDisplay");

        JDesktopPane dPane = new JDesktopPane();

        dPane.putClientProperty("JDesktopPane.dragMode", "outline");
        dPane.add(aGrid);
        aFrame.setContentPane(dPane);

        aFrame.pack();
        aFrame.setSize(500,400);
        aFrame.setVisible(true);


  }//main()






    public BufferedImage getCanvas() {

        return drawingArea.getCanvas();

    } //public BufferedImage getCanvas()




    public void refreshCanvas(BufferedImage bi) {

        if(IDSSAppConstants.debug)
            System.out.println("GridDisplay.refreshCanvas()");

        drawingArea.refreshCanvas(bi);

    } //public void refreshCanvas()





} //public class GridDisplay extends DisplayFrame
