package iDSS.sim;

import java.util.*;
import iDSS.beans2.*;
import java.beans.*;

public class InputValidation {


    private String simName = "";
    private String timestepString = "";
    private String resultStep = "";
    private String coordsString = "";
    private String simulateUntil = "";



    public InputValidation() {}


    /***** set methods ****/


    public void setSimName (String s) {

        simName = s;

    } //public void setSimName (String s)


    public void setTimestepString(String s) {

        timestepString = s;

    } //public void setTimestepString(String s)



    public void setResultStep(String s) {

        resultStep = s;

    } //public void setResultStep(String s)



    public void setCoordsString(String s) {

        coordsString = s;

    } //public void setCoordsString(String s)



    public void setSimulateUntil(String s) {

        simulateUntil = s;

    } //public void setSimulateUntil(String s)




    /***** get methods ****/


    public String getSimName () {

        return simName;

    } //public String getSimName ()



    public String getTimestepString() {

        return timestepString;

    } //public String getTimestepString()



    public String getResultStep() {

        return resultStep;

    } //public String getResultStep()



    public String getCoordsString() {

        return coordsString;

    } //public String getCoordsString()



    public String getSimulateUntil() {

        return simulateUntil;

    } //public String getSimulateUntil()







    public Vector validateInput() {


        boolean validInput = true;

        if(simName == null) {

            String message = "Missing simulation name";
            System.out.println("simName = null, " + message);
            validInput = false;
            Vector vec = makeMessage(validInput,message);
            return vec;

        } //if(simName == null)

        if (simName.length() < 1) {

            String message = "Missing simulation name";
            System.out.println("simName.length() < 1, " + message);
            validInput = false;
            Vector vec = makeMessage(validInput,message);
            return vec;

        } //if (simName.length() < 1)




        //System.out.println(simName);

        if(timestepString == null) {

            String message = "Missing time step";
            validInput = false;
            return makeMessage(validInput,message);

        } //if(timestepString == null)


        try {

            int timestepMinutes = Integer.parseInt(timestepString);
            timestepMinutes = timestepMinutes*60;           //assuming timestep is always in hours


        } //try

        catch (NumberFormatException nfe) {

            String message  = nfe.toString() + ". Simulation timestep must be a positive non-zero integer";
            validInput = false;
            return makeMessage(validInput,message);

        } //catch (NumberFormatException nfe)


        
        if(resultStep == null) {

            String message = "Missing results step";
            validInput = false;
            return makeMessage(validInput,message);

        } //if(resultStep == null)


        try {

            int resultsTimestepYears = Integer.parseInt(resultStep);


        } //try

        catch (NumberFormatException nfe) {

            String message  = nfe.toString() + ". Results timestep must be a positive non-zero integer";
            validInput = false;
            return makeMessage(validInput,message);

        } //catch (NumberFormatException nfe)



        if(coordsString == null) {

            String message = "Missing flood start points";
            validInput = false;
            return makeMessage(validInput,message);

        } //if(coordsString == null)


        if (coordsString.length() < 3) {

            String message = "Missing flood start points";
            validInput = false;
            return makeMessage(validInput,message);

        } //if (coordsString.length() < 1)

/**
        simBean.setFloodStartVector(coordsString);

        simBean.setViewFG(false);
        simBean.setSaveFG(false);
        simBean.setViewDD(false);
        simBean.setSaveDD(false);

        simBean.setSimulateUntil(Integer.parseInt(simulateUntil));
**/

        Vector v = makeMessage(validInput,"All inputs valid");
        return v;

    } //public Vector validateInput()





    private Vector makeMessage(boolean b,String s) {

        Vector v = new Vector();
        v.add(new Boolean(b));
        v.add(s);

        System.out.println("makeMessage(), s : " + s);
        return v;

    } //private Vector makeMessage(bolean b,String s)



} //public class InputValidation

