package iDSS.tidalData;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;
import javax.swing.table.*;
import java.beans.*;




import iDSS.*;
import iDSS.tables.*;
import iDSS.utils.*;
import iDSS.disp.*;
import iDSS.beans2.*;



public class TidalModelsList extends DisplayFrame implements ActionListener, PropertyChangeListener {

    private JTable aTable;
    //private Hashtable tidalModelHashtable;
    private JButton acceptChangesButton;
    private TidalModelsListJBean tidalModelsListJBean;




    public TidalModelsList(String title) {

        super (title,false,false,false,true,null);

        tidalModelsListJBean = new TidalModelsListJBean();
        tidalModelsListJBean.addPropertyChangeListener(this);


        Vector rows = new Vector();
        Vector columns = new Vector();
        columns.add("Tidal Model");
        columns.add("Relative Weightage");

        //System.out.println("columns.size() = " + columns.size());

        GeneralTableModel tm = new GeneralTableModel(rows,columns,1);
        aTable = new JTable(tm);

        TableColumn weightageColumn = aTable.getColumnModel().getColumn(1);

        JComboBox comboBox = new JComboBox();

        for (int i=0;i<=10;i++) {
            comboBox.addItem(new Integer(i));
        }

        weightageColumn.setCellEditor(new DefaultCellEditor(comboBox));


        aTable.setPreferredScrollableViewportSize(new Dimension(200,100));

        JScrollPane aScrollPane = new JScrollPane(aTable,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

        acceptChangesButton = new JButton(IDSSAppConstants.acceptButtonText);
        acceptChangesButton.setActionCommand(IDSSAppConstants.acceptButtonCommand);
        acceptChangesButton.addActionListener(this);
        acceptChangesButton.setEnabled(false);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(Color.lightGray);
        buttonPanel.setLayout(new BoxLayout(buttonPanel,BoxLayout.X_AXIS));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(acceptChangesButton);

        getContentPane().setLayout(new BoxLayout(getContentPane(),BoxLayout.Y_AXIS));

        getContentPane().add(aScrollPane);
        getContentPane().add(buttonPanel);

        pack();
        setVisible(true);

    }//public TidalModelsList(String title, GeneralTableModel tm)






    public void actionPerformed(ActionEvent ae) {


        if(ae.getActionCommand().equals(IDSSAppConstants.acceptButtonCommand)) {


            GeneralTableModel tm = (GeneralTableModel) aTable.getModel();
            Vector editedRows = tm.getRowsVector();

            for(int i=0;i<editedRows.size();i++) {

                Vector oneRow = (Vector) editedRows.elementAt(i);
                String modelName = (String) oneRow.elementAt(0);
                Integer weightage = (Integer) oneRow.elementAt(1);

                tidalModelsListJBean.setModelWeightage(modelName,weightage.intValue());

            } //for(int i=0;i<editedRows.size();i++)

            Hashtable tidalModelHashtable = tidalModelsListJBean.getTidalModelHashtable();
            firePropertyChange(IDSSAppConstants.setAllTidalModels,null,tidalModelHashtable);


        } //if(ae.getActionCommand().equals(IDSSAppConstants.acceptButtonCommand))


    } //public void actionPerformed(ActionEvent ae)




    public void addTM(Vector tmVector) {


        if(tidalModelsListJBean.addTM(tmVector)) {

            String key = (String)tmVector.elementAt(0);
            TidalModel tm = (TidalModel)tmVector.elementAt(1);
            Integer wt = new Integer (tm.getWeightage());

            Vector row = new Vector();
            row.add(key);
            row.add(wt);

            GeneralTableModel gtm = (GeneralTableModel) aTable.getModel();
            gtm.addRow(row);
            aTable.setModel(gtm);
            acceptChangesButton.setEnabled(true);

        } //if(tidalModelsListJBean.addTM(tmVector))



    } //public void addTM(Vector tmVector)






    public void propertyChange(PropertyChangeEvent evt) {}




}//public class TidalModelsList extends DisplayFrame implements ActionListener
