package iDSS.utils;

import java.util.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import java.io.*;
import java.awt.image.BufferedImage;
import java.beans.*;
import java.net.*;



public class ObjectReadWrite {


    public static boolean write(File file,Object o) {

        boolean success = false;

        try {
            if(file.exists()) {
                file.delete();
            }//if(file.exists())

            File parent = new File(file.getParent());
            if(parent != null) {
                if(!parent.exists()) {
                    parent.mkdirs();
                } //if(!parent.exits())
            } //if(parent != null)

            if(file.createNewFile()) {
                FileOutputStream f = new FileOutputStream(file);
                ObjectOutputStream ooStream = new ObjectOutputStream(f);
                ooStream.writeObject(o);
                //ooStream.writeObject("testStringObject");
                //ooStream.flush();
                f.close();
                ooStream.close();
                success = true;
            }
            else
                System.out.println("ObjectReadWrite.write(), failed to create file " + file.toString());

        } //try

        catch (FileNotFoundException fnfe) {
            System.out.print("ObjectReadWrite.write()");
            System.out.println("File not found : " + fnfe);
        }

        catch (IOException ioe) {
            System.out.print("ObjectReadWrite.write()");
            System.out.println("IOException : " + ioe);
        }


        return success;

    } //public static boolean write(File file,Object o)











    public static Object read(File aFile) {



        System.out.println("ClassLoader test");

        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        System.out.println("SurvivalModelsListJBean.showDetails(), ClassLoader : " + cl.toString());


        Object o = null;

        try {
            if(aFile.exists()) {

                FileInputStream f = new FileInputStream(aFile);
                ObjectInputStream oiStream = new ObjectInputStream(f);
                o = oiStream.readObject();

                f.close();
                oiStream.close();


            }//if(!inFile.exists())

            else {
                System.out.println("ObjectReadWrite.read(), input file " + aFile.toString() + " doesn't exist");
            }

        } //try

        catch (FileNotFoundException fnfe) {
            System.out.print("ObjectReadWrite.read()");
            System.out.println("File not found : " + fnfe.toString());
        }

        catch (IOException ioe) {
            System.out.print("ObjectReadWrite.read()");
            System.out.println("IOException : " + ioe);
            return null;
        }
        catch(ClassNotFoundException cnfe) {

            System.out.print("ObjectReadWrite.read()");
            String s = cnfe.toString();
            System.out.println("ClassNotFoundException s : " + s);

            int i = s.lastIndexOf(':');

            System.out.println("i : " + i);
            String s2 = s.substring(i+2);
            System.out.println("ClassNotFoundException s2 : " + s2);


            return null;

        }
        catch(ClassCastException cce) {
            System.out.print("ObjectReadWrite.read()");
            System.out.println("ClassCastException : " + cce);
            return null;
        }




        return o;

    } //public static Object read(File aFile)























    public static Object read(URL url) {

        Object o = null;
        HttpURLConnection connection;
        int responseCode;
        InputStream input;
        ObjectInputStream oiStream;

        try {
            connection = (HttpURLConnection)url.openConnection();
            responseCode = connection.getResponseCode();


            if(responseCode == HttpURLConnection.HTTP_OK) {

                input = connection.getInputStream();
                oiStream = new ObjectInputStream(input);
                o = oiStream.readObject();
                oiStream.close();
                connection.disconnect();

            } //if(responseCode == HttpURLConnection.HTTP_OK)



        } //try

        catch(Exception ex) {

            System.out.println("ObjectReadWrite.read(URL), " + ex.toString());

        } //catch(Exception ex)


        return o;

    } //public static Object read(URL url)









    public static boolean write(URL url,Object o) {

        boolean success = false;

        HttpURLConnection connection;
        int responseCode;
        OutputStream output;
        ObjectOutputStream ooStream;

        try {
            connection = (HttpURLConnection)url.openConnection();
            responseCode = connection.getResponseCode();

            if(responseCode == HttpURLConnection.HTTP_OK) {

                connection.setDoOutput(true);

                output = connection.getOutputStream();
                ooStream = new ObjectOutputStream(output);
                ooStream.writeObject(o);
                ooStream.close();
                connection.disconnect();
                success = true;

            } //if(responseCode == HttpURLConnection.HTTP_OK)

        } //try

        catch(Exception ex) {

            System.out.println("ObjectReadWrite.write(URL,Object), " + ex.toString());

        } //catch(Exception ex)

        return success;

    } //public static boolean write(URL url,Object o)



/**
ObjectInputStream objIn = null; 
ObjectOutputStream objOut = null; 
response.setContentType("application/octet-stream"); 

try { 
objIn = new ObjectInputStream(request.getInputStream()); 
Object o = objIn.readObject(); 
objOut = new ObjectOutputStream(response.getOutputStream ()); 
objOut.writeObject(o); 
} 
catch (Exception e) { } 
finally { 
objIn.close(); 
objOut.close(); 
} 
**/


} //public class ObjectReadWrite
