/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */


package ejb.slr;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import javax.rmi.*;
import java.rmi.*;
import utils.*;
import ejb.dataAccess.*;




public class SLREJB implements EntityBean {


    private String name;
    private String storyLine;
    private String scenarioTable;

    private EntityContext context;
    private Data dataAccess;
    private String dbName = ServerConstants.slrDB;
    private String dataAccessSessionBean = ServerConstants.dataAccessBean;



    public String ejbCreate(String name,String storyLine,String scenarioTable)
                                throws CreateException {


       try {

          insertRow(name,storyLine,scenarioTable);

       } //try

       catch (Exception ex) {

           throw new EJBException("SLREJB.ejbCreate(): " + 
              ex.getMessage());

       } //catch (Exception ex)

        this.name = name;
        this.storyLine = storyLine;
        this.scenarioTable = scenarioTable;

        return name;

    }





   public String ejbFindByPrimaryKey(String name) 
      throws FinderException {

      boolean result;

      try {
         result = selectByPrimaryKey(name);
       } catch (Exception ex) {
           throw new EJBException("SLREJB.ejbFindByPrimaryKey(): " + 
              ex.getMessage());
       }
      if (result) {
         return name;
      }
      else {
         throw new ObjectNotFoundException
            ("SLREJB.ejbFindByPrimaryKey():Row for scenario " + name + " not found.");
      }
   }








   public Collection ejbFindAll()
      throws FinderException {

      Collection result;

      try {
         result = selectAll();
            
       } catch (Exception ex) {
           throw new EJBException("SLREJB.ejbFindAll(): " + 
              ex.getMessage());
       }
      if (result.isEmpty()) {
         throw new ObjectNotFoundException("SLREJB.ejbFindInRange():No rows found.");
      }
      else {
         return result;
      }
   }


/**

   public Collection ejbFindInRange(String start,String end)
      throws FinderException {

      Collection result;

      try {
         result = selectInRange(start, end);
            
       } catch (Exception ex) {
           throw new EJBException("SLREJB.ejbFindInRange(): " + 
              ex.getMessage());
       }
      if (result.isEmpty()) {
         throw new ObjectNotFoundException("SLREJB.ejbFindInRange():No rows found.");
      }
      else {
         return result;
      }
   }

**/







   public void ejbRemove() {

      try {
         deleteRow(name);
       } catch (Exception ex) {
           throw new EJBException("SLREJB.ejbRemove(): " + 
              ex.getMessage());
       }
   } 






    public void setEntityContext(EntityContext context) {

        this.context = context;


        try {

            Context initial = new InitialContext();
            Object objref = initial.lookup(dataAccessSessionBean);

            DataHome home = 
                (DataHome)PortableRemoteObject.narrow(objref, 
                                            DataHome.class);

            dataAccess = home.create();


        } //try

        catch(NamingException e) {

            System.out.println("SLREJB.setEntityContext(), NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)


        catch(RemoteException re) {

            System.out.println("SLREJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


        catch(CreateException re) {

            System.out.println("SLREJB.setEntityContext(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



   }//public void setEntityContext(EntityContext context)






    public void unsetEntityContext() {

        dataAccess = null;

    } //public void unsetEntityContext()





    public void ejbActivate() {

        name = (String)context.getPrimaryKey();

    }//public void ejbActivate()






   public void ejbPassivate() {

      name = null;

   }//public void ejbPassivate()






    public void ejbLoad() {

        try {
            loadRow();
        } //try

        catch (Exception ex) {
           throw new EJBException("ejbLoad: " + 
              ex.getMessage());
        } //catch (Exception ex)
    }
   






   public void ejbStore() {

        try {
           storeRow();
        }//try

        catch (Exception ex) {
            throw new EJBException("ejbLoad: " + 
                ex.getMessage());
        }//catch (Exception ex)

    }//public void ejbStore()






    public void ejbPostCreate(String name,String storyLine,String scenarioTable) { }



/*********************** Business Methods *************************/


    public String getName() {

        return name;

    } //public String getName()



    public String getStoryLine() {

        return storyLine;

    } //public String getStoryLine()




    public String getScenarioTable() {

        return scenarioTable;

    } //public String getScenarioTable()








    public void setName(String s) {

        this.name = s;

    } //public void setName(String s)




    public void setStoryLine(String s) {

        this.storyLine = s;

    } //public void setStoryLine(String s)





    public void setScenarioTable(String s) {

        this.scenarioTable = s;

    } //public void setScenarioTable(String s)






/*********************** Database Routines *************************/


    private void insertRow (String name,String storyLine,String scenarioTable)
                        throws SQLException {



        String sql = "insert into scenarioNames " +
                    "(name,storyLine,scenarioTable) values " + 
                    "(" +
                    "'" + name + "'" + "," +
                    "'" + storyLine + "'" + "," +
                    "'" + scenarioTable + "'" + ")";

        try {

            dataAccess.insert(sql,dbName);

        } //try

        catch(RemoteException re) {

            System.out.println("SLREJB.insertRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)


   } //private void insertRow (String name,String storyLine,String scenarioTable)





    private void deleteRow(String name) throws SQLException {

        String deleteStatement = "delete from scenarioNames where name='" + name + "'";

        try {
            dataAccess.delete(deleteStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLREJB.deleteRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




    } //private void deleteRow(String name) throws SQLException




    private boolean selectByPrimaryKey(String name) 
                                        throws SQLException {

        boolean result = false;

        String selectStatement = "select name " +
                                    "from scenarioNames where name='" + name + "'";

        try {
            DataSet ds = dataAccess.select(selectStatement,dbName);


            Vector rows = ds.getRowsOfDataVector();

            if(rows.size() > 0)
                result = true;

            return result;


        } //try

        catch(RemoteException re) {

            System.out.println("SLREJB.selectByPrimaryKey(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)

        return result;

    } //private boolean selectByPrimaryKey(String name)








    private Collection selectAll() throws SQLException {


        String selectStatement = "select * from scenarioNames" ;

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLREJB.selectAll(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String name = (String)oneRow.elementAt(0);
            a.add(name);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectAll()
















/***
    private Collection selectInRange(String start,String end) 
                                        throws SQLException {


        String selectStatement = "select stationName from tidalStations where " +
                                "stationName>='" + start + "' and stationName<='" + end + "'";

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLREJB.selectInRange(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)




        ArrayList a = new ArrayList();

        Vector rows = ds.getRowsOfDataVector();

        for(int i=0;i<rows.size();i++) {

            Vector oneRow = (Vector)rows.elementAt(i);
            String station = (String)oneRow.elementAt(3);
            a.add(station);

        } //for(int i=0;i<rows.size();i++)

        return a;



   } //private Collection selectInRange(String start,String end)

**/



    private void loadRow() throws SQLException {


        String selectStatement =
            "select name,storyLine,scenarioTable " +
            "from scenarioNames where name='" + name + "'";

        DataSet ds = null;

        try {
            ds = dataAccess.select(selectStatement,dbName);
        }

        catch(RemoteException re) {

            System.out.println("SLREJB.loadRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



        Vector rows = ds.getRowsOfDataVector();

        if(rows.size() > 0) {

            Vector oneRow = (Vector)rows.elementAt(0);

            this.name = (String)oneRow.elementAt(0);
            this.storyLine = (String)oneRow.elementAt(1);
            this.scenarioTable = (String)oneRow.elementAt(2);

        } //if(rows.size() > 0)

        else {

            throw new NoSuchEntityException("SLREJB.loadRow(), Row for  " + name +
                    " not found in database.");


        } //else



    } //private void loadRow() throws SQLException








    private void storeRow() throws SQLException {


        String updateStatement = "update scenarioNames set " +
                            "name='" + name + "'," +
                            "storyLine='" + storyLine + "'," +
                            "scenarioTable='" + scenarioTable + "'" +
                            " where name='" + name + "'";



        try {
            int rowCount = dataAccess.update(updateStatement,dbName);

            if (rowCount == 0) {

                throw new EJBException("SLREJB.storeRow(), Storing row for " + name + " failed.");

            } //if (rowCount == 0)

        } //try


        catch(RemoteException re) {

            System.out.println("SLREJB.storeRow(), RemoteException : " + re.toString());
            re.printStackTrace();
            System.exit(0);

        } //catch(RemoteException re)



    }//private void storeRow() throws SQLException 


} // SLREJB

