/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.slrData;

import java.util.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.sql.Timestamp;



public class SLRDataClient {

   public static void main(String[] args) {

       try {
           Context initial = new InitialContext();
           Object objref = initial.lookup("SLRDataEJB");

           SLRDataHome home = 
               (SLRDataHome)PortableRemoteObject.narrow(objref, 
                                            SLRDataHome.class);


            SLRData aSLRData = home.create("sres00",1111,1.0,2.0,3.0,4.0);

            aSLRData = home.findByPrimaryKey("sres00",1111);


            System.out.println("Scenario name : " + aSLRData.getScenarioName());
            System.out.println("Year          : " + aSLRData.getYear());
            System.out.println("sens1_5       : " + aSLRData.getSens1_5());
            System.out.println("sens4_5       : " + aSLRData.getSens4_5());
            System.out.println("sens2_5       : " + aSLRData.getSens2_5());
            System.out.println("sens2_5nosulf : " + aSLRData.getSens2_5nosulf());

            aSLRData.remove();


            


            Collection c = home.findByScenarioName("sresb1");
            //Collection c = home.findAll();
            Iterator i=c.iterator();

            while (i.hasNext()) {
                SLRData t = (SLRData)i.next();

                System.out.println("Scenario name : " + t.getScenarioName());
                System.out.println("Year          : " + t.getYear());
                System.out.println("sens1_5       : " + t.getSens1_5());
                System.out.println("sens4_5       : " + t.getSens4_5());
                System.out.println("sens2_5       : " + t.getSens2_5());
                System.out.println("sens2_5nosulf : " + t.getSens2_5nosulf());

            }//while()


        } //try


        catch (Exception ex) {

            System.err.println("Caught an exception." );
            ex.printStackTrace();

        } //catch (Exception ex)

    }//public static void main(String[] args)

}
