/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package ejb.tide;


import java.util.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import javax.sql.*;
import java.sql.*;
import javax.ejb.*;
import javax.rmi.*;
import sun.jdbc.rowset.*;


import ejb.dataAccess.*;
import utils.*;



public class TidalDataClient {

    public static void main(String[] args) {
        try {

            Context initial = new InitialContext();
            Object objref = initial.lookup("TidalDataEJB");

            TidalDataHome home = 
               (TidalDataHome)PortableRemoteObject.narrow(objref, 
                                            TidalDataHome.class);


            //String dbName = "java:comp/env/jdbc/idss";
            String dbName = ServerConstants.tidalDataDB;

            TidalData tidalData = home.create();

            Timestamp start = Timestamp.valueOf("1908-01-01 00:00:00");
            Timestamp end = Timestamp.valueOf("1908-01-02 00:00:00");

            tidalData.insert("sheerness",start,10.20,dbName);
            tidalData.insert("sheerness",end,12.90,dbName);

            DataSet ds = tidalData.select("sheerness",start,end,dbName);

            int n;
            n = tidalData.delete("sheerness",start,end,dbName);
            System.out.println(n + " rows deleted");

            Vector columns = ds.getColumnNamesVector();
            Vector rows = ds.getRowsOfDataVector();

            System.out.println("");

            for(int i=0;i<columns.size();i++) {

                String s = (String)columns.elementAt(i);
                System.out.print("\t" + s);

            } //for(int i=0;i<columns.size();i++)

            System.out.println("");



            for(int i=0;i<rows.size();i++) {

                Vector v = (Vector)rows.elementAt(i);

                System.out.println("");

                for(int j=0;j<v.size();j++) {

                    String s = v.elementAt(j).toString();
                    System.out.print("\t" + s);

                } //for(int j=0;j<v.size();j++)

            } //for(int i=0;i<rows.size();i++)

            System.out.println("");


       } //try


            catch(NamingException e) {

            System.out.println("NamingException : " + e.toString());
            e.printStackTrace();
            System.exit(0);

        } //catch(NamingException e)




        catch (Exception ex) {
            System.err.println("Caught an unexpected exception! " + ex.toString());
            ex.printStackTrace();
            System.out.println("message : " + ex.getMessage());
        } //catch (Exception ex)


   } //public static void main(String[] args)


} //public class TidalDataClient

