/*
 * $Id: DocumentBuilderImpl.java,v 1.9 2000/02/18 21:58:28 mode Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */


package com.sun.xml.parser;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

/**
 * @author Rajiv Mordani
 * @version $Revision: 1.9 $
 */
public class DocumentBuilderImpl extends DocumentBuilder {

    private DocumentBuilderFactory dbf;

    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private Parser parser = null;
    private XmlDocumentBuilder builder = null;

    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl (DocumentBuilderFactory dbf) {
	super ();
        this.dbf = dbf;

	builder = new XmlDocumentBuilder ();
	if (dbf.isValidating ()) {
	    parser = new ValidatingParser ();
	    validating = true;
	} else {
	    parser = new Parser ();	
	}

	if (dbf.isNamespaceAware ()) {
	    builder.setDisableNamespaces (false);	
	    namespaceAware = true;
	}

	builder.setParser (parser);
	parser.setDocumentHandler (builder);
    }

    public Document newDocument () {
   	return new XmlDocument (); 
    }

    public Document parse(InputSource is) throws SAXException,
    							  IOException
    {
	if (is == null) {
	    throw new IllegalArgumentException ("InputSource cannot be null");
        }

	if (er != null) {
	    parser.setEntityResolver(er);
	} else {
	    parser.setEntityResolver(new Resolver ());	
	}

	if (eh != null) {
	    parser.setErrorHandler(eh);	
	}

	parser.parse(is);
	return builder.getDocument();
    }

    public boolean isNamespaceAware () {
	return namespaceAware;
    }

    public boolean isValidating () {
	return validating;
    }

    public void setEntityResolver (org.xml.sax.EntityResolver er) {
   	this.er = er;
    }

    public void setErrorHandler (org.xml.sax.ErrorHandler eh) {
   	this.eh = eh; 
    }
}
