// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>This interface represents a notation declared in the DTD. A notation
    either declares, by name, the format of an unparsed entity (see section 4.7
    of the XML 1.0 specification), or is used for formal declaration of
    Processing Instruction targets (see section 2.6 of the XML 1.0
    specification). The <code>nodeName</code> attribute inherited from
    <A HREF='Node.html'><CODE>Node</CODE></A> is set to the declared name of the notation.
<P>The DOM Level 1 does not support editing <A HREF='Notation.html'><CODE>Notation</CODE></A>
      nodes; they are therefore readonly.
<P>A <A HREF='Notation.html'><CODE>Notation</CODE></A> node does not have any parent.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-publicId><CODE>&nbsp;publicId</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getPublicId()'>getPublicId</a>
</TD>
<TD><P>The public identifier of this notation. If the 
	public identifier was not specified, this is <code>null</code>.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-systemId><CODE>&nbsp;systemId</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSystemId()'>getSystemId</a>
</TD>
<TD><P>The system identifier of this notation. If the 
	system identifier was not specified, this is <code>null</code>.
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Notation
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-publicId>publicId</a></code> property.
	*/
	String getPublicId ();


	/**
	 * Returns the value of the <code><a href=#att-systemId>systemId</a></code> property.
	*/
	String getSystemId ();


}
