// filename: granflx2.cpp




//***********************************************************************


#include <iostream.h>
#include <math.h>



// function definition for x_value, the value of x after iteration

float x_value (float,float);





void main()
{
  double up, UP=0.0, time, f, A, E, z, stress=0.0, strain=0.0, V=0.0, t=0.0, dt=0.0, g=0.0,height=0.0;
  double D=0.0, R=0.0, C=0.0, mercd=0.0, P, dp, Flux, vol,x=0.0;
  double modulus=0.0, zed=0.0, Y; 
  int N=1000;




  cout << "Enter the value of UP, the gauge pressure"
          "\nupstream of membrane - capillary blood vessel"
	  "\npressure or atmospheric pressure (mmHg): ";
  cin >> up;
  cout << "\nEnter the membrane flux per unit driving force"
	  "\npressure, f (m3/cm2.min.Pa): ";
  cin >> f;
  cout << "\nEnter the wound area, A (cm2): ";
  cin >> A;
  cout << "\nEnter the time (min): ";
  cin >> time;




//**********************************************************************************


 
  D = (sqrt ( (4.0 * A) / 3.14)/ 100.0);      // to determine the diameter
					      // of the wound dressing (m)
  V = 0.0;
  P = 0.0;                                    // initial pressure is equal to zero
  t = 0.0;

  dt = (time / N); 			      // the smaller the time interval the
  					      // more accurate the answer (min)
  UP = (( 100000.0 * up) / 750.0);	      // to convert from mmHg to Pa





  for ( N=1; N<=1000; N++ )
     {
      t = t + dt;
      dp = UP - P;                            // this is in fact a constant value
      Flux = f * dp;
      V = V + (Flux * A * dt);		      // (m3)
      vol = V * 1000000.0;





      x = x_value (V,D);		      // call to function for x value





      
      height = x * 1000.0;                    // to convert the height above
				              // the wound dressing from (m) to (mm).

      g = D / 2.0;
      R = ( x/2.0 + ((D * D)/(8.0 * x)));     // units of (m)
      


      strain = ( 2.0 * x * x)/((3.0 * g * g) * (1.0 + ((2.0 * x * x)/(g * g))));





      Y = t / 60;   			      // time in hours
      zed = ( 9.576e-6 * Y * Y * Y ) - ( 7.453e-4 * Y * Y ) + ( 0.024127 * Y ) + 2.45;
					      // thickness in (mm)
      z = zed / 1000.0;			      // to convert from (mm) to (m)
      modulus = ( -2.931e-6 * Y * Y * Y ) + ( 2.375e-4 * Y * Y ) - ( 0.005486 * Y ) + 0.364;
					      // Young's Modulus in (MPa)
      E = modulus * 1e6;		      // to convert from (MPa) to (Pa)





       
      stress = E * strain;
      C = stress * z;

        
      P = ((2.0 * C) / R);    		      // in units of Pa
      mercd = 750.0 * P / 100000.0; 	      // to convert everything to mmHg
     }



//**********************************************************************************




  if (P >= UP)
         cout << "\n\n\n\n\The pressure beneath the wound dressing is (mmHg): "
              << up << endl;
  else

 	 cout << "\n\n\n\n\The pressure beneath the wound dressing is (mmHg): "
     	      << mercd << endl;
 	 cout << "\nThe value of x is (m): " << x << endl;
	 cout << "\nThe height of the wound dressing is (mm): "
     	      << height << endl;
 	 cout << "\nThe volume beneath the wound dressing is (ml): "
	      << vol << endl;
	 cout << "\nThe thickness of the dressing is (mm): "
              << z << endl;
	 cout << "\nThe Young's Modulus is (Pa): "
	      << E << endl;	 	 
	 cout << "\nThe time is (mins): "
	      << time << endl;

}










// function definition for the iteration of x

float x_value (float V, float D)
{
  float x = 0.0, xnew = 0.0;

      do
      {
            xnew = x;
	    x = ((6.0 * V / 3.14) / ((0.75 * D * D) + (x * x)));

      } while (( x - xnew ) > (1.0/ 10000000.0));
  return x;
}