/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class MethodSignatureEnhancer
implements IOTConstants,
TypeConstants,
ClassFileConstants {
    private static final char[] OBJECT_SIGNATURE = "Ljava/lang/Object;".toCharArray();
    private static final char[][] ENHANCING_ARG_NAMES;
    public static final int ENHANCING_ARG_LEN;
    public static final char[] UNUSED_ARGS;
    private static final boolean JAMVM_ASPECTBI;

    static {
        boolean bl = JAMVM_ASPECTBI = System.getProperty("ot.jamvm.aspectBI") != null;
        ENHANCING_ARG_NAMES = (char[][])(CallinImplementorDyn.DYNAMIC_WEAVING ? (char[][])new char[][]{"_OT$baseArg".toCharArray(), "_OT$teams".toCharArray(), "_OT$index".toCharArray(), "_OT$callinIds".toCharArray(), "_OT$boundMethodId".toCharArray(), "_OT$args".toCharArray()} : (JAMVM_ASPECTBI ? (Object)new char[][]{"_OT$teamIterator".toCharArray(), "_OT$bindIdx".toCharArray(), "_OT$baseMethodTag".toCharArray(), "_OT$unusedArgs".toCharArray()} : (char[][])new char[][]{"_OT$teams".toCharArray(), "_OT$teamIDs".toCharArray(), "_OT$idx".toCharArray(), "_OT$bindIdx".toCharArray(), "_OT$baseMethodTag".toCharArray(), "_OT$unusedArgs".toCharArray()}));
        ENHANCING_ARG_LEN = ENHANCING_ARG_NAMES.length;
        UNUSED_ARGS = ENHANCING_ARG_NAMES[ENHANCING_ARG_LEN - 1];
    }

    private static TypeBinding[] getEnhancingArgTypes(Scope scope) {
        if (CallinImplementorDyn.DYNAMIC_WEAVING) {
            return new TypeBinding[]{scope.getType(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE, 3), scope.createArrayType(scope.getOrgObjectteamsITeam(), 1), TypeBinding.INT, scope.createArrayType(TypeBinding.INT, 1), TypeBinding.INT, scope.createArrayType(scope.getJavaLangObject(), 1)};
        }
        if (JAMVM_ASPECTBI) {
            return new TypeBinding[]{scope.getJavaLangObject(), TypeBinding.INT, TypeBinding.INT, scope.createArrayType(scope.getJavaLangObject(), 1)};
        }
        return new TypeBinding[]{scope.createArrayType(scope.getOrgObjectteamsITeam(), 1), scope.createArrayType(TypeBinding.INT, 1), TypeBinding.INT, TypeBinding.INT, TypeBinding.INT, scope.createArrayType(scope.getJavaLangObject(), 1)};
    }

    public static Argument[] enhanceArguments(Argument[] arguments, char[] namePrefix, boolean isWrapper, AstGenerator gen) {
        TypeReference[] typeReferenceArray;
        int fullLen = ENHANCING_ARG_LEN;
        if (arguments != null) {
            fullLen += arguments.length;
        }
        Argument[] newArgs = new Argument[fullLen];
        if (CallinImplementorDyn.DYNAMIC_WEAVING) {
            TypeReference[] typeReferenceArray2 = new TypeReference[6];
            typeReferenceArray2[0] = gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE);
            typeReferenceArray2[1] = gen.qualifiedArrayTypeReference(ORG_OBJECTTEAMS_ITEAM, 1);
            typeReferenceArray2[2] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray2[3] = new ArrayTypeReference(TypeConstants.INT, 1, gen.pos);
            typeReferenceArray2[4] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray = typeReferenceArray2;
            typeReferenceArray2[5] = gen.qualifiedArrayTypeReference(JAVA_LANG_OBJECT, 1);
        } else if (JAMVM_ASPECTBI) {
            TypeReference[] typeReferenceArray3 = new TypeReference[4];
            typeReferenceArray3[0] = gen.qualifiedTypeReference(JAVA_LANG_OBJECT);
            typeReferenceArray3[1] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray3[2] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray = typeReferenceArray3;
            typeReferenceArray3[3] = gen.qualifiedArrayTypeReference(JAVA_LANG_OBJECT, 1);
        } else {
            TypeReference[] typeReferenceArray4 = new TypeReference[6];
            typeReferenceArray4[0] = gen.qualifiedArrayTypeReference(ORG_OBJECTTEAMS_ITEAM, 1);
            typeReferenceArray4[1] = new ArrayTypeReference(TypeConstants.INT, 1, gen.pos);
            typeReferenceArray4[2] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray4[3] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray4[4] = gen.singleTypeReference(TypeConstants.INT);
            typeReferenceArray = typeReferenceArray4;
            typeReferenceArray4[5] = gen.qualifiedArrayTypeReference(JAVA_LANG_OBJECT, 1);
        }
        TypeReference[] enhanceTypes = typeReferenceArray;
        int prefixLen = 0;
        if (isWrapper && arguments != null) {
            newArgs[prefixLen++] = arguments[0];
        }
        int i = 0;
        while (i < ENHANCING_ARG_LEN) {
            newArgs[i + prefixLen] = gen.argument(CharOperation.concat(namePrefix, ENHANCING_ARG_NAMES[i]), enhanceTypes[i], 16);
            ++i;
        }
        if (arguments != null) {
            System.arraycopy(arguments, prefixLen, newArgs, ENHANCING_ARG_LEN + prefixLen, arguments.length - prefixLen);
        }
        return newArgs;
    }

    public static Expression[] enhanceArguments(Expression[] arguments, int pos) {
        AstGenerator gen = new AstGenerator(pos, pos);
        int fullLen = ENHANCING_ARG_LEN;
        if (arguments != null) {
            fullLen += arguments.length;
        }
        Expression[] enhancedArgs = new Expression[fullLen];
        int i = 0;
        while (i < ENHANCING_ARG_LEN) {
            enhancedArgs[i] = gen.singleNameReference(ENHANCING_ARG_NAMES[i]);
            ++i;
        }
        if (arguments != null) {
            System.arraycopy(arguments, 0, enhancedArgs, ENHANCING_ARG_LEN, arguments.length);
        }
        return enhancedArgs;
    }

    public static TypeBinding[] enhanceParameters(Scope scope, TypeBinding[] parameters) {
        int fullLen = parameters.length + ENHANCING_ARG_LEN;
        TypeBinding[] newParameters = new TypeBinding[fullLen];
        System.arraycopy(MethodSignatureEnhancer.getEnhancingArgTypes(scope), 0, newParameters, 0, ENHANCING_ARG_LEN);
        System.arraycopy(parameters, 0, newParameters, ENHANCING_ARG_LEN, parameters.length);
        return newParameters;
    }

    public static TypeBinding generalizeReturnType(MethodDeclaration methodDecl, TypeBinding returnType) {
        MethodModel.saveReturnType(methodDecl, returnType);
        methodDecl.returnType.resolvedType = returnType = methodDecl.scope.getJavaLangObject();
        return returnType;
    }

    public static TypeBinding getGeneralizedReturnType(TypeBinding orig, LookupEnvironment environment) {
        if (orig.isBaseType()) {
            return environment.getType(TypeConstants.JAVA_LANG_OBJECT);
        }
        return orig;
    }

    public static char[] generalizeReturnInSignature(char[] signature) {
        int rparenPos = CharOperation.indexOf(')', signature);
        if (rparenPos == signature.length - 2) {
            return CharOperation.concat(CharOperation.subarray(signature, 0, rparenPos + 1), OBJECT_SIGNATURE);
        }
        return signature;
    }

    public static Argument[] maybeRetrenchArguments(MethodDeclaration methodDecl) {
        if (!methodDecl.isCallin()) {
            return methodDecl.arguments;
        }
        int len = methodDecl.arguments.length;
        Argument[] result = new Argument[len - ENHANCING_ARG_LEN];
        System.arraycopy(methodDecl.arguments, ENHANCING_ARG_LEN, result, 0, result.length);
        return result;
    }

    public static Expression[] retrenchBasecallArguments(Expression[] arguments, boolean isEnhanced) {
        int discard;
        if (arguments == null) {
            return null;
        }
        int len = arguments.length;
        int n = discard = CallinImplementorDyn.DYNAMIC_WEAVING ? 0 : 1;
        if (isEnhanced) {
            discard += ENHANCING_ARG_LEN;
        }
        Expression[] result = new Expression[len - discard];
        System.arraycopy(arguments, discard, result, 0, result.length);
        return result;
    }

    public static TypeBinding[] retrenchParameterTypes(TypeBinding[] parameters) {
        if (parameters == null) {
            return null;
        }
        int len = parameters.length;
        if (len >= ENHANCING_ARG_LEN) {
            TypeBinding[] result = new TypeBinding[len - ENHANCING_ARG_LEN];
            System.arraycopy(parameters, ENHANCING_ARG_LEN, result, 0, result.length);
            return result;
        }
        return parameters;
    }

    public static void beautifyTypesString(StringBuffer types, boolean makeShort) {
        String prefix;
        String typeString = types.toString();
        String string = CallinImplementorDyn.DYNAMIC_WEAVING ? (makeShort ? "IBoundBase, Team[], int, int[], int, Object[]" : "org.objectteams.IBoundBase, org.objectteams.ITeam[], int, int[] int, java.lang.Object[]))") : (JAMVM_ASPECTBI ? (makeShort ? "Object, int, int, Object[]" : "java.lang.Object, int, int, java.lang.Object[]))") : (prefix = makeShort ? "ITeam[], int[], int, int, int, Object[]" : "org.objectteams.ITeam[], int[] int, int, int, java.lang.Object[]))"));
        if (typeString.startsWith(prefix)) {
            types.delete(0, prefix.length());
            if (types.length() > 0 && types.charAt(0) == ',') {
                types.delete(0, 2);
            }
        }
    }

    public static Argument[] getSourceArguments(AbstractMethodDeclaration methodDeclaration) {
        Argument[] arguments = methodDeclaration.arguments;
        if (methodDeclaration.isCallin()) {
            assert (arguments != null);
            int len = arguments.length - ENHANCING_ARG_LEN;
            assert (len >= 0);
            if (len == 0) {
                arguments = null;
            } else {
                Argument[] argumentArray = arguments;
                arguments = new Argument[len];
                System.arraycopy(argumentArray, ENHANCING_ARG_LEN, arguments, 0, len);
            }
        } else if (CharOperation.prefixEquals(IOTConstants.BASE_PREDICATE_PREFIX, methodDeclaration.selector)) {
            return null;
        }
        return arguments;
    }

    public static boolean isEnhanced(AbstractMethodDeclaration methodDeclaration) {
        Argument[] arguments = methodDeclaration.arguments;
        if (arguments == null || arguments.length < ENHANCING_ARG_LEN) {
            return false;
        }
        int i = 0;
        while (i < ENHANCING_ARG_LEN) {
            if (!CharOperation.endsWith(arguments[i].name, ENHANCING_ARG_NAMES[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

