/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AnnotationBinding;
import org.eclipse.jdt.core.dom.BindingComparator;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.objectteams.otdt.core.compiler.InferenceKind;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;

class MethodMappingBinding
implements IMethodMappingBinding {
    private CallinCalloutBinding binding;
    private BindingResolver resolver;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding baseClass;
    private IMethodBinding roleMethod;
    private IMethodBinding[] baseMethods;
    private IVariableBinding baseField;
    private IAnnotationBinding[] annotations;

    MethodMappingBinding(BindingResolver resolver, CallinCalloutBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public String getName() {
        if (this.name == null) {
            this.name = new String(this.binding.readableName());
        }
        return this.name;
    }

    public ITypeBinding getDeclaringRoleClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding._declaringRoleClass);
        }
        return this.declaringClass;
    }

    public ITypeBinding getReferencedBaseClass() {
        if (this.baseClass == null) {
            this.baseClass = this.resolver.getTypeBinding(this.binding._declaringRoleClass.baseclass());
        }
        return this.baseClass;
    }

    public IMethodBinding getRoleMethod() {
        if (this.roleMethod == null) {
            this.roleMethod = this.resolver.getMethodBinding(this.binding._roleMethodBinding);
        }
        return this.roleMethod;
    }

    public IMethodBinding[] getBaseMethods() {
        if (this.baseMethods == null) {
            MethodBinding[] methodBindings = this.binding._baseMethods;
            if (methodBindings == null) {
                return new IMethodBinding[0];
            }
            this.baseMethods = new IMethodBinding[methodBindings.length];
            int i = 0;
            while (i < methodBindings.length) {
                this.baseMethods[i] = this.resolver.getMethodBinding(methodBindings[i]);
                ++i;
            }
        }
        return this.baseMethods;
    }

    public IVariableBinding getBaseField() {
        if (this.baseField == null) {
            FieldBinding fieldBinding = this.binding._baseField;
            if (fieldBinding == null) {
                return null;
            }
            this.baseField = this.resolver.getVariableBinding(fieldBinding);
        }
        return this.baseField;
    }

    public String[] getBaseArgumentNames() {
        MethodBinding[] methodBindings = this.binding._baseMethods;
        if (methodBindings != null && methodBindings.length > 0) {
            Argument[] args;
            String[] result = new String[methodBindings[0].parameters.length];
            AbstractMethodDeclaration methodDecl = methodBindings[0].sourceMethod();
            if (methodDecl != null && (args = methodDecl.arguments) != null) {
                int i = 0;
                while (i < args.length) {
                    result[i] = String.valueOf(args[i].name);
                    ++i;
                }
                return result;
            }
            int i = 0;
            while (i < result.length) {
                result[i] = "arg" + i;
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    public int getKind() {
        return 7;
    }

    public int getModifiers() {
        if (this.binding.type == 1) {
            switch (this.binding.callinModifier) {
                case 121: {
                    return 16384;
                }
                case 119: {
                    return 65536;
                }
                case 120: {
                    return 4096;
                }
            }
            return 0;
        }
        return 0;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isCallin() {
        return this.binding.isCallin();
    }

    public String getKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDeclaringRoleClass().getKey());
        buffer.append('/');
        buffer.append(this.getName());
        buffer.append(')');
        return buffer.toString();
    }

    public String toString() {
        return this.binding.toString();
    }

    public IJavaElement getJavaElement() {
        return null;
    }

    public boolean isEqualTo(IBinding other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MethodMappingBinding)) {
            return !this.isCallin() && this.getRoleMethod().isEqualTo(other);
        }
        CallinCalloutBinding otherBinding = ((MethodMappingBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public IAnnotationBinding[] getAnnotations() {
        int length;
        if (this.annotations != null) {
            return this.annotations;
        }
        org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding[] annots = this.binding.getAnnotations();
        int n = length = annots == null ? 0 : annots.length;
        if (annots == null) {
            this.annotations = AnnotationBinding.NoAnnotations;
            return AnnotationBinding.NoAnnotations;
        }
        IAnnotationBinding[] domInstances = new AnnotationBinding[length];
        int i = 0;
        while (i < length) {
            IAnnotationBinding annotationInstance = this.resolver.getAnnotationInstance(annots[i]);
            if (annotationInstance == null) {
                this.annotations = AnnotationBinding.NoAnnotations;
                return AnnotationBinding.NoAnnotations;
            }
            domInstances[i] = annotationInstance;
            ++i;
        }
        this.annotations = domInstances;
        return domInstances;
    }

    public boolean isRecovered() {
        return false;
    }

    public InferenceKind getInferenceKind() {
        if (this.binding != null) {
            return this.binding.inferred;
        }
        return InferenceKind.NONE;
    }
}

