/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IFieldAccessSpec;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCalloutToFieldMapping;
import org.eclipse.objectteams.otdt.internal.core.util.FieldData;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class CalloutToFieldMapping
extends AbstractCalloutMapping
implements ICalloutToFieldMapping {
    private boolean isOverride;
    private IField baseField;
    private IFieldAccessSpec baseFieldHandle;

    public CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType role, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride, boolean addAsChild) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, role, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, addAsChild);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, parentRole, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, true);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, correspondingJavaElem, parentRole, roleMethodHandle, hasSignature, addAsChild);
        this.isOverride = isOverride;
        this.baseFieldHandle = baseFieldHandle;
    }

    public IMethodMapping createStealthMethodMapping() {
        CalloutToFieldMapping result = new CalloutToFieldMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), 9, (IType)this.getCorrespondingJavaElement().getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.getBaseFieldHandle(), this.hasSignature(), this.isOverride(), false);
        result.mimicMethodDecl = true;
        result.originalMethodMapping = this;
        return result;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public String getElementName() {
        if (this.mimicMethodDecl) {
            if (this.roleMethodHandle != null) {
                return this.roleMethodHandle.getSelector();
            }
            return "(unknown role method)";
        }
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" -> ");
        if (this.hasSignature()) {
            name.append(this.baseFieldHandle.toString());
        } else {
            name.append(this.baseFieldHandle.getSelector());
        }
        return name.toString();
    }

    public int getMappingKind() {
        return 104;
    }

    public IField getBoundBaseField() throws JavaModelException {
        if (this.baseField == null) {
            this.baseField = this.findBaseField();
        }
        return this.baseField;
    }

    public IFieldAccessSpec getBaseFieldHandle() {
        return this.baseFieldHandle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CalloutToFieldMapping)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "callout to field" + super.toString();
    }

    private IField findBaseField() throws JavaModelException {
        IType baseClass = ((IRoleType)this.getParent()).getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        return this.findField(typeParents, this.baseFieldHandle);
    }

    private IField findField(IType[] types, IFieldAccessSpec fieldHandle) throws JavaModelException {
        int idx = 0;
        while (idx < types.length) {
            IField[] fields = types[idx].getFields();
            int idy = 0;
            while (idy < fields.length) {
                IField tmpField = fields[idy];
                if (tmpField.getElementName().equals(fieldHandle.getSelector())) {
                    return tmpField;
                }
                ++idy;
            }
            ++idx;
        }
        return null;
    }

    protected char getMappingKindChar() {
        if (this.baseFieldHandle.isSetter()) {
            if (this.isOverride) {
                return 'S';
            }
            return 's';
        }
        if (this.isOverride) {
            return 'G';
        }
        return 'g';
    }

    protected void getBaseMethodsForHandle(StringBuffer buff) {
        this.escapeMementoName(buff, this.baseFieldHandle.getSelector());
        buff.append('~');
        this.escapeMementoName(buff, this.baseFieldHandle.getFieldType());
    }

    public static IFieldAccessSpec createFieldData(MementoTokenizer memento, boolean isSetter) {
        String selector = memento.nextToken();
        String cur = memento.nextToken();
        if (cur.charAt(0) == '~') {
            cur = memento.nextToken();
        }
        StringBuffer buffer = new StringBuffer();
        while (cur.length() == 1 && '[' == cur.charAt(0)) {
            buffer.append('[');
            if (!memento.hasMoreTokens()) break;
            cur = memento.nextToken();
        }
        buffer.append(cur);
        String fieldType = buffer.toString();
        memento.nextToken();
        return new FieldData(selector, fieldType, isSetter);
    }

    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCalloutToFieldMapping resolvedHandle = new ResolvedCalloutToFieldMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), this.getElementType(), (IType)this.getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.baseFieldHandle, this.hasSignature(), this.isOverride(), new String(uniqueKey));
        if (this.isStealthMethodMapping()) {
            resolvedHandle.originalMethodMapping = this.originalMethodMapping;
        }
        return resolvedHandle;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        return new String[0];
    }

    public ILocalVariable[] getParameters() throws JavaModelException {
        return null;
    }
}

