/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class WordValueAttribute
extends AbstractAttribute {
    private int _value;

    public static void maybeCreateClassFlagsAttribute(TypeDeclaration type) {
        TypeModel model = null;
        int classFlags = 0;
        if (type.binding.isDirectRole()) {
            model = type.getRoleModel();
            classFlags = 2;
        } else if (type.binding.isRole()) {
            model = type.getRoleModel();
            classFlags = 4;
        }
        if (type.isTeam()) {
            if (model == null) {
                model = type.getTeamModel();
            }
            classFlags |= 1;
        }
        if (type.isPurelyCopied) {
            classFlags |= 8;
        }
        if (type.isRoleFile()) {
            classFlags |= 0x10;
        }
        if (TypeAnalyzer.isTopConfined(type.binding) || TypeAnalyzer.extendsOTConfined(type)) {
            classFlags |= 0x40;
        }
        if (model != null) {
            model.addAttribute(new WordValueAttribute(OT_CLASS_FLAGS, classFlags));
        }
    }

    public static void addClassFlags(TypeModel classModel, int flags) {
        if (classModel._attributes != null) {
            AbstractAttribute[] abstractAttributeArray = classModel._attributes;
            int n = classModel._attributes.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAttribute attribute = abstractAttributeArray[n2];
                if (attribute.nameEquals(OT_CLASS_FLAGS)) {
                    ((WordValueAttribute)attribute)._value |= flags;
                    return;
                }
                ++n2;
            }
        }
        classModel.addAttribute(new WordValueAttribute(OT_CLASS_FLAGS, flags));
    }

    public static WordValueAttribute readClassFlags(ClassFileStruct reader, int readOffset, int[] constantPoolOffsets) {
        int value = reader.u2At(readOffset);
        return new WordValueAttribute(reader, OT_CLASS_FLAGS, value);
    }

    public static AbstractAttribute readCompilerVersion(ClassFileReader reader, int readOffset, int[] constantPoolOffsets) {
        int value = reader.u2At(readOffset);
        return new WordValueAttribute(reader, OT_COMPILER_VERSION, value);
    }

    public static WordValueAttribute modifiersAttribute(int modifiers) {
        return new WordValueAttribute(MODIFIERS_NAME, modifiers);
    }

    public static void readModifiers(MethodInfo method, int readOffset) {
        int value = method.u2At(readOffset);
        method.setAccessFlags(value);
    }

    public static void readModifiers(FieldInfo field, int readOffset) {
        int value = field.u2At(readOffset);
        field.setAccessFlags(value);
    }

    public static WordValueAttribute roleClassMethodModifiersAttribute(int modifiers) {
        return new WordValueAttribute(ROLECLASS_METHOD_MODIFIERS_NAME, modifiers);
    }

    public static void readRoleClassMethodModifiersAttribute(MethodInfo info, int readOffset) {
        int binaryFlags = info.getModifiers() & 0xFFFFFFF8;
        int newFlags = info.u2At(readOffset);
        info.setAccessFlags(binaryFlags | newFlags);
    }

    public static WordValueAttribute readCallinFlags(MethodInfo method, int readOffset) {
        int value = method.u2At(readOffset);
        method.setAccessFlags(method.getModifiers() | Integer.MIN_VALUE);
        WordValueAttribute result = WordValueAttribute.callinFlagsAttribute(value);
        result._methodInfo = method;
        return result;
    }

    public static WordValueAttribute callinFlagsAttribute(int modifiers) {
        return new WordValueAttribute(CALLIN_FLAGS, modifiers);
    }

    public static WordValueAttribute compilerVersionAttribute() {
        assert (IOTConstants.OTVersion.getMajor() <= 7);
        assert (IOTConstants.OTVersion.getMinor() <= 9);
        assert (IOTConstants.OTVersion.getRevsion() <= 31);
        return new WordValueAttribute(OT_COMPILER_VERSION, (IOTConstants.OTVersion.getMajor() << 9) + (IOTConstants.OTVersion.getMinor() << 5) + IOTConstants.OTVersion.getRevsion());
    }

    public void addBits(int flags) {
        this._value |= flags;
    }

    protected WordValueAttribute(char[] name, int value) {
        super(name);
        this._value = value;
    }

    protected WordValueAttribute(ClassFileStruct reader, char[] name, int value) {
        this(name, value);
        this._reader = reader;
    }

    int size() {
        return 8;
    }

    public void write(ClassFile classFile) {
        super.write(classFile);
        if (this._contentsOffset + 8 > this._contents.length) {
            this._contents = classFile.getResizedContents(8);
        }
        int attributeNameIndex = this._constantPool.literalIndex(this._name);
        this._contents[this._contentsOffset++] = (byte)(attributeNameIndex >> 8);
        this._contents[this._contentsOffset++] = (byte)attributeNameIndex;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 0;
        this._contents[this._contentsOffset++] = 2;
        this._contents[this._contentsOffset++] = (byte)(this._value >> 8);
        this._contents[this._contentsOffset++] = (byte)this._value;
        this.writeBack(classFile);
    }

    public void evaluate(Binding binding, LookupEnvironment environment, char[][][] missingTypeNames) {
        if (CharOperation.equals(this._name, OT_CLASS_FLAGS)) {
            this.checkBindingMismatch(binding, 0);
            BinaryTypeBinding type = (BinaryTypeBinding)binding;
            if ((this._value & 2) != 0) {
                type.modifiers |= 0x1000000;
            }
            if ((this._value & 1) != 0) {
                type.modifiers |= 0x8000;
            }
            if ((this._value & 0x20) != 0) {
                type.modifiers |= 0x10000000;
            }
            if ((this._value & 4) != 0) {
                type.setIsRoleLocal();
            }
            if ((this._value & 0x18) != 0) {
                type.roleModel.setExtraRoleFlags(this._value & 0x18);
            }
            if ((this._value & 0x40) != 0) {
                ReferenceBinding superclass;
                boolean wasMissingType = false;
                if (missingTypeNames != null) {
                    int i = 0;
                    int max = missingTypeNames.length;
                    while (i < max) {
                        if (CharOperation.equals(IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED, missingTypeNames[i])) {
                            wasMissingType = true;
                            break;
                        }
                        ++i;
                    }
                }
                if ((superclass = environment.getTypeFromCompoundName(IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED, false, wasMissingType)) instanceof UnresolvedReferenceBinding) {
                    superclass = ((UnresolvedReferenceBinding)superclass).resolve(environment, false);
                }
                type.resetSuperclass(superclass);
            }
        } else if (CharOperation.equals(this._name, IOTConstants.OT_COMPILER_VERSION)) {
            this.checkBindingMismatch(binding, 0);
            BinaryTypeBinding type = (BinaryTypeBinding)binding;
            if (type.isRole()) {
                type.roleModel._compilerVersion = this._value;
            }
            if (type.isTeam()) {
                type.getTeamModel()._compilerVersion = this._value;
            }
            if (this._value < IOTConstants.OTVersion.getCompilerVersionMin()) {
                environment.problemReporter.incompatibleOTJByteCodeVersion(((BinaryTypeBinding)binding).getFileName(), WordValueAttribute.getBytecodeVersionString(this._value));
            }
        }
    }

    public boolean evaluate(MethodInfo info, MethodBinding method, LookupEnvironment environment) {
        if (this._methodInfo != info) {
            return false;
        }
        if (CharOperation.equals(this._name, IOTConstants.CALLIN_FLAGS)) {
            MethodModel.getModel((MethodBinding)method).callinFlags = this._value & 0xFF;
            int typeCode = this._value & 0xF00;
            if (typeCode != 0) {
                BaseTypeBinding returnType;
                switch (typeCode) {
                    case 256: {
                        returnType = TypeBinding.VOID;
                        break;
                    }
                    case 512: {
                        returnType = TypeBinding.BOOLEAN;
                        break;
                    }
                    case 768: {
                        returnType = TypeBinding.BYTE;
                        break;
                    }
                    case 1024: {
                        returnType = TypeBinding.CHAR;
                        break;
                    }
                    case 1280: {
                        returnType = TypeBinding.SHORT;
                        break;
                    }
                    case 1536: {
                        returnType = TypeBinding.DOUBLE;
                        break;
                    }
                    case 1792: {
                        returnType = TypeBinding.FLOAT;
                        break;
                    }
                    case 2048: {
                        returnType = TypeBinding.INT;
                        break;
                    }
                    case 2304: {
                        returnType = TypeBinding.LONG;
                        break;
                    }
                    default: {
                        throw new InternalCompilerError("Unexpected callin return type code " + typeCode);
                    }
                }
                MethodModel.saveReturnType(method, (TypeBinding)returnType);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "OT-Attribute " + new String(this._name) + ": " + this._value;
    }

    public int getValue() {
        return this._value;
    }

    public static String getBytecodeVersionString(int compilerVersion) {
        String version = compilerVersion > 0 ? String.valueOf(String.valueOf(compilerVersion >>> 9)) + "." + String.valueOf(compilerVersion >>> 5 & 0xF) + "." + String.valueOf(compilerVersion & 0x1F) : "(undefined)";
        return version;
    }
}

