Program l5_cycle;

{ Program which enables open loop monitoring of CBi at a sampling interval of 15 minutes }
uses dos,crt,graph,async4u;
Type
Absorbance_Values = Array[1..100] of Real;
Urea_Concentrations = Array[1..50] of Real;

const NUL = #0; STX = #2; ETX = #3; EOT = #4; ENQ = #5;
      ACK = #6; NAK = #21;

var     devicenum          : char;  {to address module number}
        devicecheck        : integer; {used in device checking loop }
        command            : string; {command to be sent}
        fail1, fail2       : boolean; {fail flags}
        instring           : string; {temp variable}
        Qstatus_string     : string; {to pass around result of Q enquiry}
        Qchar              : string; {Qbyte is 7th byte in Qstatus_string}
        reply              : string; {to get user input}
        Ba                 : integer; {base address for PC-30 board}
        absorbance         : Absorbance_Values; { array }
      graphdriver,graphmode: integer;
        pathtodriver       : string;
   slope,intercept,AbBlank : real;
        Urea_Conc          : Urea_Concentrations;

procedure buildbcc(var outstring : string);  {takes command string and
                       adds comms protocol as per Hamilton doc. V1.0 page 9-3}

var    bccount : byte;
       counter : integer;

begin
  outstring := outstring + ETX; {concat to ETX}
  bccount := ord(outstring[1]);
  for counter := 2 to length(outstring) do
    bccount := bccount xor ord(outstring[counter]);
  bccount := 127-bccount; {complement}
  outstring := STX + outstring + chr(bccount);
end;


procedure readback(var instring : string;
                   var ack_fail, no_response : boolean);

var inchar : char;

begin
  delay(100);
  instring := ''; {initialize input use zero length}
  no_response := true; ack_fail := true;
  while async_buffer_check(inchar) do
    begin
      no_response := false;
      {writeln('Found ',ord(inchar),'  ',char(inchar));}
      instring := instring + inchar;
    end;
  if copy(instring,1,3) <> NAK then ack_fail := false;
end;



procedure are_you_there(charaddress : char;
                        var fail : boolean);

var enquiry_string : string;
    ack_fail, no_response : boolean;

begin
  async_send_string(EOT + '0' + charaddress + ENQ);
  readback(enquiry_string,ack_fail,no_response);
  if (ack_fail or no_response) then fail := true
    else fail := false;
  end;


procedure get_Q_status;


begin
  async_send_string(STX+'Q'+ ETX + '-');
  readback(Qstatus_string,fail1,fail2);
  Qchar := copy(Qstatus_string,7,1);
  {writeln('                Qchar = ',Qchar,'  fail1 = ',fail1,'  fail2 =',fail2);}
  {if (fail1 or fail2)  then
       writeln('Q status request fails')}

 end;


procedure actonQchar; {do something if Qbyte needs it!}

begin
  if  (Qchar <> '@') or (Qchar <> 'A') then
    begin
      if Qchar = 'H' then
        begin
          writeln ('Syntax error in previous command...abort');
          halt;
        end;
      if Qchar = 'P' then
        begin
          writeln('Instrument error after previous command...abort');
          halt;
        end;
    end;
end;


procedure docommand(charaddress : char; command : string);

var outstring : string;
    inchar : char;

begin
  repeat
    async_send_string(EOT + '0' + charaddress + ENQ);
    get_Q_status;
    actonQchar;
  until (Qchar = '@') or (keypressed) or (Qchar = 'A');

 outstring := command;
  buildbcc(outstring);
  async_send_string(ACK + outstring); {send command preceded with ACK}
  readback(instring,fail1,fail2);
  {if not (fail1 or fail2) then
    write('Command sent successfully        ')
    else
      begin
        if fail2 and not (command ='G') then
          writeln('Device does not respond')
          else if fail1 then
            writeln('Device does not acknowledge command correctly');
      end;}
    end;


procedure initialise (devicenum : char);

begin
  are_you_there(devicenum,fail1);
  if fail1 then
    begin
      writeln('areyouthere fails with devicenum = ',devicenum);
      writeln('abort...!');
    end;
end;

procedure instruct(devicenum : char; command: string);

begin
  async_send_string(EOT+'0'+devicenum+ENQ);
  docommand(devicenum,command);
end;

procedure go(devicenum : char);

begin
  instruct(devicenum,'G');
end;

procedure valve(devicenum, direction : char; degrees : string);

begin
  instruct(devicenum,'Vv'+direction+'w'+degrees);
end;

procedure pickup(devicenum : char; steps, speed : string);

begin
  instruct(devicenum,'Pp'+steps+'s'+speed);
end;

procedure dispense(devicenum : char; steps, speed, stopspeed : string);

begin
  instruct(devicenum,'Dd'+steps+'t'+speed+'u'+stopspeed);
end;

procedure Read_Port(var AbsorbValue:real);
var v_total,volts,sample_volts:Real;
                      T,data,d:Integer;
                       channel:Byte;
                            ch:Char;


 Begin
  Port[Ba+3]:=$92; {control register};
  channel:=0;
  V_total:=0;
  For d:=1 To 10 Do
   Begin
    Port[Ba+2]:=(channel shl 4)+2;
    Port[Ba+2]:=(channel shl 4)+3;
    For T:=1 To 16 Do
     Begin             { wait for 40 microseconds - A/D conversion time };
     End;
    data:=((Port[Ba+1] And $0F) shl 8)+Port[Ba];
    volts:=(data*0.002454);
    v_total:=v_total+volts;
   End;
   sample_volts:=(v_total/10);
   AbsorbValue:=sample_volts/4;
  End;

Procedure LoadOEM1;
 Begin
  Valve('1','0','0');
  Go('1');
  Pickup('1','760','100'); { Load OEM1 with reagent }
  Go('1');
  Valve('1','1','270');
  Go('1');
 End;

Procedure PurgeOEM3(a:integer;ValvePosition:string);
Var purges : integer;
 Begin
  Port[Ba+8]:=1;
  Initialise('2');
  Go('2');
  For purges:= 1 To 40 Do  { Purge OEM3 40 times }
   Begin
    If a<4 Then
     Valve('2','0',ValvePosition)   { was 1 }
    Else
     Valve('2','1',ValvePosition);  { was 0 }
    Go('2');
    PickUp('2','1000','1000');
    Go('2');
    If a<4 Then
     Valve('2','1','135')
    Else
     Valve('2','0','135');
    Go('2');
    Dispense('2','1000','1000','50');
    Go('2');
   End;
  {For purges:=1 To 10 Do
   Begin
    If a<4 Then
     Valve('2','0',ValvePosition)
    Else
     Valve('2','1',ValvePosition);
    Go('2');
    PickUp('2','1000','1000');
    Go('2');
    If a<4 Then
     Valve('2','1','135')
    Else
     Valve('2','0','135');
    Go('2');
    Dispense('2','1000','1000','50');
    Go('2');
   End;}
  Sound(600);
  Delay(500);
  NoSound;
  Delay(4500);
  {Port[Ba+8]:=0;}
 End;

Procedure LoadSample(a:integer;ValvePosition:string);
 Begin
  If a<4 Then
   Valve('2','0',ValvePosition)    { Load OEM3 syringe with sample }
  Else
   Valve('2','1',ValvePosition);
  Go('2');
  PickUp('2','1000','1000');  { added code }
  Go('2');
  {PickUp('2','680','1000');
  Go('2');}

  If a<4 Then
   Valve('2','1','135')
  Else
   Valve('2','0','135');
  Go('2');

  Dispense('2','430','1000','50');  { added code }
  Go('2');
  Dispense('2','60','1000','1000');
  Go('2');
  {Port[Ba+8]:=1;}
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(3000);
 End;

Procedure WashChamber;
Var b:integer;
 Begin
  For b:= 1 To 3 Do { Wash mixing chamber with sequence of reagent discharges }
   Begin
    If b=3 Then
     Dispense('1','150','400','50')
    Else
     Dispense('1','125','400','50');
    Go('1');
    Delay(2500);
    Port[Ba+8]:=1;  { Switch on roller pump to drain chamber }
     Delay(7000);    { Wait while pump drains chamber }
    Port[Ba+8]:=0;  { Switch off pump }
    Delay(2000);
   End;
 End;

Procedure Assay(a:integer);
 Var        AbsorbValue:real;
    b,t,x,xOld,y,yOld,x_text,y_text:integer;
                  UreaValue:string[5];
 Begin
  Sound(600);
  Delay(2500);
  NoSound;
 If a>1 Then
  Begin
   Dispense('1','150','100','50');    { Dispense half of the reagent }
   Go('1');
   Dispense('2','60','1000','1000'); { Dispense sample }
   Go('2');
   Dispense('1','210','400','50');   { Dispense rest of the reagent }
   Go('1');
   Valve('2','1','0');
   Go('2');
   Dispense('2','450','1000','50'); { Dispense residual sample to waste tube }
   Go('2');
   For b:=1 To 281 Do   { incubation period - 5 minutes in total }
   Delay(1000);
  End
 Else
  Begin
   Dispense('1','360','100','50');
   Go('1');
   Delay(5000);
  End;

  Port[Ba+8]:=1;
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(6000); { 6 second delay }
  Read_Port(AbsorbValue);
  absorbance[a]:=AbsorbValue;
  If a<5 Then
   writeln('Calibration test ',a,' : absorbance = ',AbsorbValue:4:3)
  Else
   Begin
    t:=(a-4)*15;
    Urea_Conc[a]:=((AbBlank-AbsorbValue)-intercept)/slope;
    x:=135+(a-5)*35;
    y:=Round(290-Urea_Conc[a]*3);
    If a>5 Then
     Begin
      xOld:=135+(a-6)*35;
      yOld:=Round(290-Urea_Conc[a-1]*3);
      Line(xOld,yOld,x,y);
      Circle(x,y,3);
     End
    Else
     Circle(x,y,3);
    x_text:=x;
    y_text:=y-11;
    Str(Urea_Conc[a]:5:2,UreaValue);
    OutTextXY(x_text,y_text,UreaValue);
   End;

  Sound(500);
  Delay(1500);
  Nosound;
 End;


Procedure Calibrate;
Var Conc1,Conc2,Conc3,AbStnd1,AbStnd2,AbStnd3,AbChange1,AbChange2,AbChange3,
    SigmaY,SigmaX,SigmaXY,SigmaXsqr,MeanX,MeanY:real;
                                  ValvePosition:string;
                                        a,c,d,n:integer;
 Begin
 {initgraph(graphdriver,graphmode,pathtodriver);}
  writeln('Enter the concentration (mg/dl) of standard 1');read(Conc1);
  writeln('Enter the concentration (mg/dl) of standard 2');read(Conc2);
  writeln('Enter the concentration (mg/dl) of standard 3');read(Conc3);
  For a:=1 To 4 Do
   Begin
    LoadOEM1;
    If a=1 Then ValvePosition:='225';
    If a=2 Then ValvePosition:='270';
    If a=3 Then ValvePosition:='315';
    If a=4 Then ValvePosition:='45';
    If a>1 Then
     Begin
      PurgeOEM3(a,ValvePosition);
      LoadSample(a,ValvePosition);
     End;
    WashChamber;
    Assay(a);
   End;

    AbBlank:=absorbance[1];
    AbStnd1:=absorbance[2];
    AbStnd2:=absorbance[3];
    AbStnd3:=absorbance[4];
    AbChange1:=AbBlank-AbStnd1;
    AbChange2:=AbBlank-AbStnd2;
    AbChange3:=AbBlank-AbStnd3;
    SigmaX:=0+Conc1+Conc2+Conc3;
    SigmaY:=0+AbChange1+AbChange2+AbChange3;
    SigmaXY:=Conc1*AbChange1+Conc2*AbChange2+Conc3*AbChange3;
    SigmaXsqr:=0+sqr(Conc1)+sqr(Conc2)+sqr(Conc3);
    n:=4;
    slope:=(n*SigmaXY-SigmaX*SigmaY)/(n*SigmaXsqr-sqr(SigmaX));
    MeanY:=SigmaY/n;
    MeanX:=SigmaX/n;
    intercept:=MeanY-slope*MeanX;
    { Least squares diff. equ. is Absorbance change = slope*conc + intercept }
    writeln('slope = ',slope:5:4,' intercept = ',intercept:5:4);
   {restorecrtmode;}
 End;

Procedure Plot_Graph(Qb,Qd,K,V:real;T:integer);
 var a,b,c,d,e,f,g,h:integer;
     concs,time,Bflow,Dflow,clearance,volume,duration:string[3];
 Begin
  {ClrScr;
  InitGraph(GraphDriver,GraphMode,PathToDriver);}

  OutTextXY(165,15,'Urea Nitrogen Concentration vs. Time'); { Graph }
  Line(165,25,455,25);                                      { title }

  Line(1,1,1,347);       { Outline }
  Line(1,347,719,347);   {   of    }
  Line(719,347,719,1);   { screen  }
  Line(719,1,1,1);       { frame   }
  Line(550,1,550,347);

  Line(100,50,100,290);   { Graph }
  Line(100,290,520,290);  {  axes }

  For a:=1 To 13 Do
   Begin
    b:=20+a*30;
    If a<10 Then           { Marking }
    Line(95,b,100,b);      {   of    }
    c:=65+a*35;            {  axes   }
    Line(c,290,c,295);
   End;

  For d:=1 To 5 Do
   Begin
    e:=345-d*60;
    f:=d*20-20;             { Labelling }
    Str(f:2,concs);         {           }
    OutTextXY(70,e,concs);  {    of     }
    g:=d*144-63;            {           }
    h:=d*60-60;             {   axes    }
    Str(h:3,time);
    If d<5 Then
    OutTextXY(g,302,time);
   End;

  OutTextXY(15,118,'Urea');
  OutTextXY(15,133,'Nitrogen');
  OutTextXY(15,148,'(mg/dl)');
  OutTextXY(255,320,'Time (minutes)');

  Str(Qb:3:0,Bflow);
  Str(Qd:3:0,Dflow);
  Str(K:3:0,clearance);
  Str(V:3:0,volume);
  Str(T:3,duration);

  OutTextXY(560,50,'Blood Flow');
  OutTextXY(560,65,'=     ml/min');
  OutTextXY(575,65,Bflow);
  OutTextXY(560,100,'Dialysate Flow');
  OutTextXY(560,115,'=     ml/min');
  OutTextXY(575,115,Dflow);
  OutTextXY(560,150,'Specified dialyser');
  OutTextXY(560,165,'clearance');
  OutTextXY(560,180,'=     ml/min');
  OutTextXY(575,180,clearance);
  OutTextXY(560,225,'Urea distribution');
  OutTextXY(560,240,'volume =     l');
  OutTextXY(635,240,volume);
  OutTextXY(560,275,'Monitoring duration');
  OutTextXY(560,290,'=     mins');
  OutTextXY(575,290,duration);

  {Delay(10000);}
  {RestoreCrtMode;}
 End;

Procedure Monitoring;
Var TotalSamples,TSplusFour,T,a,b : integer;
                        Qb,Qd,K,V :real;
                    ValvePosition : string;
 Begin
  writeln;
  writeln('What is the blood flow rate (ml/min)?');read(Qb);
  writeln('What is the dialysate flow rate (ml/min)?');read(Qd);
  writeln('What is the specified clearance of the dialyser (ml/min)?');read(K);
  writeln('What is the urea distribution volume (litres)?');read(V);
  writeln('How many minutes of monitoring do you require?');
  writeln('Samples are analysed at 15 minute intervals (ie at 15,30,45,etc. mins)');
  writeln('WARNING: Experiment begins after your following response is returned.');
  writeln('How many samples will this treatment session involve? (180 mins = 12 samples)');
  read(TotalSamples);
  T:=15*TotalSamples;
  TSplusFour:=TotalSamples+4;
  ValvePosition:='90';
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  Plot_Graph(Qb,Qd,K,V,T);
  For a:=5 To TSplusFour Do
   Begin
    For b:=1 To 125 Do  { 125 second delay needed for 15 minute sampling cycle }
    LoadOEM1;
    PurgeOEM3(a,ValvePosition);
    LoadSample(a,ValvePosition);
    WashChamber;
    Assay(a);
   End;
  Delay(30000); { 30 second delay for opportunity to observe/print graph }
  RestoreCrtMode;
 End;

{main prog here....................................................}


begin
   async_init;         {set up comms}
   if async_open(1,4800,'e',7,2) then   {set up COM1..remember to close}
   begin
    clrscr;
    command:='IG';
    devicenum:='1';
    For devicecheck:=1 To 2 Do
     begin
      writeln;
      are_you_there(devicenum,fail1);  {check this device is OK}
      write('Device ',devicenum,' ');  {tell us about it}
      if not fail1 then
       begin
        writeln('located');
        docommand(devicenum,command);
       end
      else writeln('not found');
      delay(1500);
      devicenum:='2';
     end;
       Ba:=$0700;
       Port[Ba+$0B]:=$80;
       ClrScr;
       detectgraph(graphdriver,graphmode);
       pathtodriver:='';
       Calibrate;
       Monitoring;
       async_close;
     end
      else
       begin
         writeln('Failed to open Com1');
         async_close; {close it just in case!}
       end;
end.