Program BSPmonit;

{ Program which enables open loop monitoring of BSP concentration at a sampling interval of 10 minutes }
uses dos,crt,graph,async4u;
Type
Absorbance_Values = Array[1..100] of Real;
BSP_Concentrations = Array[1..50] of Real;

const NUL = #0; STX = #2; ETX = #3; EOT = #4; ENQ = #5;
      ACK = #6; NAK = #21;

var     devicenum          : char;  {to address module number}
        devicecheck        : integer; {used in device checking loop }
        command            : string; {command to be sent}
        fail1, fail2       : boolean; {fail flags}
        instring           : string; {temp variable}
        Qstatus_string     : string; {to pass around result of Q enquiry}
        Qchar              : string; {Qbyte is 7th byte in Qstatus_string}
        reply              : string; {to get user input}
        Ba                 : integer; {base address for PC-30 board}
        absorbance         : Absorbance_Values; { array }
      graphdriver,graphmode: integer;
        pathtodriver       : string;
        slope,intercept,AbBlank: real;
        BSP_Conc           : BSP_Concentrations;

procedure buildbcc(var outstring : string);  {takes command string and
                       adds comms protocol as per Hamilton doc. V1.0 page 9-3}

var    bccount : byte;
       counter : integer;

begin
  outstring := outstring + ETX; {concat to ETX}
  bccount := ord(outstring[1]);
  for counter := 2 to length(outstring) do
    bccount := bccount xor ord(outstring[counter]);
  bccount := 127-bccount; {complement}
  outstring := STX + outstring + chr(bccount);
end;


procedure readback(var instring : string;
                   var ack_fail, no_response : boolean);

var inchar : char;

begin
  delay(100);
  instring := ''; {initialize input use zero length}
  no_response := true; ack_fail := true;
  while async_buffer_check(inchar) do
    begin
      no_response := false;
      {writeln('Found ',ord(inchar),'  ',char(inchar));}
      instring := instring + inchar;
    end;
  if copy(instring,1,3) <> NAK then ack_fail := false;
end;



procedure are_you_there(charaddress : char;
                        var fail : boolean);

var enquiry_string : string;
    ack_fail, no_response : boolean;

begin
  async_send_string(EOT + '0' + charaddress + ENQ);
  readback(enquiry_string,ack_fail,no_response);
  if (ack_fail or no_response) then fail := true
    else fail := false;
  end;


procedure get_Q_status;


begin
  async_send_string(STX+'Q'+ ETX + '-');
  readback(Qstatus_string,fail1,fail2);
  Qchar := copy(Qstatus_string,7,1);
  {writeln('                Qchar = ',Qchar,'  fail1 = ',fail1,'  fail2 =',fail2);}
  {if (fail1 or fail2)  then
       writeln('Q status request fails')}

 end;


procedure actonQchar; {do something if Qbyte needs it!}

begin
  if  (Qchar <> '@') or (Qchar <> 'A') then
    begin
      if Qchar = 'H' then
        begin
          writeln ('Syntax error in previous command...abort');
          halt;
        end;
      if Qchar = 'P' then
        begin
          writeln('Instrument error after previous command...abort');
          halt;
        end;
    end;
end;


procedure docommand(charaddress : char; command : string);

var outstring : string;
    inchar : char;

begin
  repeat
    async_send_string(EOT + '0' + charaddress + ENQ);
    get_Q_status;
    actonQchar;
  until (Qchar = '@') or (keypressed) or (Qchar = 'A');

 outstring := command;
  buildbcc(outstring);
  async_send_string(ACK + outstring); {send command preceded with ACK}
  readback(instring,fail1,fail2);
  {if not (fail1 or fail2) then
    write('Command sent successfully        ')
    else
      begin
        if fail2 and not (command ='G') then
          writeln('Device does not respond')
          else if fail1 then
            writeln('Device does not acknowledge command correctly');
      end;}
    end;


procedure initialise (devicenum : char);

begin
  are_you_there(devicenum,fail1);
  if fail1 then
    begin
      writeln('areyouthere fails with devicenum = ',devicenum);
      writeln('abort...!');
    end;
end;

procedure instruct(devicenum : char; command: string);

begin
  async_send_string(EOT+'0'+devicenum+ENQ);
  docommand(devicenum,command);
end;

procedure go(devicenum : char);

begin
  instruct(devicenum,'G');
end;

procedure initialisation(devicenum : char);

begin
  instruct(devicenum,'I');
end;

procedure valve(devicenum, direction : char; degrees : string);

begin
  instruct(devicenum,'Vv'+direction+'w'+degrees);
end;

procedure pickup(devicenum : char; steps, speed : string);

begin
  instruct(devicenum,'Pp'+steps+'s'+speed);
end;

procedure dispense(devicenum : char; steps, speed, stopspeed : string);

begin
  instruct(devicenum,'Dd'+steps+'t'+speed+'u'+stopspeed);
end;

procedure Read_Port(var AbsorbValue:real);
var v_total,volts,sample_volts:Real;
                      T,data,d:Integer;
                       channel:Byte;
                            ch:Char;


 Begin
  Port[Ba+3]:=$92; {control register};
  channel:=0;
  V_total:=0;
  For d:=1 To 10 Do
   Begin
    Port[Ba+2]:=(channel shl 4)+2;
    Port[Ba+2]:=(channel shl 4)+3;
    For T:=1 To 16 Do
     Begin             { wait for 40 microseconds - A/D conversion time };
     End;
    data:=((Port[Ba+1] And $0F) shl 8)+Port[Ba];
    volts:=(data*0.002454);
    v_total:=v_total+volts;
   End;
   Sound(600);
   Delay(100);
   NoSound;
   sample_volts:=(v_total/10);
   AbsorbValue:=sample_volts/4;
  End;

Procedure LoadOEM1;
 Begin
  Valve('1','0','0');
  Go('1');
  Pickup('1','760','100'); { Load OEM1 with reagent }
  Go('1');
  Valve('1','1','270');
  Go('1');
 End;

Procedure PurgeOEM3(a:integer;ValvePosition:string);
Var purges : integer;
 Begin
  Port[Ba+8]:=1;
  Initialisation('2');
  Go('2');
  For purges:= 1 To 53 Do  { Purge OEM3 35 times }
   Begin
    If a<5 Then
     Valve('2','0',ValvePosition)   { was 1 }
    Else
     Valve('2','1',ValvePosition);  { was 0 }
    Go('2');
    PickUp('2','1050','1000');
    Go('2');
    If a<5 Then
     Valve('2','1','135')
    Else
     Valve('2','0','135');
    Go('2');
    Dispense('2','1050','1000','50');
    Go('2');
   End;
  Sound(500);Delay(333);Sound(620);Delay(333); { indicates end of purging }
  Sound(750);Delay(334);NoSound;
  Delay(4000);
 End;

Procedure LoadSample(a:integer;ValvePosition:string);
 Begin
  If a<5 Then
   Valve('2','0',ValvePosition)    { Load OEM3 syringe with sample }
  Else
   Valve('2','1',ValvePosition);
  Go('2');
  PickUp('2','1000','1000');  { added code }
  Go('2');

  If a<5 Then
   Valve('2','1','135')
  Else
   Valve('2','0','135');
  Go('2');

  Dispense('2','430','1000','50');  { added code }
  Go('2');
  Dispense('2','60','1000','1000');
  Go('2');
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(3000);
 End;

Procedure WashChamber;
Var b:integer;
 Begin
  For b:= 1 To 3 Do { Wash mixing chamber with sequence of reagent discharges }
   Begin
    If b=3 Then
     Dispense('1','150','400','50')
    Else
     Dispense('1','125','400','50');
    Go('1');
    Delay(2500);
    Port[Ba+8]:=1;  { Switch on roller pump to drain chamber }
     Delay(7000);   { Wait while pump drains chamber }
    Port[Ba+8]:=0;  { Switch off pump }
    Delay(1500);
   End;
 End;

Procedure Assay(a:integer);
 Var        AbsorbValue:real;
    b,c,d,x,xOld,y,yOld,x_text,y_text:integer;
                    BSPvalue:string[5];
                    time:string[3];
 Begin
  Sound(600);
  Delay(2500);
  NoSound;
 If a>1 Then
  Begin
   Dispense('1','150','100','50');    { Dispense half of the reagent }
   Go('1');
   Dispense('2','60','1000','1000'); { Dispense sample }
   Go('2');
   Delay(1000);                      { Let sample droplet disperse a little }
   Dispense('1','210','400','50');   { Dispense rest of the reagent }
   Go('1');
   Valve('2','1','0');
   Go('2');
   Dispense('2','450','1000','50'); { Dispense residual sample to waste tube }
   Go('2');
  End
 Else
  Begin
   Dispense('1','360','100','50');
   Go('1');
   Delay(5000);
  End;

  Port[Ba+8]:=1;
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(6000); { 6 second delay }
  Read_Port(AbsorbValue);
  absorbance[a]:=AbsorbValue;
  If a<5 Then
   writeln('Calibration test ',a,' : absorbance = ',AbsorbValue:4:3)
  Else
    Begin
     BSP_Conc[a]:=(AbsorbValue-intercept)/slope;
     x:=Round(100+(a-4)*46.67);
     y:=Round(290-BSP_Conc[a]*3);
     If a>5 Then
      Begin
       xOld:=Round(100+(a-5)*46.67);
       yOld:=Round(290-BSP_Conc[a-1]*3);
       Line(xOld,yOld,x,y);
       Circle(x,y,3);
      End
     Else
      Circle(x,y,3);
     x_text:=x;
     y_text:=y-11;
     Str(BSP_Conc[a]:5:2,BSPValue);
     OutTextXY(x_text,y_text,BSPValue);
    End;
  Sound(500);
  Delay(1500);
  Nosound;
 End;


Procedure Calibrate;
Var Conc1,Conc2,Conc3,AbStnd1,AbStnd2,AbStnd3,
    SigmaY,SigmaX,SigmaXY,SigmaXsqr,MeanX,MeanY:real;
                                  ValvePosition:string;
                                        a,c,d,n:integer;
 Begin
  writeln('CALIBRATION PROCEDURE');
  writeln('---------------------');
  writeln;
  writeln('Enter the concentration (mM) of standard 1');read(Conc1);
  writeln('Enter the concentration (mM) of standard 2');read(Conc2);
  writeln('Enter the concentration (mM) of standard 3');read(Conc3);
  For a:=1 To 4 Do
   Begin
    LoadOEM1;
    If a=2 Then ValvePosition:='225';
    If a=3 Then ValvePosition:='270';
    If a=4 Then ValvePosition:='315';
    If a>1 Then
     Begin
      PurgeOEM3(a,ValvePosition);
      LoadSample(a,ValvePosition);
     End;
    WashChamber;
    Assay(a);
   End;

    AbBlank:=absorbance[1];
    AbStnd1:=absorbance[2];
    AbStnd2:=absorbance[3];
    AbStnd3:=absorbance[4];
    SigmaX:=0+Conc1+Conc2+Conc3;
    SigmaY:=AbBlank+AbStnd1+AbStnd2+AbStnd3;
    SigmaXY:=Conc1*AbStnd1+Conc2*AbStnd2+Conc3*AbStnd3;
    SigmaXsqr:=0+sqr(Conc1)+sqr(Conc2)+sqr(Conc3);
    n:=4;
    slope:=(n*SigmaXY-SigmaX*SigmaY)/(n*SigmaXsqr-sqr(SigmaX));
    MeanY:=SigmaY/n;
    MeanX:=SigmaX/n;
    intercept:=MeanY-slope*MeanX;
    { Least squares diff. equ. is Absorbance change = slope*conc + intercept }
    writeln('slope = ',slope:5:4,' intercept = ',intercept:5:4);
 End;

Procedure Plot_Graph(T:integer);
 var a,b,c,d,e,f,g,h:integer;
     concs,time,duration:string[3];
 Begin

  OutTextXY(165,15,'BSP Concentration vs. Time'); { Graph }
  Line(165,25,455,25);                                      { title }

  Line(1,1,1,347);       { Outline }
  Line(1,347,719,347);   {   of    }
  Line(719,347,719,1);   { screen  }
  Line(719,1,1,1);       { frame   }
  Line(550,1,550,347);
  Line(550,188,719,188);

  Line(100,50,100,290);   { Graph }
  Line(100,290,520,290);  {  axes }

  For a:=1 To 13 Do
   Begin
    b:=20+a*30;
    If a<10 Then           { Marking }
    Line(95,b,100,b);      {   of    }
    c:=65+a*35;            {  axes   }
    Line(c,290,c,295);
   End;

  For d:=1 To 5 Do
   Begin
    e:=345-d*60;
    f:=d*20-20;             { Labelling }
    Str(f:2,concs);         {           }
    OutTextXY(70,e,concs);  {    of     }
    g:=d*144-63;            {           }
    h:=d*60-60;             {   axes    }
    Str(h:3,time);
    If d<5 Then
    OutTextXY(g,302,time);
   End;

  OutTextXY(15,118,'BSP');
  OutTextXY(15,133,'(mM)');
  OutTextXY(255,320,'Time (minutes)');

  OutTextXY(560,325,'Monitoring duration');
  OutTextXY(560,335,'=     mins');
  OutTextXY(575,335,duration);
 End;

Procedure Monitoring;
Var TotalSamples,TSplusFour,T,a,b : integer;
                    ValvePosition : string;
 Begin
  writeln;
  writeln('MONITORING OF DECAY IN BSP CONCENTRATION DUE TO DILUTION');
  writeln('-----------------------------------------------');
  writeln('WARNING: Monitoring begins after your following response is returned');
  writeln('What is the duration of the monitoring period to the nearest 10 minutes (max. 240)?');
  read(T);
  TotalSamples:=Round(T/10);
  TSplusFour:=TotalSamples+4;
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  Plot_Graph(T);
  For a:=5 To TSplusFour Do
   Begin
    ValvePosition:='90'; { dialysate outflow sampling port }
    LoadOEM1;
    PurgeOEM3(a,ValvePosition);
    LoadSample(a,ValvePosition);
    WashChamber;
    Assay(a);
   End;
  Delay(5000);
  For b:=1 To 20 Do     { alarm to indicate end of monitoring period }
   Begin
    Sound(500);
    Delay(100);
    NoSound;
    Delay(50);
   End;
  Delay(30000); { 30 second delay for opportunity to observe/print graph }
  RestoreCrtMode;
 End;

{main prog here....................................................}


 begin
  async_init;         {set up comms}
  if async_open(1,4800,'e',7,2) then   {set up COM1..remember to close}
   begin
    clrscr;
    command:='IG';
    devicenum:='1';
    For devicecheck:=1 To 2 Do
     begin
      writeln;
      are_you_there(devicenum,fail1);  {check this device is OK}
      write('Device ',devicenum,' ');  {tell us about it}
      if not fail1 then
       begin
        writeln('located');
        docommand(devicenum,command);
       end
      else writeln('not found');
      delay(1500);
      devicenum:='2';
     end;
    If not fail1 Then
     Begin
      Ba:=$0700;
      Port[Ba+$0B]:=$80;
      ClrScr;
      detectgraph(graphdriver,graphmode);
      pathtodriver:='';
      Calibrate;
      Monitoring;
     End
    Else
     writeln('Failure in device location - likely cause is power not on!');
    async_close;
   end
     else
      begin
        writeln('Failed to open Com1');
        async_close; {close it just in case!}
      end;
end.