Program FeedBack;

{Closed loop control of haemodialysis through dialysate flow adjustment.
 Control system requires the blood flow rate to be 200 ml/min throughout.
 Cbi monitored on a 10 minute cycle. }
uses dos,crt,graph,async4u;
Type
Absorbance_Values = Array[1..100] of Real;
Blank_Absorbances = Array[1..50] of Real;
Urea_Nitrogen_Concentrations = Array[1..50] of Real;
Clearance_Values = Array[1..50] of Real;

const NUL = #0; STX = #2; ETX = #3; EOT = #4; ENQ = #5;
      ACK = #6; NAK = #21;

var     devicenum          : char;  {to address module number}
        devicecheck        : integer; {used in device checking loop }
        command            : string; {command to be sent}
        fail1, fail2       : boolean; {fail flags}
        instring           : string; {temp variable}
        Qstatus_string     : string; {to pass around result of Q enquiry}
        Qchar              : string; {Qbyte is 7th byte in Qstatus_string}
        reply              : string; {to get user input}
        Ba                 : integer; {base address for PC-30 board}
        absorbance         : Absorbance_Values; { array }
        AbBlankValues      : Blank_Absorbances;
      graphdriver,graphmode: integer;
        pathtodriver       : string;
   slope,intercept,AbBlank : real;
        UN                 : Urea_Nitrogen_Concentrations;
        K                  : Clearance_Values;


procedure buildbcc(var outstring : string);  {takes command string and
                       adds comms protocol as per Hamilton doc. V1.0 page 9-3}

var    bccount : byte;
       counter : integer;

begin
  outstring := outstring + ETX; {concat to ETX}
  bccount := ord(outstring[1]);
  for counter := 2 to length(outstring) do
    bccount := bccount xor ord(outstring[counter]);
  bccount := 127-bccount; {complement}
  outstring := STX + outstring + chr(bccount);
end;


procedure readback(var instring : string;
                   var ack_fail, no_response : boolean);

var inchar : char;

begin
  delay(100);
  instring := ''; {initialize input use zero length}
  no_response := true; ack_fail := true;
  while async_buffer_check(inchar) do
    begin
      no_response := false;
      {writeln('Found ',ord(inchar),'  ',char(inchar));}
      instring := instring + inchar;
    end;
  if copy(instring,1,3) <> NAK then ack_fail := false;
end;



procedure are_you_there(charaddress : char;
                        var fail : boolean);

var enquiry_string : string;
    ack_fail, no_response : boolean;

begin
  async_send_string(EOT + '0' + charaddress + ENQ);
  readback(enquiry_string,ack_fail,no_response);
  if (ack_fail or no_response) then fail := true
    else fail := false;
  end;


procedure get_Q_status;


begin
  async_send_string(STX+'Q'+ ETX + '-');
  readback(Qstatus_string,fail1,fail2);
  Qchar := copy(Qstatus_string,7,1);
  {writeln('                Qchar = ',Qchar,'  fail1 = ',fail1,'  fail2 =',fail2);}
  {if (fail1 or fail2)  then
       writeln('Q status request fails')}

 end;


procedure actonQchar; {do something if Qbyte needs it!}

begin
  if  (Qchar <> '@') or (Qchar <> 'A') then
    begin
      if Qchar = 'H' then
        begin
          writeln ('Syntax error in previous command...abort');
          halt;
        end;
      if Qchar = 'P' then
        begin
          writeln('Instrument error after previous command...abort');
          halt;
        end;
    end;
end;


procedure docommand(charaddress : char; command : string);

var outstring : string;
    inchar : char;

begin
  repeat
    async_send_string(EOT + '0' + charaddress + ENQ);
    get_Q_status;
    actonQchar;
  until (Qchar = '@') or (keypressed) or (Qchar = 'A');

 outstring := command;
  buildbcc(outstring);
  async_send_string(ACK + outstring); {send command preceded with ACK}
  readback(instring,fail1,fail2);
  {if not (fail1 or fail2) then
    write('Command sent successfully        ')
    else
      begin
        if fail2 and not (command ='G') then
          writeln('Device does not respond')
          else if fail1 then
            writeln('Device does not acknowledge command correctly');
      end;}
    end;


procedure initialise (devicenum : char);

begin
  are_you_there(devicenum,fail1);
  if fail1 then
    begin
      writeln('areyouthere fails with devicenum = ',devicenum);
      writeln('abort...!');
    end;
end;

procedure instruct(devicenum : char; command: string);

begin
  async_send_string(EOT+'0'+devicenum+ENQ);
  docommand(devicenum,command);
end;

procedure go(devicenum : char);

begin
  instruct(devicenum,'G');
end;

procedure initialisation(devicenum : char);

begin
  instruct(devicenum,'I');
end;

procedure valve(devicenum, direction : char; degrees : string);

begin
  instruct(devicenum,'Vv'+direction+'w'+degrees);
end;

procedure pickup(devicenum : char; steps, speed : string);

begin
  instruct(devicenum,'Pp'+steps+'s'+speed);
end;

procedure dispense(devicenum : char; steps, speed, stopspeed : string);

begin
  instruct(devicenum,'Dd'+steps+'t'+speed+'u'+stopspeed);
end;

Procedure Read_Port(var AbsorbValue:real);
var v_total,volts,sample_volts:Real;
                      a,i,data:Integer;
                       channel:Byte;
                            ch:Char;
 Begin
  Port[Ba+3]:=$92; {control register};
  channel:=0;
  V_total:=0;
  For a:=1 To 10 Do
   Begin
    Port[Ba+2]:=(channel shl 4)+2;
    Port[Ba+2]:=(channel shl 4)+3;
    For i:=1 To 16 Do
     Begin             { wait for 40 microseconds - A/D conversion time };
     End;
    data:=((Port[Ba+1] And $0F) shl 8)+Port[Ba];
    volts:=(data*0.002454);
    v_total:=v_total+volts;
   End;
   Sound(600);
   Delay(100);
   NoSound;
   sample_volts:=(v_total/10);
   AbsorbValue:=sample_volts/4;
  End;

Procedure LoadOEM1;
 Begin
  Valve('1','0','0');
  Go('1');
  Pickup('1','760','100'); { Load OEM1 with reagent }
  Go('1');
  Valve('1','1','270');
  Go('1');
 End;

Procedure PurgeOEM3(a:integer;ValvePosition:string);
Var purges : integer;
 Begin
  Port[Ba+8]:=1;
  Initialisation('2');
  Go('2');
  For purges:= 1 To 35 Do  { Purge OEM3 35 times }
   Begin
    If a<5 Then
     Valve('2','0',ValvePosition)   { was 1 }
    Else
     Valve('2','1',ValvePosition);  { was 0 }
    Go('2');
    PickUp('2','1050','1000');
    Go('2');
    If a<5 Then
     Valve('2','1','135')
    Else
     Valve('2','0','135');
    Go('2');
    Dispense('2','1050','1000','50');
    Go('2');
   End;
  Sound(500);Delay(333);Sound(620);Delay(333); { indicates end of purging }
  Sound(750);Delay(334);NoSound;
  Delay(4000);
 End;

Procedure LoadSample(a:integer;ValvePosition:string);
 Begin
  If a<5 Then
   Valve('2','0',ValvePosition)    { Load OEM3 syringe with sample }
  Else
   Valve('2','1',ValvePosition);
  Go('2');
  PickUp('2','1000','1000');  { added code }
  Go('2');

  If a<5 Then
   Valve('2','1','135')
  Else
   Valve('2','0','135');
  Go('2');

  Dispense('2','430','1000','50');  { added code }
  Go('2');
  Dispense('2','60','1000','1000');
  Go('2');
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(3000);
 End;

Procedure WashChamber;
Var b:integer;
 Begin
  For b:= 1 To 3 Do { Wash mixing chamber with sequence of reagent discharges }
   Begin
    If b=3 Then
     Dispense('1','150','400','50')
    Else
     Dispense('1','125','400','50');
    Go('1');
    Delay(2500);
    Port[Ba+8]:=1;  { Switch on roller pump to drain chamber }
     Delay(7000);   { Wait while pump drains chamber }
    Port[Ba+8]:=0;  { Switch off pump }
    Delay(1500);
   End;
 End;

Procedure Recalibrate(var AbBlank:real;a:integer);

 Begin
  Dispense('1','360','100','50');
  Go('1');
  Delay(5000);
  Port[Ba+8]:=1;
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(6000);
  Read_Port(AbBlank);
  AbBlankValues[a]:=AbBlank;
  Port[Ba+8]:=1;
  Valve('1','0','0');
  Go('1');
  PickUp('1','360','100');
  Go('1');
  Valve('1','1','270');
  Go('1');
  Port[Ba+8]:=0;
 End;

Procedure Assay(a:integer;ValvePosition:string);
 Var        AbsorbValue,e:real;
    b,c,d,f,x,xOld,y,yOld,y_text:integer;
            UNValue,NewBlank:string[5];
 Begin
  If a>4 Then
   Begin
    y_text:=20+(a-4)*12;
    e:=a/2;
    f:=Round(e);
    If e<>f Then
     Begin    { performs recalibration every other time }
      Recalibrate(AbBlank,a);
      Str(AbBlank:5:3,NewBlank);
      OutTextXY(325,y_text,NewBlank);
     End;
   End;
  Sound(600);
  Delay(2500);
  NoSound;
 If a>1 Then
  Begin
   Dispense('1','150','100','50');    { Dispense half of the reagent }
   Go('1');
   Dispense('2','60','1000','1000'); { Dispense sample }
   Go('2');
   Delay(1000);                      { Let sample droplet disperse a little }
   Dispense('1','210','400','50');   { Dispense rest of the reagent }
   Go('1');
   Valve('2','1','0');
   Go('2');
   Dispense('2','450','1000','50'); { Dispense residual sample to waste tube }
   Go('2');
   For b:=1 To 192 Do    { Incubation period was 277, 189, 185, 180, 178 }
   Delay(1000);
  End
 Else
  Begin
   Dispense('1','360','100','50');
   Go('1');
   Delay(5000);
  End;

  Port[Ba+8]:=1;
  Delay(7000);
  Port[Ba+8]:=0;
  Delay(6000); { 6 second delay }
  Read_Port(AbsorbValue);
  absorbance[a]:=AbsorbValue;
  If a<5 Then
   writeln('Calibration test ',a,' : absorbance = ',AbsorbValue:4:3)
  Else
    Begin
     UN[a]:=((AbBlank-AbsorbValue)-intercept)/slope;
     x:=Round(30+(a-4)*15);
     y:=Round(290-UN[a]*3);
     If a>5 Then
      Begin
       xOld:=Round(30+(a-5)*15);
       yOld:=Round(290-UN[a-1]*3);
       Line(xOld,yOld,x,y);
       Circle(x,y,3);
      End
     Else
      Circle(x,y,3);
     Str(UN[a]:5:2,UNValue);
     OutTextXY(380,y_text,UNValue);
    End;
  Sound(500);
  Delay(1500);
  Nosound;
 End;


Procedure Calibrate;
Var Conc1,Conc2,Conc3,AbStnd1,AbStnd2,AbStnd3,AbChange1,AbChange2,AbChange3,
    SigmaY,SigmaX,SigmaXY,SigmaXsqr,MeanX,MeanY:real;
                                  ValvePosition:string;
                                        a,c,d,n:integer;
 Begin
  writeln('CALIBRATION PROCEDURE');
  writeln('---------------------');
  writeln('Note: Have you remembered to recalibrate the dialysate supply system?');
  writeln;
  writeln('Enter the urea nitrogen concentration (mg/dl) of standard 1');read(Conc1);
  writeln('Enter the urea nitrogen concentration (mg/dl) of standard 2');read(Conc2);
  writeln('Enter the urea nitrogen concentration (mg/dl) of standard 3');read(Conc3);
  For a:=1 To 4 Do
   Begin
    LoadOEM1;
    If a=2 Then ValvePosition:='225';
    If a=3 Then ValvePosition:='270';
    If a=4 Then ValvePosition:='315';
    If a>1 Then
     Begin
      PurgeOEM3(a,ValvePosition);
      LoadSample(a,ValvePosition);
     End;
    WashChamber;
    Assay(a,ValvePosition);
   End;

    AbBlank:=absorbance[1];
    AbStnd1:=absorbance[2];
    AbStnd2:=absorbance[3];
    AbStnd3:=absorbance[4];
    AbChange1:=AbBlank-AbStnd1;
    AbChange2:=AbBlank-AbStnd2;
    AbChange3:=AbBlank-AbStnd3;
    SigmaX:=0+Conc1+Conc2+Conc3;
    SigmaY:=0+AbChange1+AbChange2+AbChange3;
    SigmaXY:=Conc1*AbChange1+Conc2*AbChange2+Conc3*AbChange3;
    SigmaXsqr:=0+sqr(Conc1)+sqr(Conc2)+sqr(Conc3);
    n:=4;
    slope:=(n*SigmaXY-SigmaX*SigmaY)/(n*SigmaXsqr-sqr(SigmaX));
    MeanY:=SigmaY/n;
    MeanX:=SigmaX/n;
    intercept:=MeanY-slope*MeanX;
    { Least squares diff. equ. is Absorbance change = slope*UNconc + intercept }
    writeln('slope = ',slope:5:4,' intercept = ',intercept:5:4);
 End;

Procedure Plot_Graph(KtOverV,initial_Qd,initial_K,V,time_delay:real;
                                                               T:integer);
 var a,b,c,d,e,f,g,h:integer;
     concs,time,Bflow,Dflow,clearance,delay,volume,KtUponV,duration:string[5];
 Begin

  OutTextXY(70,15,'Urea Nitrogen Conc. vs. Time'); { Graph }
  Line(70,25,293,25);                              { title }

  Line(1,1,1,347);       { Outline }
  Line(1,347,719,347);   {   of    }
  Line(719,347,719,1);   { screen  }
  Line(719,1,1,1);       { frame   }
  Line(315,1,315,347);
  Line(315,26,719,26);
  Line(315,248,719,248);

  Line(30,50,30,290);    { Graph }
  Line(30,290,300,290);  {  axes }

  For a:=1 To 13 Do
   Begin
    b:=20+a*30;
    If a<10 Then           { Marking }
    Line(25,b,30,b);       {   of    }
    c:=Round(7.5+a*22.5); {  axes   }
    Line(c,290,c,295);
   End;

  For d:=1 To 5 Do
   Begin
    e:=345-d*60;
    f:=d*20-20;             { Labelling }
    Str(f:2,concs);         {           }
    OutTextXY(4,e,concs);  {    of     }
    g:=d*93-82;             {           }
    h:=d*60-60;             {   axes    }
    Str(h:3,time);
    If d<5 Then
     OutTextXY(g,302,time);
   End;

  OutTextXY(10,25,'Urea N');
  OutTextXY(10,35,'(mg/dl)');
  OutTextXY(112,320,'Time (minutes)');

  OutTextXY(325,12,'Blank UN     UN     UN     Q  Err(%) Err(%) mins');
  OutTextXY(334,15,'       meas   pred   mod   d    mod');

  Str(initial_Qd:4:1,Dflow);
  Str(initial_K:4:1,clearance);
  Str(KtOverV:3:2,KtUponV);
  Str(V:3:0,volume);
  Str(time_delay:3:1,delay);
  Str(T:3,duration);

  OutTextXY(325,255,'Model dialysate flow =       ml/min');
  OutTextXY(510,255,Dflow);
  OutTextXY(325,270,'Model dialyser clearance =       ml/min ');
  OutTextXY(540,270,clearance);
  OutTextXY(325,285,'Model Kt/V =');
  OutTextXY(430,285,KtUponV);
  OutTextXY(325,300,'Urea distribution volume =       ml');
  OutTextXY(540,300,volume);
  OutTextXY(325,315,'Monitor delay entered as      mins');
  OutTextXY(520,315,delay);
  OutTextXY(325,330,'Monitoring duration =      mins');
  OutTextXY(500,330,duration);
 End;

Procedure Qd_Control(Var Qd{,K}:real;Var PortValue:integer;a:integer;
                     initial_UN,initial_Qd,V,time_delay,initial_K:real);
Var                  delay_A,delay_B,delay_C,undelayed_UN,UNmeas_model,
                     UNmeas_model_error,corrected_undelayed_UN,
                     old_K,{ratio_meas,ratio_ref,}model_UN,error:real;
                                                      now,line:integer;
                     UN_pred,UN_model,dial_flow,mod_err,err,time:string[5];
 Begin
  If time_delay>10 Then
   Begin
    delay_A:=time_delay-10; { minutes of delay beyond 10 }
    delay_B:=10;
    If a=5 Then K[a-2]:=K[a-1];
    undelayed_UN:=(UN[a]*exp(-K[a-2]*delay_A/V))*exp(-K[a-1]*delay_B/V);{current urea}
    If a=5 Then UNmeas_model:=UN[a]
    Else
     UNmeas_model:=(UN[a-1]*exp(-K[a-3]*delay_A/V))*exp(-K[a-2]*(10-delay_A)/V);{model calc. of UNmeas}
    UNmeas_model_error:=(UNmeas_model-UN[a])*100/UNmeas_model;
    corrected_undelayed_UN:=undelayed_UN-(undelayed_UN*UNmeas_model_error/100);
    model_UN:=initial_UN*exp(-initial_K*((a-4)*10+delay_A)/V);
   End
  Else
   Begin
    delay_C:=10-time_delay;
    undelayed_UN:=UN[a]*exp(-K[a-1]*time_delay/V); { calc current urea }
    If a=5 Then Unmeas_model:=UN[a]
    Else
     UNmeas_model:=UN[a-1]*exp(-K[a-2]*time_delay/V);
    Unmeas_model_error:=(UNmeas_model-UN[a])*100/UNmeas_model;
    corrected_undelayed_UN:=undelayed_UN-(undelayed_UN*UNmeas_model_error/100);
    model_UN:=initial_UN*exp(-initial_K*((a-4)*10-delay_C)/V);
   End;
  {ratio_meas:=corrected_undelayed_UN/initial_UN;} {normalised to initial urea}
  {ratio_ref:=model_UN/initial_UN;}
  error:=(corrected_undelayed_UN-model_UN)*100/model_UN;
  If error>1.5 Then
   Begin
    If Qd<345 Then
     Qd:=Qd*1.4          { increase Qd by 40% }
    Else
     Qd:=480;        { increase Qd to max.}
   End;
  If error<-1.5 Then
   {Begin
    If Qd>(initial_Qd/1.4) Then}
     Qd:=Qd/1.4;          { decrease Qd by 40% }
    {Else}
     {Qd:=Qd/1.15;}        { decrease Qd by 15% }
   {End;}
  PortValue:=Round((640-Qd)/4.8); {PortValue - Qd relationship for Dylade DII}
  If PortValue>255 Then
   PortValue:=255;
  If PortValue<0 Then
   PortValue:=0;
  Port[$714]:=PortValue;
  {old_K:=K;}
  K[a]:=(ln(Qd)-2.91)/0.0194; { new K used to get next undelayed monitor reading }
  now:=(a-4)*10;
  line:=20+(a-4)*12;
  Str(corrected_undelayed_UN:5:2,UN_pred);
  Str(model_UN:5:2,UN_model);
  Str(Qd:5:1,dial_flow);
  Str(UNmeas_model_error:5:2,mod_err);
  Str(error:5:2,err);
  Str(now:3,time);
  OutTextXY(435,line,UN_pred);
  OutTextXY(490,line,UN_model);
  OutTextXY(535,line,dial_flow);
  OutTextXY(580,line,mod_err);
  OutTextXY(625,line,err);
  OutTextXY(680,line,time);
 End;

Procedure Monitoring;
Var    T,TotalSamples,TSplusFour,a,b,PortValue : integer;
    V,KtOverV,initial_K,{K,}initial_Qd,Qd,time_delay,initial_UN : real;
                                            ValvePosition : string;
 Begin
  writeln;
  writeln('CLOSED LOOP CONTROL OF UREA REMOVAL');
  writeln('-----------------------------------');
  writeln('Haemodialysis Session Details');
  writeln('-----------------------------');
  writeln('Please ensure a blood flow rate of 200 ml/min to maintain the accuracy of the');
  writeln('relationship, entered in this program, between dialysate flow and clearance.');
  Repeat
   writeln;
   writeln('What is the urea distribution volume (ml)?');read(V);
   writeln('What is the duration of the monitoring/haemodialysis session');
   writeln('to the nearest 10 minutes? (max. is 180)');read(T);
   writeln('What value do you wish Kt/V to have?');read(KtOverV);
   K[4]:=KtOverV*V/T;
   initial_K:=K[4];
   Qd:=exp(2.91+0.0194*K[4]); { Qd - K relationship at Qb=200ml/min, Mokhtar }
   initial_Qd:=Qd;
   writeln('These values result in a clearance of ',initial_K:4:1,' ml/min and a ');
   writeln('dialysate flow of ',initial_Qd:4:1,' ml/min');
   If Qd>245 Then
    Begin
     writeln('The dialysate flow is too great for effective operation of the control system.');
     writeln('Please reenter the session details.');
    End;
  Until Qd<=245;
  PortValue:=Round((640-Qd)/4.8); {PortValue - Qd relationship for Dylade DII}
  Port[$714]:=PortValue;
  writeln('NOTE - Ultrafiltrate line must be connected to 90 degree valve port');
  writeln('     - Ensure number of minutes of monitor delay in excess of 10 pass before');
  writeln('       monitoring begins');
  writeln('     - Monitoring COMMENCES after entering your response to the question below');
  writeln('       (press break if you wish to restart the program)');
  writeln;
  writeln('By how many minutes are the monitor readings delayed?');read(time_delay);
  TotalSamples:=Round(T/10);
  TSplusFour:=TotalSamples+4;
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  Plot_Graph(KtOverV,initial_Qd,initial_K,V,time_delay,T);
  For a:=5 To TSplusFour Do
   Begin
    {Delay(8500);}      { 8.5 second delay needed for 10 minute sampling cycle }
    ValvePosition:='90'; { ultrafiltrate sampling port }
    LoadOEM1;
    PurgeOEM3(a,ValvePosition);
    LoadSample(a,ValvePosition);
    WashChamber;
    Assay(a,ValvePosition);
    If a=5 Then
     initial_UN:=UN[a];
    Qd_Control(Qd,PortValue,a,initial_UN,initial_Qd,V,time_delay,initial_K);
   End;
  Delay(5000);
  For b:=1 To 20 Do     { alarm to indicate end of monitoring period }
   Begin
    Sound(500);
    Delay(100);
    NoSound;
    Delay(50);
   End;
  Delay(30000); { 30 second delay for opportunity to observe/print graph }
  RestoreCrtMode;
 End;

{main prog here....................................................}


begin
   async_init;         {set up comms}
   if async_open(1,4800,'e',7,2) then   {set up COM1..remember to close}
   begin
    clrscr;
    command:='IG';
    devicenum:='1';
    For devicecheck:=1 To 2 Do
     begin
      writeln;
      are_you_there(devicenum,fail1);  {check this device is OK}
      write('Device ',devicenum,' ');  {tell us about it}
      if not fail1 then
       begin
        writeln('located');
        docommand(devicenum,command);
       end
      else writeln('not found');
      delay(1500);
      devicenum:='2';
     end;
     If not fail1 Then
      Begin
       Ba:=$0700;
       Port[Ba+$0B]:=$80;
       ClrScr;
       detectgraph(graphdriver,graphmode);
       pathtodriver:='';
       Calibrate;
       Monitoring;
      End
     Else
      writeln('Failure in device location - likely cause is power not on!');
      async_close;
     end
      else
       begin
         writeln('Failed to open Com1');
         async_close; {close it just in case!}
       end;
end.