{ Program : Record_Urea_Data                                    }
{ Written by Paul.T.Smirthwaite                                 }
{                        1/9/91                                 }
{                                                               }
{ This program is used to show the plot of absorbance change    }
{ against urea concentration and is run at the same time as the }
{ period of dialysis to record and plot the data.               }

PROGRAM Record_Urea_Data;
 Uses CRT,Dos,Graph;
 Type
 UreaConcentrations = Array[1..10000] of Real;
 Var  GraphDriver,GraphMode,n,V : Integer;
                   PathToDriver : String;
                       UreaConc : UreaConcentrations;
                    blank,a0,a1 : Real;


{ Draws and labels axes of graph of absorbance change v. urea    }
{ concentration and plots the least squares difference line with }
{ the 3 data points marked.                                      }
Procedure AbsorbChange_v_UreaConc_Graph (Var stnd25Diff,stnd50Diff : Real);
 Var  p1,p2,c,i,x,y,blankDiffX,stnd25DiffY,stnd50DiffY : Integer;
                                                     b : Real;
                                                     s : String[3];
 Begin
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  OutTextXY(190,22,'Absorbance Change v. Urea Concentration');
  Line(190,30,500,30);
  Line(100,50,100,150);   { Drawing }
  Line(100,150,600,150);  {  axes   }
  p1:=50;
  Repeat
   Line(100,p1,95,p1);       {           }
   b:=(150-p1)/200;          { Labelling }
   Str(b:2:1,s);             {           }
   p2:=p1-6;                 {    of     }
   OutTextXY(70,p2,s);       {           }
   p1:=p1+20;                {    y      }
  Until                      {           }
   p1=170;                   {   axis    }
  p1:=100;                   {           }
  Repeat
   Line(p1,150,p1,155);      { Labelling }
   c:=Round((p1-100)/10);    {           }
   Str(c:2,s);               {    of     }
   p2:=p1-7;                 {           }
   OutTextXY(p2,162,s);      {    x      }
   p1:=p1+100;               {           }
  Until                      {   axis    }
   p1=700;                   {           }
  OutTextXY(5,73,'Absorbance');
  OutTextXY(5,83,'Change');
  OutTextXY(230,180,'Urea Concentration (mg/dL)');
  For i:=0 To 200 Do  { Loop that draws least squares difference line }
  Begin
   y:=Round(100-(100*(a0+a1*i)/2)+50);
   x:=Round(100+i*2.5);
   PutPixel(x,y,15);  { Plotting point according to L.S. diff equ. }
  End;
  blankDiffX:=0+50;
  stnd25DiffY:=Round(100-(100*stnd25Diff/0.5)+50);
  stnd50DiffY:=Round(100-(100*stnd50Diff/0.5)+50);
  Circle(100,150,5);                   { Plotting }
  PutPixel(100,150,15);                {    of    }
  Circle(350,stnd25DiffY,5);           {   the    }
  PutPixel(350,stnd25DiffY,15);        {    3     }
  Circle(600,stnd50DiffY,5);           {   data   }
  PutPixel(600,stnd50DiffY,15);        {  points  }
  delay(5000);
 End;


{ Calculates least squares difference equation from input data }
{ and invokes 'Absorb_Change_v_Urea_Conc_Graph'.               }
Procedure Calibration;
 Var stnd25,stnd50,blankDiff,stnd25Diff,stnd50Diff : Real;
       sigmaX,sigmaY,sigmaXY,sigmaXsqr,meanY,meanX : Real;
                                                 a : Integer;
 Begin
  ClrScr;
  writeln('What is the absorbance reading of the reagent blank?');
  read(blank);
  writeln('What is the absorbance reading of the 25mg/dL standard?');
  read(stnd25);
  writeln('What is the absorbance reading of the 50mg/dL standard?');
  read(stnd50);
  blankDiff:=0;
  stnd25Diff:=blank-stnd25;  { Absorbance change in 25 mg/dL standard }
  stnd50Diff:=blank-stnd50;  { Absorbance change in 50 mg/dL standard }
  sigmaX:=0+25+50;                          { Sum of x values }
  sigmaY:=blankDiff+stnd25Diff+stnd50Diff;  { Sum of y values }
  sigmaXY:=0+25*stnd25Diff+50*stnd50Diff;   { Sum of products of x and y }
  sigmaXsqr:=0+sqr(25)+sqr(50);             { Sum of squares of x values }
  a:=3;                                     { Sum of data points }
  a1:=(a*sigmaXY-sigmaX*sigmaY)/(a*sigmaXsqr-sqr(sigmaX));
  meanY:=sigmaY/a;                          { Average y value }
  meanX:=sigmaX/a;                          { Average x value }
  a0:=meanY-a1*meanX;
  { Least squares difference equation is y = a0 + a1 }
  AbsorbChange_v_UreaConc_Graph(stnd25Diff,stnd50Diff); { Procedure }
  Delay(5000);
 End;


{ Drawing and labelling of axes of graph of urea }
{ concentration against time}
Procedure Urea_v_Time_Axes;
 Var p1,p2,b : Integer;
        VolS : String[5];
           s : String[3];

 Begin
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  OutTextXY(155,2,'Urea Concentration v Time (using online urea monitor)');
  Line(155,10,575,10);
  Str(V:5,VolS);
  OutTextXY(155,22,'Urea pool volume =      ml');
  OutTextXY(305,22,VolS);
  Line(110,50,110,150);      { Drawing }
  Line(110,150,610,150);     {   axes  }
  p1:=50;
  Repeat
   Line(110,p1,105,p1);       {           }
   b:=Round((150-p1)/2);      { Labelling }
   Str(b:2,s);                {           }
   p2:=p1-6;                  {     of    }
   OutTextXY(80,p2,s);        {           }
   p1:=p1+20;                 {     y     }
  Until                       {           }
   p1=170;                    {    axis   }
  p1:=110;                    {           }
  Repeat
   Line(p1,150,p1,155);       {           }
   b:=Round(0.3*(p1-110));    { Labelling }
   Str(b:3,s);                {           }
   p2:=p1-15;                 {    of     }
   OutTextXY(p2,162,s);       {           }
   p1:=p1+100;                {     x     }
  Until                       {           }
   p1=710;                    {   axis    }
  OutTextXY(5,63,'Urea');
  OutTextXY(5,73,'Concentration');
  OutTextXY(5,83,'(mg/dL)');
  OutTextXY(280,180,'Time (minutes)');
 End;


 { Experimental data are plotted on displayed graph }
 { and stored in an array                           }

 Procedure Fill_Array_And_Plot;
 Var time,v_total,volts,sample_volts,AbsorbVal,AbsorbChange : Real;
                                    Ba,T,data,counter,i,x,y : Integer;
                                                    channel : Byte;

 Begin
  RestoreCrtMode;
  writeln('For how many minutes will you be dialysing the urea pool?');
  read(time);
  n := Round(60 * time);
  writeln('What is the size of the urea pool(ml)?');read(V);
  Urea_v_Time_Axes;
  Ba:=$0700;
  Port[Ba+3]:=$92; { Control register }
  For i:=0 To n Do { Loop that reads PC-30 board to calculate  }
  Begin            { a data point every second, that is stored }
                   { in an array and plotted                   }
   channel:=0;     { Analogue channel that PC-30 reads from }
   v_total:=0;
   counter:=0;
   Repeat
    counter:=counter+1;
    Port[Ba+2]:=(channel shl 4)+2;
    Port[Ba+2]:=(channel shl 4)+3;
    For T:=1 To 16 Do  { Wait for 40 microseconds -
                                DAC conversion time}
    Begin
    End;
    data:=((Port[Ba+1] And $0F) shl 8)+Port[Ba];
    volts:=(data*0.00244);    { Conversion of reading to volts }
    v_total:=v_total+volts;   { Summing of 16 measured voltages }
   Until counter = 10;
   sample_volts:=(v_total/counter);   { Calculation of average }
                                      { voltage reading        }
   AbsorbVal:=sample_volts/4;         { Conversion of voltage to absorbance }
   AbsorbChange:=blank-AbsorbVal;     { Calculation of absorbance change }
   UreaConc[i]:=(AbsorbChange-a0)/a1;   { Conversion of absorbance change }
                                        { into urea concentration         }
   x:=Round(110+i/18);
   y:=Round(150-(UreaConc[i]*2));
   PutPixel(x,y,15);                  { Plotting as point on graph }
   Delay(984);   { Delay that restricts loop to one iteration per second }
  End;
  Delay(5000);
 End;


 {  Writes data in array to file }
 Procedure Data_To_File;
 VAR       f : Text;
           i : Integer;
 Begin
  RestoreCrtMode;
  Assign(f,'B:UreaConcs.DAT');
  Rewrite(f);
  For i:=0 To n Do                 { Loop to write each data point }
  writeln(f,UreaConc[i]);          { in array to file              }
  Reset(f);
  Close(f);
 End;


{ Main Program }
 Begin

  DetectGraph(GraphDriver,GraphMode);
  PathToDriver:='';

  Calibration;
  Fill_Array_And_Plot;
  Data_To_File;
{ Clearance_v_Time_Graph;}

 End.