{ Program : Plotter                                              }
{ Written by Paul.T.Smirthwaite                                  }
{                        1/9/91                                  }
{                                                                }
{ This program enables print-outs to be made of the two graphs   }
{ produced by the software ('Record_Urea_Data') used when        }
{ performing urea dialysis. The clearance at every minute, apart }
{ from the first and last 20 minutes, is also calculated and     }
{ displayed (a print-out of these values can also be obtained).  }

PROGRAM Plotter;
 Uses CRT,Dos,Graph;
 Type
 UreaConcentrations = Array[1..10000] of Real;
 Var GraphDriver,GraphMode,n,V : Integer;
                  PathToDriver : String;
                      UreaConc : UreaConcentrations;
                   blank,a0,a1 : Real;


{ Draws and labels axes of graph of absorbance change v. urea    }
{ concentration and plots the least squares difference line with }
{ the 3 data points marked.                                      }
Procedure AbsorbChange_v_UreaConc_Graph (Var stnd25Diff,stnd50Diff : Real);
 Var p1,p2,c,i,x,y,blankDiffX,stnd25DiffY,stnd50DiffY : Integer;
                                                    b : Real;
                                                    s : String[3];
 Begin
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  OutTextXY(190,22,'Absorbance Change v. Urea Concentration');
  Line(190,30,500,30);
  Line(100,50,100,150);   { Drawing }
  Line(100,150,600,150);  {  axes   }
  p1:=50;
  Repeat
   Line(100,p1,95,p1);      {           }
   b:=(150-p1)/200;         { Labelling }
   Str(b:2:1,s);            {           }
   p2:=p1-6;                {    of     }
   OutTextXY(70,p2,s);      {           }
   p1:=p1+20;               {    y      }
  Until                     {           }
   p1=170;                  {   axis    }
  p1:=100;                  {           }
  Repeat
   Line(p1,150,p1,155);     {           }
   c:=Round((p1-100)/10);   { Labelling }
   Str(c:2,s);              {           }
   p2:=p1-7;                {    of     }
   OutTextXY(p2,162,s);     {           }
   p1:=p1+100;              {    y      }
  Until                     {           }
   p1=700;                  {   axis    }
  OutTextXY(5,73,'Absorbance');
  OutTextXY(5,83,'Change');
  OutTextXY(230,180,'Urea Concentration (mg/dL)');
  For i:=0 To 200 Do  { Loop that draws least squares difference line }
  Begin
   y:=Round(100-(100*(a0+a1*i)/2)+50);
   x:=Round(100+i*2.5);
   PutPixel(x,y,15);  { Plotting point according to L.S. diff equ. }
  End;
  blankDiffX:=0+50;
  stnd25DiffY:=Round(100-(100*stnd25Diff/0.5)+50);
  stnd50DiffY:=Round(100-(100*stnd50Diff/0.5)+50);
  Circle(100,150,5);                   { Plotting }
  PutPixel(100,150,15);                {    of    }
  Circle(350,stnd25DiffY,5);           {   the    }
  PutPixel(350,stnd25DiffY,15);        {    3     }
  Circle(600,stnd50DiffY,5);           {   data   }
  PutPixel(600,stnd50DiffY,15);        {  points  }
 End;


{ Calculates least squares difference equation from input data }
{ and invokes 'Absorb_Change_v_Urea_Conc_Graph'.               }
Procedure Calibration;
 Var stnd25,stnd50,blankDiff,stnd25Diff,stnd50Diff : Real;
       sigmaX,sigmaY,sigmaXY,sigmaXsqr,meanY,meanX : Real;
                                                 a : Integer;
 Begin
  ClrScr;
  writeln('What is the absorbance reading of the reagent blank?');
  read(blank);
  writeln('What is the absorbance reading of the 25mg/dL standard?');
  read(stnd25);
  writeln('What is the absorbance reading of the 50mg/dL standard?');
  read(stnd50);
  blankDiff:=0;
  stnd25Diff:=blank-stnd25; { Absorbance change in 25 mg/dL standard }
  stnd50Diff:=blank-stnd50; { Absorbance change in 50 mg/dL standard }
  sigmaX:=0+25+50;                         { Sum of x values }
  sigmaY:=blankDiff+stnd25Diff+stnd50Diff; { Sum of y values }
  sigmaXY:=0+25*stnd25Diff+50*stnd50Diff;  { Sum of products of x and y }
  sigmaXsqr:=0+sqr(25)+sqr(50);            { Sum of squares of x values }
  a:=3;                                    { Sum of data points }
  a1:=(a*sigmaXY-sigmaX*sigmaY)/(a*sigmaXsqr-sqr(sigmaX));
  meanY:=sigmaY/a;                         { Average y value }
  meanX:=sigmaX/a;                         { Average x value }
  a0:=meanY-a1*meanX;
  { Least squares difference equation is y = a0 + a1 }
  AbsorbChange_v_UreaConc_Graph(stnd25Diff,stnd50Diff); { Procedure }
  Delay(5000);
 End;


{ Drawing and labelling of axes of graph of urea }
{ concentration against time }
Procedure Urea_v_Time_Axes;
 Var p1,p2,b : Integer;
        VolS : String[5];
           s : String[3];

 Begin
  InitGraph(GraphDriver,GraphMode,PathToDriver);
  OutTextXY(155,2,'Urea Concentration v Time (using online urea monitor)');
  Line(155,10,575,10);
  Str(V:5,VolS);
  OutTextXY(155,22,'Urea pool volume =        ml');
  OutTextXY(305,22,VolS);
  Line(110,50,110,150);     { Drawing }
  Line(110,150,610,150);    {  axes   }
  p1:=50;
  Repeat
   Line(110,p1,105,p1);      {           }
   b:=Round((150-p1)/2);     { Labelling }
   Str(b:2,s);               {           }
   p2:=p1-6;                 {    of     }
   OutTextXY(80,p2,s);       {           }
   p1:=p1+20;                {     y     }
  Until                      {           }
   p1=170;                   {   axis    }
  p1:=110;                   {           }
  Repeat
   Line(p1,150,p1,155);      {           }
   b:=Round(0.3*(p1-110));   { Labelling }
   Str(b:3,s);               {           }
   p2:=p1-15;                {    of     }
   OutTextXY(p2,162,s);      {           }
   p1:=p1+100;               {     x     }
  Until                      {           }
   p1=710;                   {    axis   }
  OutTextXY(5,63,'Urea');
  OutTextXY(5,73,'Concentration');
  OutTextXY(5,83,'(mg/dL)');
  OutTextXY(280,180,'Time (minutes)');
 End;


{ Array is filled with data points from file made during period of dialysis.}
{ Array then used to plot graph of urea concentration against time.}
 Procedure Fill_Array_And_Plot;
 Var     f : Text;
     i,x,y : Integer;
         j : Real;

 Begin
  RestoreCrtMode;
  Assign(f,'B:UreaConcs.DAT');
  Reset(f);
  writeln('How many data points are there? (sampling rate was 1 per sec)');
  read(n);
  writeln('What was the volume of the urea pool(ml)?');read(V);
  For i:=0 To n Do
  Begin
   Readln(f,j);
   UreaConc[i] := j;
  End;
   Urea_v_Time_Axes;
   For i := 0 To n Do                {  Loop    }
   Begin                             {  using   }
    x := Round(110+i/18);            {  values  }
    y := Round(150-(UreaConc[i]*2)); { in array }
    PutPixel(x,y,15);                { to plot  }
   End;                              {  graph   }
  Close(f);
  Delay(5000);
 End;


{ Calculates and displays clearance values }
Procedure Clearance;
Var                 a,i,j,t1,t2 : Integer;
    sigmaCt1,sigmaCt2,Ct1,Ct2,K : Real;

 Begin
  RestoreCrtMode;
  a:=0;
  For i:=21 To 129 Do
  Begin
   sigmaCt1:=0;
   sigmaCt2:=0;
   For j:=0 To 59 Do
   Begin
    t1:=(60*i)+1-1230+j;
    sigmaCt1:=sigmaCt1+UreaConc[t1]; { Sum of Co values over a minute }
    t2:=t1+2400;
    sigmaCt2:=sigmaCt2+UreaConc[t2]; { Sum of Ct values over a minute }
   End;
   Ct1:=sigmaCt1/60;    { Calculation of average Co value }
   Ct2:=sigmaCt2/60;    { Calculation of average Ct value }
   K := -(V/40)*(ln(Ct2/Ct1)); { Calculation of clearance }
   { Displaying clearance at corresponding time }
   writeln('After ',i:3,' minutes of dialysing the clearance was ',K:4:1);
   a:= a + 1;
   If a=24 Then
   Begin
    a:=0;
    Delay(2000);
   End;
  End;
 End;


{ Main Program }
 Begin

  DetectGraph(GraphDriver,GraphMode);
  PathToDriver:='';

  Calibration;
  Fill_Array_And_Plot;
  Clearance;

 End.