#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

# Local host level probe - source: /proc file-system

#arg0 - log file
#arg1 - sampling time interval


if (scalar @ARGV < 2) {die "check usage\n";}
print "Probing on the host level...\n";

open(LOG, ">$ARGV[0]");

# setting autoflush ON
{ my $ofh = select LOG;
	$| = 1;
	select $ofh;
}


print LOG "ts\tjobs waiting\tjobs no\tfreemem\n";
print LOG "==\t============\t=======\t=======\n\n";

while(1)
{
	#read/calculate log entries

	#ts
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000;
	($y, $microsecdec) = split('\.', $microseconds);
	#$ts = "$seconds.$microsecdec";
	$ts = "$seconds";
		
	#system load - source: /proc/loadavg
	open(LOADAVG, "</proc/loadavg");
	@lines = <LOADAVG>;
	($f1, $f2, $f3, $f4, $f5) = split(' ',  $lines[0]);
	$jobsw = $f1;
	($y, $jobsn) = split('/', $f4);	

	#memory utilization - source: /proc/meminfo
	open(MEMINFO, "</proc/meminfo");
	@lines = <MEMINFO>;
	$lines[1] =~ /\d+/;
	$freemem = $&;


	print LOG "$ts\t$jobsw\t$jobsn\t$freemem\n";
	usleep($ARGV[1]);
}

close(LOG);
