#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

# httpd daemon process level probe - source: /proc file-system

#arg0 - log file
#arg1 - sampling time interval


if (scalar @ARGV < 2) {die "check usage\n";}
print "Probing on the process level...\n";

open(LOG, ">$ARGV[0]");

# setting autoflush ON
{ my $ofh = select LOG;
	$| = 1;
	select $ofh;
}



print LOG "ts\t\tmemory\tthreads\tfd\treadbytes\twrittenbytes\tchildp\n";
print LOG "==\t\t======\t=======\t==\t=========\t============\t======\n\n";

while(1)
{
	#read/calculate log entries

	# getting apache pids
	open(PS, "ps -e \| grep apache |");
	@lines = <PS>;
	@pids = ();
	foreach $line (@lines)
	{
		($a, $b, $c, $d) = split(' ', $line);
		push(@pids, $a);

	}


	#ts
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000;
	($y, $microsecdec) = split('\.', $microseconds);
	#$ts = "$seconds.$microsecdec";
	$ts = "$seconds";
		
	#total memory, threads - source: /proc/pid/status
	$mem = 0;
	$threads = 0;
	foreach $pid (@pids)
	{
		open(STATUS, "</proc/$pid/status");
		@lines = <STATUS>;
		($f1, $f2, $f3) = split(' ',  $lines[11]);
		$mem += $f2;
		($f1, $f2) = split(' ',  $lines[20]);
		$threads += $f2;
	}

	#total fd's - source: /proc/pid/fd
	$fd = 0;
	foreach $pid (@pids)
	{
		open(FD, "ls -la /proc/$pid/fd \| wc -l |");
		@lines = <FD>;
		$f1 = $lines[0];
		$fd += $f1;
	}


	#io - source: /proc/pid/io
	$readbytes = 0;
	$writebytes = 0;
	foreach $pid (@pids)
	{
		open(IO, "</proc/$pid/io");
		@lines = <IO>;
		($f1, $f2) = split(' ',  $lines[4]);
		$readbytes += $f2;
		($f1, $f2) = split(' ',  $lines[5]);
		$writebytes += $f2;
	}

	#child process list - sources: /proc/pid/status /proc/pid/cmdline
	$cmdlist = "";
	@childps = ();
	@pidlist = ();
	open(PIDLIST, "ls -l /proc |");
	@lines = <PIDLIST>;
	foreach $line (@lines)
	{
		($a, $b, $c, $d, $e, $f, $g, $h) = split(' ', $line);
		if($h =~ /^\d+/)
		{
			push(@pidlist, $h);
		}


	}

	foreach $pidlistmem (@pidlist)
	{
		open(STATUS, "</proc/$pidlistmem/status");
		@lines = <STATUS>;
		($f1, $f2) = split(' ',  $lines[4]);
		$ppid = $f2;

		foreach $pid (@pids)
		{
			push(@childps, $pidlistmem) if $ppid eq $pid;

		}


	}

	foreach $childp (@childps)
	{
		open(CMDLINE, "</proc/$childp/cmdline");
		@lines = <CMDLINE>;
		$f1 = $lines[0];
		$cmdlist .= "##$f1";
	}


	print LOG "$ts\t$mem\t$threads\t$fd\t$readbytes\t\t$writebytes\t\t$cmdlist\n";
	usleep($ARGV[1]);
}

close(LOG);
