#!/usr/bin/perl

if (scalar @ARGV < 2) {die "check usage\n";}

#arg0 - imcpin.log file
#arg1 - icmpin.rate file


# Calculating first $previcmp
open(INFILE, "$ARGV[0]") or die "Cannot open input file: $!\n";
$inline = <INFILE>; 
($ts, $previcmp) = split(" ", $inline);
$previcmp = 0 if $previcmp !~ /.+/; # transforming empty entries to 0
close(INFILE);


# Starting conversion to packets/sec proper
open(INFILE, "$ARGV[0]") or die "Cannot open input file: $!\n";
open(OUTFILE, ">$ARGV[1]") or die "Cannot open output file: $!\n";

while($inline = <INFILE>) 
{
	# read next line
	($ts, $icmp) = split(" ", $inline);
	$icmp = 0 if $icmp !~ /.+/; # transforming empty entries to 0

	$icmprate = $icmp - $previcmp;

	print OUTFILE "$ts $icmprate\n";
	$previcmp = $icmp;

}

close(INFILE);
close(OUTFILE);

