#!/usr/bin/perl

# A scripts that calculates the average MCAV and st. dev. for the multiple experiment runs

if(scalar @ARGV < 3) { die "check usage\n"; }

#arg0 - path of directory storing results files
#arg1 - start results file (inclusive)
#arg2 - end results file (inclusive)

#structure for storing antigen and MCAV values
%antigen = ();

#structure for storing antigen and avg/stdev results
%results = ();


# fill antigen structure
$i = $ARGV[1];
$to = $ARGV[2]+1;

while($i < $to)
{
	open(FP, "<$ARGV[0]/results"."$i".".log") or die "Couldn't open file $?";
	while($inline = <FP>)
	{
		($a, $b, $c) =  split(" ", $inline);

		if( $a =~ /(S_K:|I_S:|i_bar:)/ )
		{
			if ( ! exists($antigen{"$a"}) )
			{
				$antigen{"$a"} = [($b)];
			} else {
				$val = $antigen{"$a"};
				@tmparray = @$val;
				push(@tmparray, $b);
				$antigen{"$a"} = [@tmparray];	
				#print "$a - @tmparray\n";
				#print "==============\n";
			}
			next;
		}

		if ( ! exists($antigen{"$a"}) )
		{
			$antigen{"$a"} = [($c)];
		} else {
			$val = $antigen{"$a"};
			@tmparray = @$val;
			push(@tmparray, $c);
			$antigen{"$a"} = [@tmparray];	
			#print "$a - @tmparray\n";
			#print "==============\n";
		}

	}


	$i++;

}

close(FP);

#@ant = %antigen;
#print "\n\n@ant\n\n";

# fill results structure

foreach  $antigenentry (keys %antigen)
{

	$n=0; $runn_tot=0; $avg=0; $runn_diff=0;  $stdev=0;
	@differences = ();

	#calc n and runn_tot
	$val = $antigen{$antigenentry};
	@mcav = @$val;
	foreach $mcaventry (@mcav)
	{
		$runn_tot += $mcaventry;
		$n++;

	}


	#calc avg
	$avg = ($runn_tot / $n);

	#create differences
	foreach $mcaventry (@mcav)
	{
		$diff = abs($mcaventry - $avg);
		push(@differences, $diff);
	}	
	

	#cal std. dev
	foreach $diffentry (@differences)
	{
		$runn_diff += $diffentry;
	}	
	$stdev = ($runn_diff / $n);

	#update results hash
	$results{$antigenentry} = [($avg,$stdev)];

	# output results
	print "$antigenentry $avg $stdev\n";	

}



