/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* misc api                                                                   */
/******************************************************************************/

#include "misc.h"

#include <err.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <fcntl.h>

static FILE *logfp = NULL;  /* logfile */

inline void randomise_list(const unsigned int size)
{
	register unsigned int i, ind;
	register int tmp;

	if(size > MAX_LIST_SIZE)
		errx(1, "random_list too big to randomise");
	for(i = 0; i < size; i++)
		randlist[i] = i;
	for(i = 0; i < size; i++) {
		ind = (int) (((double) size * rand()) / (RAND_MAX + 1.0));
		tmp = randlist[i];
		randlist[i] = randlist[ind];
		randlist[ind] = tmp;
	}
}

inline void randomise_list_2(const unsigned int size)
{
	register unsigned int i, ind;
	register int tmp;

	if(size > MAX_LIST_SIZE)
		errx(1, "random_list too big to randomise");
	for(i = 0; i < size; i++)
		randlist2[i] = i;
	for(i = 0; i < size; i++) {
		ind = (int) (((double) size * rand()) / (RAND_MAX + 1.0));
		tmp = randlist2[i];
		randlist2[i] = randlist2[ind];
		randlist2[ind] = tmp;
	}
}

/* list same size as last time randomised */
inline void randomise_list_fast(const unsigned int size)
{
	register unsigned int i, ind;
	register int tmp;

	for(i = 0; i < size; i++) {
		ind = (int) (((double) size * rand()) / (RAND_MAX + 1.0));
		tmp = randlist[i];
		randlist[i] = randlist[ind];
		randlist[ind] = tmp;
	}
}

char *freadline(char *line, int size, FILE *fp)
{
	char *p;

	if (fgets(line, size, fp) == NULL)
		return NULL;
	if ((p = strchr(line, '\n')) == NULL)
		return line;	/* just terminate */
	*p = '\0';

	return line;
}

void open_log(char *filename)
{
	if(!(logfp = fopen(filename, "w")))
		err(1, "couldn't open logfile");
}

void write_log(char *message)
{
	static struct timeval curtime;

	gettimeofday(&curtime, NULL);
	fprintf(logfp, "%d.%06d %s\n", (int) curtime.tv_sec, (int) curtime.tv_usec, message);
}

void close_log(void)
{
	if(logfp)
		fclose(logfp);
}

inline void timeval_diff(struct timeval *ts1, struct timeval *ts2, \
		struct timeval *dtime)
{
	register long long secs, usecs;
	
	secs = (long long) ts2->tv_sec - ts1->tv_sec;
	usecs = (long long) ts2->tv_usec - ts1->tv_usec;

	if(secs < 0)
		goto error;
	if(usecs < 0) {
		if(secs == 0)
			goto error;
		secs -= 1;
		usecs += 1000000;
	}
	dtime->tv_sec = (time_t) secs;
	dtime->tv_usec = (suseconds_t) usecs;
	return;
	error:
		dtime->tv_sec = dtime->tv_usec = 0;
}

inline double add_noise(double val, double noise)
{
	register double ret;

	return (ret = val + 2.0 * noise * drand48() - noise) > 0.0 ? ret : 0.0;
}

/* set sctp socket nonblocking */
int sctp_setnonblocking(int sd)
{
	int flags = fcntl(sd, F_GETFL, 0);
	
	if(flags != -1) {
		flags |= O_NONBLOCK;
		if(fcntl(sd, F_SETFL, flags) == 0)
			return 0;
	}
	return -1;
}
