/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* receptor api                                                               */
/******************************************************************************/

#ifndef RECEPTOR_H
#define RECEPTOR_H

#include "antigen.h"
#include "cytokine.h"

#define DEF_CYTOKINE_RECEPTOR_NOISE	0.01
#define DEF_CELL_RECEPTOR_EFFICIENCY	1.0

/* antigen receptor (DEC-205 + CD36 sort of) */
typedef struct {
} Antigen_Receptor;

/* cytokine receptor */
typedef struct {
	int id;  /* id of cytokine receptor responds to */
	double val;  /* level of cytokine in tissue */
	double noise;  /* noise range */
} Cytokine_Receptor;

/* cell receptor */
typedef struct {
	int type;  /* type of cell receptor responds to */
	int state;  /* state pf cell receptor responds to */
	double efficiency;  /* efficiency with which receptor binds */
	struct Cell *cell;  /* cell receptor connected to */
} Cell_Receptor;

/* variable region receptor (t-cell receptor) */
typedef struct {
	int type;  /* type of cell receptor responds to */
	int state;  /* state of cell receptor responds to */
	struct Cell *cell;  /* cell receptor connected to */
	Antigen *lock;  /* antigen receptor responds to */
	Antigen *key;  /* antigen receptor responding to */
	double threshold;  /* threshold abover which receptor activated */
	short unsigned int activated;  /* flag set when receptor activated */
	double (*match)(Antigen *, Antigen *);  /* matching function */
} VR_Receptor;

/* function prototypes */
Antigen_Receptor *init_antigen_receptor(void);
void free_antigen_receptor(Antigen_Receptor *);
Cytokine_Receptor *init_cytokine_receptor(void);
void free_cytokine_receptor(Cytokine_Receptor *);
Cell_Receptor *init_cell_receptor(void);
void free_cell_receptor(Cell_Receptor *);
VR_Receptor *init_vr_receptor(void);
void free_vr_receptor(VR_Receptor *);

#endif
