/* Csv module - formats csv files into HTML
 *
 */

#include <httpd.h>
#include <http_protocol.h>
#include <http_config.h>
#include <stdio.h>
#include <string.h>

typedef struct filetoreturn 
{
	char name[512]; 
	char args[512];  //Overflow vulnerability potential of buffer overflows in pointer to function
	int (*procf) (char*, request_rec*);
	char futureuse[512]; 

} filename;


int plaintext(char *filename, request_rec *r)
{
	FILE *fp;
	int c, ret;

	fp = fopen(filename, "r");
	if(fp == NULL) return 1;
  	ap_rputs("</h1><table>", r);
	ap_rputs("<tr><td>" ,r);
	while((c = getc(fp)) != EOF)
	{
		switch(c)
		{
			case ',':
				ap_rputs("</td><td>", r);
				break;
			case '\n':
				ap_rputs("</td></tr><tr><td>", r);
				break;
			default:
				ap_rputc(c, r);
		}
	}
	ap_rputs("</tr></td>" ,r);
  	ap_rputs("</table></body></html>", r) ;
	return 0;

}

int bordertext(char *filename, request_rec *r)
{
	FILE *fp;
	int c, ret;

	fp = fopen(filename, "r");
	if(fp == NULL) return 1;
  	ap_rputs("</h1><table border=2>", r);
	ap_rputs("<tr><td>" ,r);
	while((c = getc(fp)) != EOF)
	{
		switch(c)
		{
			case ',':
				ap_rputs("</td><td>", r);
				break;
			case '\n':
				ap_rputs("</td></tr><tr><td>", r);
				break;
			default:
				ap_rputc(c, r);
		}
	}
	ap_rputs("</tr></td>" ,r);
  	ap_rputs("</table></body></html>", r) ;
	return 0;

}

int outputcsv(filename *fn, request_rec *r)
{
	int ret;
	char* temp;

  	ap_set_content_type(r, "text/html;charset=ascii") ;
	ap_rputs("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">\n", r) ;
	ap_rputs("<html><head><title>mod_csv file</title></head>", r);
  	ap_rputs("<body><h1>", r);
  	ap_rputs(fn->name, r);
	temp = fn->args; //Buffer is now accessible via edx	
  	ap_rputs("<br/>", r);
  	ap_rputs(temp, r);
  	ap_rputs("<br/>", r);
	ret = fn->procf(fn->name, r);
	if (ret == 1) return 1;
	return 0;
}


static int csv_handler(request_rec *r) {
  if ( !r->handler || strcmp(r->handler, "csv") ) {
    return DECLINED ;   /* none of our business */
  }
  if ( r->method_number != M_GET ) {
    return HTTP_METHOD_NOT_ALLOWED ;  /* Reject other methods */
  }

	// read source file and set converter function as one of a set of pre-defined conversion functions
	filename *myfilename = malloc(sizeof(filename));
	strcpy(myfilename->name, r->filename);
	myfilename->procf = plaintext;
	fprintf(stderr, "Buffer is at %p\n", &myfilename->args[0]);
	fprintf(stderr, "Pointer to f is pointing to %p\n", myfilename->procf);
	if(r->args != NULL) strcpy(myfilename->args, r->args);
	ap_unescape_url(myfilename->args);
	fprintf(stderr, "Pointer to f is pointing to %p\n", myfilename->procf);
	fflush(stderr);
	if(strcmp(myfilename->args,"mode=1") == 0)
	{
		myfilename->procf = bordertext;
	}
	if((outputcsv(myfilename, r)) == 1) return DECLINED;
	free(myfilename);
  	return OK ;
}
/* Hook our handler into Apache at startup */
static void csv_hooks(apr_pool_t* pool) {
  ap_hook_handler(csv_handler, NULL, NULL, APR_HOOK_MIDDLE) ;
}
module AP_MODULE_DECLARE_DATA csv_module = {
        STANDARD20_MODULE_STUFF,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        csv_hooks
} ;

