#!/usr/bin/perl

# signprobe - wpt danger signals client probe

use IO::Socket::INET;
use threads;
use threads::shared;

# arg0 - sandbox ip
# arg1 - sandbox port
# arg2 - process name for web server processes optional default:apache2
# arg3 - webroot

if (scalar @ARGV < 3) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#flush all outout buffers
$|=1;
my $lockconn :shared; #lock var for the network connection in order to avoid d1/d2 mix-up due to threads

sub straceloop
{

my $conn = $_[0];

#launch strace and bind to web server request serving processes
# Getting the pid's of apache listener processes
open(PID, "pidof $pname|"); 
$pidlist = <PID>;
chomp($pidlist);
@childp = split(/ /, $pidlist);

#$rootpid = pop @childp; # Exluded the root process at a first attempt but this restricted the attachment newly spawned worker processes

$i=0;
foreach $pid (@childp)
{
	$childp[$i] = '-p '.$childp[$i];
	$i++;
}

$stracepids = join(' ', @childp);
open(STRACE, 'strace -vfq -e trace=connect,bind '.$stracepids.' 2>&1 |');

#start reading strace lines 
while($straceline = <STRACE>)
{

	#convert to a code/key string and send
	$dangercode = "";
	$dangerkey = "";


	if($straceline =~ /sa_family=AF_INET, sin_port=htons\((\d+)\), sin_addr=inet_addr\(\"(.*?)\"\)/i)
	{
		$dangercode = "d1";
		$dangerkey = "$2:$1";

		#send code/key string to output
		$dangersignal =  "$dangercode: $dangerkey\n";
		lock $lockconn;
		print $conn $dangersignal;
	}


}

}



sub codebasemodloop
{

my $conn = $_[0];

	while(1)
	{
		
	sleep 60;

	@modifiedfiles = ();
        open(FIND, "find -L $webroot -type f -mmin 1 |");
        @lines = <FIND>;
        foreach $line (@lines)
        {
                chomp($line);
                $line =~ /(\/)(\w+?\/)*(.*)/;
                $filepart = $3;
                $line =~ /(.*?)$filepart/;
		if($line =~ /\.php\s*$/) # we are interested in the php codebase
		{
                        push(@modifiedfiles, $line);
		}
        }
        close(FIND);

	#send code/key string to output
        foreach $modfile (@modifiedfiles)
  	{
		open(MODFILE, "<$modfile");
                $dangersignal =  "d2: contentstart\n";
		while($modfilecontent = <MODFILE>)
		{
                	$dangersignal .=  "$modfilecontent";
		}
		close(MODFILE);
                $dangersignal .=  "\nd2: contentend\n";
		{lock $lockconn; # lock block
                print $conn $dangersignal;}
       	}

	}


}



# process input arguments
$pname = "apache2";
if ($ARGV[2]) {$pname = $ARGV[2]};

$webroot = "/var/www";
if ($ARGV[3]) {$webroot = $ARGV[3]};

print STDOUT "Starting wptdangercl\n";

#create connection with server
$conn = IO::Socket::INET->new(PeerAddr => $ARGV[0],
				PeerPort => $ARGV[1],
				Proto => 'tcp') or die "Cannot connect to server\n"; 

#Luanch strace thread
$strcthread = threads->new(\&straceloop, $conn);

#Luanch codebasemod thread
$codebasemodthread = threads->new(\&codebasemodloop, $conn);

$strcthread->join();
$codebasemodthread->join();
