#!/usr/bin/perl

#arg0 = step number

if(scalar @ARGV < 1){die "check usage\n";}

$astart = 0;
$aend = 0;
$bstart = 0;
$bend = 0;
$cstart = 0;
$cend = 0;
$dstart = 0;
$dend = 0;
$estart = 0;
$eend = 0;
$psid = "";
$did = "";


@acolumn =  ();
@bcolumn =  ();
@ccolumn =  ();
@dcolumn =  ();
@ecolumn =  ();
@pscolumn =  ();
@symcolumn =  ();

$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotpampcl.log");
while($line = <F>)
{
	$start = $end = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$start = $2;
	$end = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		$avg = $cumtotal / $entries;
		push(@acolumn, "$avg");
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@acolumn, "0");
		}
	}
	}

	$cumtotal += ($end-$start);
	$prevstart = $start;
	$entries++;
}
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	$avg = $cumtotal / $entries;
	push(@acolumn, "$avg");
}
close(F);


$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotdangercl.log");
while($line = <F>)
{
	$start = $end = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$start = $2;
	$end = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		$avg = $cumtotal / $entries;
		push(@ccolumn, "$avg");
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@ccolumn, "0");
		}
	}
	}

	$cumtotal += ($end-$start);
	$prevstart = $start;
	$entries++;
}
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	$avg = $cumtotal / $entries;
	push(@ccolumn, "$avg");
}
close(F);



$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotpamps.log");
while($line = <F>)
{
	$id = $start = $dur = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$id = $1;
	$start = $2;
	$dur = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		if($entries>0)
		{
			$avg = $cumtotal / $entries;
			push(@bcolumn,"$avg");
		}
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@bcolumn, "0");
		}
	}
	}

	$cumtotal += $dur;
	$entries++;
	$prevstart = $start;
}

if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	if($entries>0)
	{
		$avg = $cumtotal / $entries;
		push(@bcolumn, "$avg");
	}
}
close(F);


%link = ();
open(FLINK,"<step$ARGV[0]/webiotperflogs/webiotdangersinit.log");
while($linkline = <FLINK>)
{
	$id = $start = 0;
	$linkline =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$id = $1;
	$start = $2;
	$link{"$id"} = $start;
}
close(FLINK);


$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotdangers.log");
while($line = <F>)
{
	$id = $start = $end = 0;
	$line =~ /\"(.*?)-(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$id = $2;
	$start = $3;
	$end = $4;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		if($entries>0)
		{
			$avg = $cumtotal / $entries;
			push(@dcolumn,"$avg");
		}
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@dcolumn, "0");
		}
	}
	}

	if($link{"$id"})
	{
		$cumtotal += ($end - $link{"$id"});
		$prevstart = $start;
		$entries++;
	}
	$prevstart = $start;
}
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	if($entries>0)
	{
		$avg = $cumtotal / $entries;
		push(@dcolumn, "$avg");
	}
}
close(F);

$pscumtotal = $symcumtotal =  0;
$psavg =  $symavg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotrepsnapshots.log");
while($line = <F>)
{
        $start = $end = 0;
        $line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
        $start = $1;
        $pssize = $2;
        $symsize = $3;

        if($firstentry == 1)
        {
                $prevstart = $start;
                $firstentry=0;
        }

        if( ($start - $prevstart) > 239) # close current 5 minute slot
        {
                $psavg = $pscumtotal / $entries;
                push(@pscolumn, "$psavg");
                $symavg = $symcumtotal / $entries;
                push(@symcolumn, "$symavg");
                $pscumtotal = $symcumtotal = 0;
                $psavg = $symavg = 0;
                $entries = 0;

        }

        $pscumtotal += $pssize;
        $symcumtotal += $symsize;
        $prevstart = $start;
        $entries++;
}
if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
        $psavg = $pscumtotal / $entries;
        push(@pscolumn, "$psavg");
        $symavg = $symcumtotal / $entries;
        push(@symcolumn, "$symavg");
}
close(F);


$cumtotal = 0;
$avg = 0;
$entries = 0;
$firstentry=1;
open(F,"<step$ARGV[0]/webiotperflogs/webiotattackid.log");
while($line = <F>)
{
	$id = $start = $dur = 0;
	$line =~ /\"(.*?)\",\"(.*?)\",\"(.*?)\"/;
	$id = $1;
	$start = $2;
	$dur = $3;

	if($firstentry == 1)
	{
		$prevstart = $start;		
		$firstentry=0;
	}

	if( ($start - $prevstart) > 239) # close current 5 minute slot
	{
		if($entries>0)
		{
			$avg = $cumtotal / $entries;
			push(@ecolumn,"$avg");
		}
		$cumtotal = 0;
		$avg = 0;
		$entries = 0;

	#zero fill any skipped 5 min slot
	{
		use integer;
		$numzeroslots = ($start-$prevstart) / 240;
		$numzeroslots--; #considering just the extra slots
		for($i=0;$i<$numzeroslots;$i++)
		{
			push(@ecolumn, "0");
		}
	}
	}

	$cumtotal += $dur;
	$entries++;
	$prevstart = $start;
}

if($entries > 0) # include any pending entries at the end of file even if 5 mins havent elapsed
{
	if($entries>0)
	{
		$avg = $cumtotal / $entries;
		push(@ecolumn, "$avg");
	}
}
close(F);


# display info.
$len = scalar @acolumn;
print STDERR "\nA list is $len in length\n";
print STDERR "====\n";
foreach $entry (@acolumn)
{
	#print STDERR "$entry\n";
}
$len = scalar @bcolumn;
print STDERR "\nB list is $len in length\n";
print STDERR "====\n";
foreach $entry (@bcolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @ccolumn;
print STDERR "\nC list is $len in length\n";
print STDERR "====\n";
foreach $entry (@ccolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @dcolumn;
print STDERR "\nD list is $len in length\n";
print STDERR "====\n";
foreach $entry (@dcolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @ecolumn;
print STDERR "\nE list is $len in length\n";
print STDERR "====\n";
foreach $entry (@ecolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @pscolumn;
print STDERR "\nPS list is $len in length\n";
print STDERR "====\n";
foreach $entry (@pscolumn)
{
	#print STDERR "$entry\n";
}

$len = scalar @symcolumn;
print STDERR "\nSym list is $len in length\n";
print STDERR "====\n";
foreach $entry (@symcolumn)
{
	#print STDERR "$entry\n";
}

#create output
$i=0;
print "\"A\",\"B\",\"C\",\"D\",\"E\",\"PS\",\"SYM\"\n";
foreach $acell (@acolumn)
{
	$a = $acolumn[$i];
	$b = $bcolumn[$i];
	$c = $ccolumn[$i];
	$d = $dcolumn[$i];
	$e = $ecolumn[$i];
	$ps = $pscolumn[$i];
	$sym = $symcolumn[$i];
	print "\"$a\",\"$b\",\"$c\",\"$d\",\"$e\",\"$ps\",\"$sym\"\n";
	$i++;
}



