/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* syscall api - syscall/systrace stuff                                       */
/* some code from neils + marius                                              */
/******************************************************************************/

#include "syscall.h"
#include "misc.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int syscall_number(char *syscall)
{
	int i;

	for(i = 0; i < nsyscalls; i++)
		if(strcmp(syscall, sysent[i].sys_name) == 0)
			break;
	if(i == nsyscalls)
		return -1;
	else
		return i;
}

inline char *syscall_name(const int number, char *name)
{
	if(number < 0 || number >= nsyscalls)
		return NULL;

	strcpy(name, sysent[number].sys_name);

	return name;
}

inline int systrace_syscall_number(char *name)
{
	register int i;

	for(i = 0; i < NR_syscalls; i++)
		if(strcmp(linux_syscallnames[i], name) == 0)
			return i;

	return -1;
}

inline char *systrace_syscall_name(const int number, char *name)
{
	if(number < 0 || number >= NR_syscalls)
		return NULL;

	strcpy(name, linux_syscallnames[number]);

	return name;
}

/* return argument format type */
inline int syscall_arg_type(const int code)
{
	if(code < 0 || code >= NR_syscalls)
		return -1;
	/* open, unlink, execve, chdir, stat */
	/* access, mkdir, rmdir, chroot */
	/* lstat, readlink, stat64, lstat64 */
	if(code == 5 || code == 10 || code == 11 || code == 12 || code == 18 || \
			code == 33 || code == 39 || code == 40 || code == 61 || \
			code == 84 || code == 85 || code == 195 || code == 196)
		return SARG_TYPE_1;  /* # + filename */
	if(code == 94)  /* fchmod: fd + mode */
		return SARG_TYPE_2;  /* # + fd + mode */
	if(code == 207)  /* fchown: fd + uid + gid */
		return SARG_TYPE_3;  /* # + fd + uid + gid */
	if(code == 212)  /* chown: fn + uid + gid */
		return SARG_TYPE_4;  /* # + fn + uid + gid */
	if(code == 213)  /* setuid: uid + uname */
		return SARG_TYPE_5;  /* # + uid + uname */
	if(code == 214)  /* setgid: gid */
		return SARG_TYPE_6;  /*  # + gid */
	/* unimplemented:
		link 9
		chmod 15
		kill 37
		rename 38
		symlink 83
		socketcall 102
	*/
	return SARG_TYPE_0;  /* syscall # only */
}

/* return 0 if valid systrace request + fill structure with request info */
int systrace_request(char *input, Systrace_Request *request)
{
	char line[256], *p;

	gettimeofday(&request->tm, NULL);
	strncpy(line, input, 256);
	p = line;
	strncpy(request->process_name, strsep(&p, ","), 256);
	if (p == NULL || *p == '\0')
		return 1;
	p++;
	strsep(&p, " ");
	if (p == NULL || *p == '\0')
		return 1;
	strncpy(request->process_id, strsep(&p, "("), 256);
	if (p == NULL || *p == '\0')
		return 1;
	strsep(&p, ":");
	if (p == NULL || *p == '\0')
		return 1;
	p++;
	strncpy(request->policy_name, strsep(&p, ","), 256);
	if (p == NULL || *p == '\0')
		return 1;
	strsep(&p, ":");
	if (p == NULL || *p == '\0')
		return 1;
	p++;
	strncpy(request->filters, strsep(&p, ","), 256);
	if (p == NULL || *p == '\0')
		return 1;
	request->num_filters = atoi(request->filters);
	strsep(&p, ":");
	if (p == NULL || *p == '\0')
		return 1;
	p++;
	strncpy(request->syscall_info, p, 256);

	return 0;  /* is a request */
}

int get_policy_filename(int pid, char *policy_file)
{
	FILE *fp;
	char line[256], proc_file[256], *p;

	snprintf(proc_file, 256, "/proc/%d/cmdline", pid);
	if((fp = fopen(proc_file, "r")) == NULL)
		return 1;
	freadline(line, 256, fp);
	fclose(fp);
	while((p = index(line, '/')) != NULL)
		*p = '_';
	snprintf(policy_file, 256, "%s/.systrace/%s", getenv("HOME"), line + 1);

	return 0;
}
