#!/usr/bin/perl

# sigprobe - webiot client probe
# Requires tshark with dissectors: frame:sll:ip:tcp:http:mime_multipart:mysql

use IO::Socket::INET;
use URI::Escape;
use threads;
use threads::shared;

# arg0 - sandbox ip
# arg1 - sandbox port
# arg2 - HTTP port optional default:80
# arg3 - MySQL port optional default:3306:

if (scalar @ARGV < 2) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#flush all outout buffers
$|=1;

my %webiotcounters :shared;
%webiotcounters = ("httpreq", 0, "s1", 0, "s2", 0);

sub countersloop 
{

	threads->self->detach();

	while(1==1)
	{
		#update counters file
		open(COUNTERS, ">webiotcounters");
		print COUNTERS "$webiotcounters{'httpreq'}:$webiotcounters{'s1'}:$webiotcounters{'s2'}\n";
		close(COUNTERS);

		sleep 5;
	}

}


sub sndrequestset
{

	$indexstr = join(";;", @packetindex);
	$indexstr = ";;".$indexstr;

	#DEBUGGING
	#print STDOUT "$indexstr\n\n";

	# checking for a compeleted HTTP req/resp
	if($indexstr =~ /;(\d+)-(\d+\.\d+\.\d+\.\d+):(\d+):(\d+\.\d+\.\d+\.\d+):($httpport);.*?;(\d+)-(\d+\.\d+\.\d+\.\d+):($httpport):(\2):(\3);(?!.+?\2:\3$)/)
	{
		$rhost = $9;
		$rport = $10;
		$firstrespindex = $6;
		$rhost =~ s/\./\\$&/g;

		# extract raw set indices
		%httpindexarray = ();
		%httpreqindexarray = ();
		%httprespindexarray = ();
		%sqlreqindexarray = ();
		%sqlrespindexarray = ();
		while($indexstr =~ /;(\d+)-$rhost:$rport:\d+\.\d+\.\d+\.\d+:$httpport;/g)
		{
			$httpindexarray{"$1"} = '1';
			$httpreqindexarray{"$1"} = '1';
		}
		while($indexstr =~ /;(\d+)-\d+\.\d+\.\d+\.\d+:$httpport:$rhost:$rport;/g)
		{
			$httpindexarray{"$1"} = '1';
			$httprespindexarray{"$1"} = '1';
		}
		while($indexstr =~ /;(\d+)-\d+\.\d+\.\d+\.\d+:\d+:\d+\.\d+\.\d+\.\d+:$mysqlport;/g)
		{
			$sqlreqindexarray{"$1"} = '1';
		}
		while($indexstr =~ /;(\d+)-\d+\.\d+\.\d+\.\d+:$mysqlport:\d+\.\d+\.\d+\.\d+:\d+;/g)
		{
			$sqlrespindexarray{"$1"} = '1';
		}

		# fill in request set sub-strings
		$symhttpreq = 'symhttpreq-';
		$symhttpresp = 'symhttpresp-';
		$symsqlreq = 'symsqlreq-';
		$symsqlresp = 'symsqlresp-';
		open(BUFFER, "<webiotbuffer");

		$inpacket = '';
		while($inline = <BUFFER>)
		{
			$inpacket .= $inline;
			if($inline =~ /<\/packet>/i)
			{
				$inpacket =~ /show="(.+?)"/si;
				$pcktnum = $1;

				if($httpreqindexarray{"$pcktnum"} eq '1')
				{

					$inpacket =~ /(<packet>.*?<\/proto>).*?(<proto name="http".*?)(<\/proto>\n<\/packet>)/si;

                			$geninfo = $1;
                			$httpreq = $2;
                			$endmarker = $3;

                			if($httpreq !~ /proto name="mime_multipart"/si)
                			{
                        			#case NO MIME
                        			$symhttpreqval = $geninfo."\n".$httpreq.$endmarker;
                			} else {

                        			#case MIME - filter out sub-dissector output from MIME dissector output
                        			$httpreq =~ /<proto name="http".*?<\/proto>/si;
                        			$httpreqhdr = $&;
                        			$httpmimestr = "";
                        			while($httpreq =~ /field name="mime_multipart.part".*?value="(.*?0d0a0d0a)(.*?)"/gsi)
                        			{
                                			$httpmimestr .= "\n<mimeparthdr value=\"$1\"/>" ;
                                			$httpmimestr .= "\n<mimepartdata value=\"$2\"/>" ;
                        			}
                        			$symhttpreqval = $geninfo."\n".$httpreqhdr."\n<proto name=\"mime_multipart\">".$httpmimestr."\n".$endmarker;

					}

					$symhttpreqvalhex = unpack("H*", $symhttpreqval);
					$symhttpreq .= $symhttpreqvalhex;

				}


				if($httprespindexarray{"$pcktnum"} eq '1')
				{
					$inpacket =~ /(<proto name="http".*?<\/proto>\n<\/packet>)/si;
					$httprespvals = $1;
			
					while($httprespvals =~ / value="(.+?)"/gs)
					{
						$symhttpresp .= $1;
					}
				}


				if($sqlreqindexarray{"$pcktnum"} eq '1')
				{
					#extract just the sql statements from request

					if($inpacket =~ /(<proto name="mysql".*?<\/proto>\n<\/packet>)/si)
					{
						$sqlreqvals = $1;
					} else {
						$sqlreqvals = "";
					}
			
					while($sqlreqvals =~ /Statement.*?value="(.*?)"/gs)
					{
						$symsqlreq .= $1.";";
					}
				}


				if($sqlrespindexarray{"$pcktnum"} eq '1')
				{
					#extract just the sql result set from response
					if($inpacket =~ /(<proto name="mysql".*?<\/proto>\n<\/packet>)/si)
					{
						$sqlrespvals = $1;
					} else {
						$sqlrespvals = "";
					}
			
					#$sqlrespvals =~ s/^.*?mysql\.stat\.bs//si; # optimization, no payloads before this point - disabled for experimentation as not 100% sure

					while($sqlrespvals =~ /Payload.*?value="(.*?)"/gs)
					{
							$symsqlresp .= $1.";";
					}
				}

				$inpacket = '';
			}
		}
		close(BUFFER);


		# create single request set string
		$symhttpreq .= ';;';
		$symhttpresp .= ';;';
		$symsqlreq .= ';;';
		$symsqlresp .= ';;';
		$requestsetstr = $symhttpreq.$symhttpresp.$symsqlreq.$symsqlresp;


		# send string over to server
		print $conn $requestsetstr."\n";

		# clean-up buffer and packet index from used HTTP packets, unneccessary back-end packets
		$firsthttpindex = 0;

		while($indexstr =~ s/;(\d+)-$rhost:$rport:\d+\.\d+\.\d+\.\d+:$httpport;//g){}
		while($indexstr =~ s/;(\d+)-\d+\.\d+\.\d+\.\d+:$httpport:$rhost:$rport;//g){}

		$indexstr =~ s/(.*?)(;;)(\d+)(-\d+\.\d+\.\d+\.\d+:\d+:\d+\.\d+\.\d+\.\d+:$httpport)/$2$3$4/;
		$firsthttpindex = $3;
		$indexstr =~ s/^;;//;
		@packetindex = split(/;;/,$indexstr);   

		open(BUFFER, "<webiotbuffer");
		open(BUFFERTMP, ">webiotbuffertmp");

		$inpacket = '';
		$firsthttpindexflag = 0;
		while($inline = <BUFFER>)
		{
			$inpacket .= $inline;
			if($inline =~ /<\/packet>/i)
			{
				$inpacket =~ /show="(.+?)"/si;
				$pcktnum = $1;
				if ($pcktnum == $firsthttpindex)
				{
					$firsthttpindexflag = 1;
				}
				
				if($firsthttpindexflag == 1 and $httpindexarray{"$pcktnum"} ne '1')
				{
					print BUFFERTMP $inpacket;
				}

				$inpacket = '';
			}

		}

		close(BUFFER);
		close(BUFFERTMP);
		system("mv", "webiotbuffertmp", "webiotbuffer");

		#DEBUGGING
		#print STDOUT %httpindexarray;
		#print STDOUT "\n";
		#print STDOUT %httpreqindexarray;
		#print STDOUT "\n";
		#print STDOUT %httprespindexarray;
		#print STDOUT "\n";
		#print STDOUT %sqlreqindexarray;
		#print STDOUT "\n";
		#print STDOUT %sqlrespindexarray;
		#print STDOUT "\n\n\n";

	}

	#clear timed-out packets - more than 30mins of wait assumed to be a failed request or a large file download rather than buffer backlog

	$ts = time();
	if($ts-$lsttmoutclrts > 108000)
	{

	$lsttmoutclrts = $ts;
	%timedout = ();
	open(BUFFER, "<webiotbuffer");
	open(BUFFERTMP, ">webiotbuffertmp");
	while($inline = <BUFFER>)
	{
		$inpacket .= $inline;
		if($inline =~ /<\/packet>/i)
		{
			$inpacket =~ /show="(.+?)"/si;
			$pcktnum = $1;
			$inpacket =~ /name="timestamp".*?value="(.+?)"/si;
			$pcktts = $1;

			if($ts-$pcktts > 108000)
			{
				print BUFFERTMP $inpacket;
			} else {
				$timedout{"$pcktnum"} = '1';
			}

			$inpacket = '';
		}
	}
	close(BUFFER);
	close(BUFFERTMP);
	system("mv", "webiotbuffertmp", "webiotbuffer");


	@temppacketindex = ();
	foreach $indexline (@packetindex)
	{
		$indexline =~ /^(\d+?)-/;
		$indexnum = $1;
		if($timedout{"$indexnum"} ne '1')
		{
			push(@temppacketindex,$indexline);
		}
	}
	@packetindex = @temppacketindex;

	}


}




# process input arguments
$httpport = 80;
if ($ARGV[2]) {$httpport = $ARGV[2]};
$mysqlport = 3306;
if ($ARGV[3]) {$mysqlport = $ARGV[3]};


#create connection with server
$conn = IO::Socket::INET->new(PeerAddr => $ARGV[0],
				PeerPort => $ARGV[1],
				Proto => 'tcp') or die "Cannot connect to server\n"; 

print STDOUT "Starting webiotcl\n";

#launch tshark
open(TSHARK, " tshark -l -T pdml -f \"port $httpport or $mysqlport\" -R \"http or mysql\" -i any -p |");



#start reading packets
open(BUFFER, ">webiotbuffer");
close(BUFFER);
@packetindex = ();
$lsttmoutclrts = time();
$cumuline = ""; 

#Luanch counters thread - no need to lock webcounters since this thread will access it read-only
$thrcounters = threads->new(\&countersloop);

while($tsharkline = <TSHARK>)
{
		
	$cumuline .= $tsharkline;

	#delete duplicate data fields produced by the mime dissector
	$cumuline =~ s/<field name="data\.data".*?\/>//gsi;


	#send completed packet to buffer output
	if($tsharkline =~ /<\/packet>/i)
	{

		$cumuline =~ /show="(.+?)".*?Src:.*?\((.+?)\).*?Dst:.*?\((.+?)\).*?Src Port:.*?\((.+?)\).*?Dst Port:.*?\((.+?)\)/si;
		$packetindexstr = $1."-".$2.":".$4.":".$3.":".$5;


		#update counters
		if($5 eq $httpport )
		{
			$webiotcounters{"httpreq"}++;
		}
		elsif($4 eq $httpport )
		{
			$webiotcounters{"s1"}++;
		}
		elsif($5 eq $mysqlport )
		{
			$webiotcounters{"s2"}++;
		}
	

		#ready for processing a completed packet
		$process = 1;
		
		#filter out unwanted back-end packets	
		if($cumuline =~ /Dst Port: mysql(?!.+?Statement)/s)
		{
			$process = 0;
		}

		if($cumuline =~ /Src Port: mysql(?!.+?Payload)/s)
		{
			$process = 0;
		}

		if($process == 1)
		{
			# update packet index
			$packindexstr = '';
			push(@packetindex, $packetindexstr);
			
			
			#update buffer file
			open(BUFFER, ">>webiotbuffer");
			print BUFFER $cumuline;
			close(BUFFER);

			# send request set
			&sndrequestset;
		}

		$cumuline = '';

	}	


}

