#!/usr/bin/perl

# sigprobe - webiot client probe
# Requires tshark with dissectors: frame:sll:ip:tcp:http:mime_multipart:mysql

use IO::Socket::INET;
use URI::Escape;
use threads;
use threads::shared;
use Time::HiRes;
use Digest::MD5 qw(md5_hex);

# arg0 - sandbox ip
# arg1 - sandbox port
# arg2 - HTTP port default:80
# arg3 - MySQL port default:3306:
# arg4 - interval mode start timestamp

if (scalar @ARGV < 5) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#flush all outout buffers
$|=1;

my %webiotcounters :shared;
%webiotcounters = ("httpreq", 0, "s1", 0, "s2", 0);

sub countersloop 
{

	threads->self->detach();

	while(1==1)
	{
		#update counters file
		open(COUNTERS, ">webiotcounters");
		print COUNTERS "$webiotcounters{'httpreq'}:$webiotcounters{'s1'}:$webiotcounters{'s2'}\n";
		close(COUNTERS);

		sleep 60;
	}

}


# process input arguments
$httpport = 80;
if ($ARGV[2]) {$httpport = $ARGV[2]};
$mysqlport = 3306;
if ($ARGV[3]) {$mysqlport = $ARGV[3]};


#create connection with server
$conn = IO::Socket::INET->new(PeerAddr => $ARGV[0],
				PeerPort => $ARGV[1],
				Proto => 'tcp') or die "Cannot connect to server\n"; 

print STDOUT "Starting webiotcl\n";

#launch tshark
open(TSHARK, " tshark -b filesize:25000 -b files:8 -w /tmp/etherX -S -T pdml -f \"port $httpport or $mysqlport\" -R \"http or mysql\" -i any -p |");



#start reading packets

$cumuline = "";
$getinputsctr = time; 

#Luanch counters thread - no need to lock webcounters since this thread will access it read-only
$thrcounters = threads->new(\&countersloop);

while($tsharkline = <TSHARK>)
{


        #instr
	$instrid = $getinputsctr;
        if($tsharkline =~ /field name="timestamp".*value="(.+?)"/i)
        {
                $instrstartts = $1;

        }

	$tsharkline =~ s/(field name="num".*show=")(.+?)"/$1$getinputsctr"/;



	#delete duplicate data fields produced by the mime dissector
	$tsharkline =~ s/<field name="data\.data".*?\/>//gsi;
	$cumuline .= $tsharkline;

	#send completed packet to buffer output
	if($tsharkline =~ /<\/packet>/i)
	{

		#setting up index/flags and update counters

		$cumuline =~ /show="(.+?)".*?Src:.*?\((.+?)\).*?Dst:.*?\((.+?)\).*?Src Port:.*?\((.+?)\).*?Dst Port:.*?\((.+?)\)/si;
		$packetindexstr = $getinputsctr."-".$2.":".$4.":".$3.":".$5;
		$getinputsctr++;
		$buffname = "webiotbuffer$1";


		#update counters
		if($5 eq $httpport )
		{
			$webiotcounters{"httpreq"}++;
			$httpflag=1;
			$httpreqflag=1;
			$instrhttpreqflag=1;
		}
		elsif($4 eq $httpport )
		{
			$webiotcounters{"s1"}++;
			$httpflag=1;
			$httprespflag=1;
			$instrhttprespflag=1;
		}
		elsif($5 eq $mysqlport )
		{
			$webiotcounters{"s2"}++;
			$sqlreqflag=1;
		}elsif($4 eq $mysqlport)
		{
			$sqlrespflag=1;
		}
	

		#ready for processing a completed packet
		$process = 1;
		
		#filter out unwanted back-end packets	
		if($cumuline =~ /Dst Port: mysql(?!.+?Statement)/s)
		{
			$process = 0;
		}

		if($cumuline =~ /Src Port: mysql(?!.+?Payload)/s)
		{
			$process = 0;
		}

		#############http request###############

		if($httpreqflag==1)
		{
			$cumuline =~ /(<packet>.*?<\/proto>).*?(<proto name="http".*?)(<\/proto>\n<\/packet>)/si;

                	$geninfo = $1;
                	$httpreq = $2;
                	$endmarker = $3;

               		if($httpreq !~ /proto name="mime_multipart"/si)
               		{
                       		#case NO MIME
                       		$cumulinetmp = $geninfo."\n".$httpreq.$endmarker;
               		} else {

                       		#case MIME - filter out sub-dissector output from MIME dissector output
                       		$httpreq =~ /<proto name="http".*?<\/proto>/si;
                       		$httpreqhdr = $&;
                       		$httpmimestr = "";
                       		while($httpreq =~ /field name="mime_multipart.part".*?value="(.*?0d0a0d0a)(.*?)"/gi)
                       		{
                               		$httpmimestr .= "\n<mimeparthdr value=\"$1\"/>" ;
                               		$httpmimestr .= "\n<mimepartdata value=\"$2\"/>" ;
                       		}
                       		$cumulinetmp = $geninfo."\n".$httpreqhdr."\n<proto name=\"mime_multipart\">".$httpmimestr."\n".$endmarker;

			}

			$cumulinehex = unpack("H*", $cumulinetmp);
			if($cumulinehex ne "")
			{
				$cumuline = "[$packetindexstr][$cumulinehex]";
			} else {
				$cumuline = "";
			}	
			$httpreqflag=0;
		}

		#############http response###############
		if($httprespflag==1)
		{
			$cumuline =~ /(<proto name="http".*?<\/proto>\n<\/packet>)/si;
			$httprespvals = $1;
		
			while($httprespvals =~ / value="(.+?)"/g)
			{
				$cumulinehex .= $1;
			}
	
			if($cumulinehex ne "")
			{
				$cumuline = "[$packetindexstr][$cumulinehex]";
			} else {
				$cumuline = "";
			}	
			$httprespflag=0;
		}

		#############sql response###############

		if($sqlrespflag==1)
		{
			$sqlresultset = '';
			$sqlrespvals = '';


			#extract just the sql result set from response
			if($cumuline =~ /(<proto name="mysql".*?<\/proto>\n<\/packet>)/si)
			{
				$sqlrespvals = $1;
			} else {
				$sqlrespvals = "";
			}

			while($sqlrespvals =~ /Payload.*?value="(.*?)"/g)
			{
				$sqlresultset .= $1.";";
			}

			%sqlrespvalsindx = ();
			@tmpsqlrespvals = split(/;/, $sqlresultset);
                        foreach $sqlrespvalentry (@tmpsqlrespvals)
                        {
  				while($sqlrespvalentry ne "")
                                {
                                        $sqlrespvalentry =~ /^(..)/; #taking care of variable length codes as described in MySQL protocol specification "elements" section
                                        $len = hex($&);
                                        $tmplen = $len;
                                        $sqlrespvalentry =~ s/^(..)//;
                                        if($tmplen == 251) # null
                                        {
                                                $len = 0;
                                        } elsif($tmplen == 252)
                                        {
                                                $sqlrespvalentry =~ /^(..)(..)/;
                                                $lenhex = $2.$1;
                                                $len = hex($lenhex);
                                                $sqlrespvalentry =~ s/^(....)//;
                                        } elsif($tmplen == 253)
                                        {
                                                $sqlrespvalentry =~ /^(..)(..)(..)/;
                                                $lenhex = $3.$2.$1;
                                                $len = hex($lenhex);
                                                $sqlrespvalentry =~ s/^(......)//;
                                        } elsif($tmplen == 254)
                                        {
                                                $sqlrespvalentry =~ /^(..)(..)(..)(..)(..)(..)(..)(..)/;
                                                $lenhex = $8.$7.$6.$5.$4.$3.$2.$1;
                                                $len = hex($lenhex);
                                                $sqlrespvalentry =~ s/^(................)//;
                                        }

                                        $sqlrespvalentry =~ /^(..){$len}/;
                                        $sqlrespvalsindx{"$&"}='1' if (length($&) >= 20 && $& !~ /^(..)*00(..)*$/ && $sqlrespvalsindx{"$&"} !='1');# IMPORTANT OPTIMIZATION ASSUMPTION
                                        $sqlrespvalentry =~ s/^(..){$len}//;
                                }

			}

			@sqlrespvalsarray = keys(%sqlrespvalsindx);
			if(scalar @sqlrespvalsarray > 0)
			{
				$cumulinehex = join(';', @sqlrespvalsarray);
				$cumuline = "[$packetindexstr][$cumulinehex]";
			} else {
				$cumuline = "";
			}	


			$sqlrespflag = 0;
		}

		#############sql request###############
		if($sqlreqflag==1)
		{
			%sqlreqvalsindx = ();
                        #extract just the sql statements from requests
                        if($cumuline =~ /(<proto name="mysql".*?<\/proto>\n<\/packet>)/si)
                        {
                                $sqlreqvals = $1;
                        } else {
                                $sqlreqvals = "";
                        }

                        while($sqlreqvals =~ /Statement.*?value="(.*?)"/g)
                        {
				$statement = $1;
				$testline = pack("H*", $statement);
                                if ($testline !~ /^\s*explain/i && $sqlreqvalsindex{"$statement"} != '1')
				{	
					$sqlreqvalsindx{"$statement"}='1';
				}
			
                        }

			@sqlreqvalsarray = keys(%sqlreqvalsindx);
			if(scalar @sqlrespvalsarray > 0)
			{
				$cumulinehex = join(';', @sqlreqvalsarray);
				$cumuline = "[$packetindexstr][$cumulinehex]";
			} else {
				$cumuline = "";
			}	
	


			$sqlreqflag = 0;
		}

		#############NETWORK SEND + RESET###############

		if($process == 1 && $cumuline ne "")
		{
			
			print $conn "$cumuline\n";

	                #instr
	                $interval = (($instrstartts-$ARGV[4])/60)%5;
	                if($instrhttpreqflag == 1 && ($interval == 0 || $ARGV[4] == 0))
	                {
	                        open(INSTRF, ">>webiotperflogs/webiotpampcl.log");
	                        $instrendts = Time::HiRes::time;
	                        print INSTRF "\"$instrid\",\"$instrstartts\",\"$instrendts\"\n";
	                        close(INSTRF);
				$instrhttpreqflag=0;
	                }
	                if($instrhttprespflag == 1 && ($interval == 0 || $ARGV[4] == 0))
	                {
	                        open(INSTRF, ">>webiotperflogs/webiotdangercl.log");
	                        $instrendts = Time::HiRes::time;
	                        print INSTRF "\"$instrid\",\"$instrstartts\",\"$instrendts\"\n";
	                        close(INSTRF);
				$instrhttprespflag=0;
	                }


		}

		$cumuline = '';
		$cumulinehex = '';

	}	


}

