#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

# webroot probe

#arg0 - log file
#arg1 - sampling time interval


if (scalar @ARGV < 2) {die "check usage\n";}
print "Probing the webroot...\n";

open(LOG, ">$ARGV[0]");

# setting autoflush ON
{ my $ofh = select LOG;
	$| = 1;
	select $ofh;
}


print LOG "ts\t\tno. of files\tfiles modified\n";
print LOG "==\t\t============\t==============\n";

system("touch", "tempts");

while(1)
{
	#read/calculate log entries

	#ts
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000;
	($y, $microsecdec) = split('\.', $microseconds);
	#$ts = "$seconds.$microsecdec";
	$ts = "$seconds";
		
	#number of files in the webrootd - source: ls command 
	open(LS, "ls -lRtr /var/www \| grep -c \'^-\' |");
	@lines = <LS>;
	($numfiles, @rest) = split(' ', $lines[0]);

	#number of file modifications within the last second  - source: find command
	$filesmod = 0;
	open(LS, "find /var/www -newer tempts \| wc -l |");
	@lines = <LS>;
	($filesmod, @rest) = split(' ', $lines[0]);

	print LOG "$ts\t$numfiles\t\t$filesmod\n";
	system("touch", "tempts");
	usleep($ARGV[1]);
}

close(LOG);
