/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* response api                                                               */
/******************************************************************************/

#include "response.h"
#include "log.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <strings.h>
#include <unistd.h>
#include <err.h>
#include <string.h>

/* connect to response client */
int connect_rc(const char *hostname, int16_t port)
{
	int sd;
	struct sockaddr_in sa;
	struct hostent *he;

	/* get ip address of response client */
	if(!(he = gethostbyname(hostname)))
		return -1;
	/* create socket */
	sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(sd == -1)
		return -1;
	/* connect socket to response client */
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = *((unsigned int *) he->h_addr);
	sa.sin_port = htons(port);
	bzero(&sa.sin_zero, 8);
	if(connect(sd, (struct sockaddr *) &sa, sizeof(struct sockaddr)) == -1)
		return -1;

	return sd;
}

/* disconnect from response client */
void disconnect_rc(const int sd)
{
	close(sd);
}

/* log response */
void send_response(char *response)
{
	static char message[256];

	snprintf(message, sizeof(message) - 1, "response %s", response);
	logtime_tissue(message);
}

/* send response to response client */
void old_send_response(char *response)
{
	int sd;

	/* connect to response client + open as stream */
	/* currently only one response client on default port supported */
	sd = connect_rc("localhost", RC_DEFAULT_PORT);
	if(sd == -1)
		return;  /* fail gracefully if can't connect */

	/* send response */
	write(sd, (void *) response, strlen(response));

	/* disconnect from response client */
	disconnect_rc(sd);
}
