#!/usr/bin/perl

# a script that processes an apache access log and outputs request resource statistics

#arg 0 - file name

if(scalar @ARGV < 1) {die "Check usage\n"};

%stat = ();
$totreq = 0;

open(IN, "<$ARGV[0]");

while($inline = <IN>)
{
	if($inline =~ /(GET|POST)\s(\S+)\s/)
	{
		$resname = $2;
		$resname =~ s/\?.*$//;
		$resval = $stat{$resname};
		$totreq++;
		$resval++;
		$stat{$resname} = $resval;
	}
}

close(IN);

print STDOUT "Statistics for $ARGV[0]\n";
print "Total Requests - $totreq\n\n";

while (($resname, $resval) = each(%stat))
{
	$respercent = ($resval/$totreq)*100;
	print "$resname - $resval - $respercent%\n";
}



