#!/usr/bin/perl

# webiot server probe


# arg0 - sandbox port set as 5020
# arg1 - input buffer directory
# arg2 - prime-suspects directory
# arg3 - alerts directory

use IO::Socket::INET;
use threads;
use URI::Escape;
use Digest::MD5 qw(md5_hex);
use Time::HiRes;

if (scalar @ARGV < 4) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#Flush all output buffers
$|=1;


#SUB-ROUTINES

#cient request set processing thread, get next request set and enque
sub getinputs {


threads->self->detach();

$session = $_[0];
$getinputsctr = time;

	while($nxtinput = <$session>)
	{
		$tag = $getinputsctr; $getinputsctr++;
		open(FQ,">$ARGV[1]/inputrequestset".$tag);
		print FQ $nxtinput;
		close(FQ);

	}



}




sub psalert
{
	$tag = $psalertctr; $psalertctr++;
	if ($ddalertraised == 1)
	{
        	open(PRIME,">$ARGV[2]/primehttp".$tag);
	} else {
        	open(PRIME,">$ARGV[2]/inputprimehttp".$tag);
	}
        print PRIME $HTTPreqfull;
        print PRIME "\n\n==========================================\n\n";
        print PRIME $psid;
        close(PRIME);

}


sub ddalert
{

	$tag = $ddalertctr; $ddalertctr++;
	open(AQ,">$ARGV[3]/ddalert".$tag);
	print AQ "Culprit: ".$primefile."\n\n";
	print AQ "Code: ".$dangercode."\n\n";
	print AQ "SID: ".$dangerkey."\n\n";
	print AQ "PID: ".$primepsid."\n\n";
	print AQ "Match: ".$dangermatch."\n\n";
	print AQ "Packet: ".$HTTPreqfull."\n\n";
	close(AQ);


}

#Culprit identification mechanism for injections originating from back-end responses
sub culpritid
{

	print STDOUT "Matching regex: $regex\n";

	# process next prime-suspect in queue if any
	@files = <$ARGV[2]/in*>;

	foreach $file (@files)
	{
		open(PRIME, "<$file") or print STDERR "File opening error\n";
		@primefile = <PRIME>;
		close(PRIME);
		$primefilestr = join("",@primefile);
		$primefilestr =~ /(.*?)={40,}(.*)/si;
		$primehttp = $1;
		$primepsid = $2;


		#patten matching of regex with psid string
		$match = 0;

		if($primepsid =~ /($regex)/si)
		{
			$match = 1;
			$dangermatch = $1;
		}


		#if match - raise alert and delete prime-suspect and danger signal from queue
		if($match == 1)
		{
                        $ddalertraised = 1;
			$tag = $ddalertctr; $ddalertctr++;
			open(AQ,">$ARGV[3]/ddalert".$tag);
			print AQ "Culprit: ".$file."\n\n";
			print AQ "Code: ".$dangercode."\n\n";
			print AQ "SID: ".$dangerkey."\n\n";
			print AQ "PID: ".$primepsid."\n\n";
			print AQ "Match: ".$dangermatch."\n\n";
			print AQ "Packet: ".$primehttp."\n\n";
			close(AQ);
			$newfile = $file;
			$newfile =~ s/input//i; 
			rename("$file", "$newfile");

		}


	}

}


sub d1
{

	$uservalsctr = 0;
	@uservals = ();
	push(@uservals, @httpreqvals);
	push(@uservals, @sqlrespvals);


	#print("=========================================\n");
	#print "d1 - processing http request $httprespstr\n";


	foreach $userval (@uservals)
	{

		$raisealert = 0;
		$uservalstr = pack("H*", $userval);
		$uservalregex = $uservalstr;
		$uservalregex =~ s/([\\\/\^\.\$\*\+\?\@\{\}\[\]\(\)\|])/\\$&/gs;
		#print "d1 - processing $uservalstr\n";
	
		#uservalue contains HTTP-injection sequence 
		if($uservalstr =~ /(\r\r|\n\n|\r\n\r\n)/si )
		{
			if($psid !~ /$uservalregex/s and $uservalsctr < (scalar @httpreqvals))
			{
				$psid .= $uservalstr;
			}
			$raisealert = 1;

			#suppress alert if uservalue is not also in HTTP response
			if($raisealert == 1 and $httprespstr !~ /$uservalregex/)
			{
				$raisealert = 0;
			}

			#suppress alert though in case user value is totally in response body 
			if($raisealert == 1 and $httprespstr =~ /.*?(\r\r|\n\n|\r\n\r\n).*?$uservalregex.*?/si)
			{
				$raisealert = 0;
			}

		}


		#User value not yet caused an alert and contains HTML-injection sequence
		$httprespstr =~ /\r\n\r\n(.*)$/si; 
		$httprespstrbody = $1;


		if( $raisealert == 0 and $uservalstr =~ /(<\w\s*.*?(\/)?>)|(<\/\w\s*>)/si )
		{
			if($psid !~ /$uservalregex/s and $uservalsctr < (scalar @httpreqvals))
			{
				$psid .= $uservalstr;
			}
                        $raisealert = 1;

                        #suppress alert if uservalue is not also in HTTP response body
                        if($raisealert == 1 and $httprespstrbody !~ /$uservalregex/)
                        {
                                $raisealert = 0;
                        }


			#suppress alert though in case user value is totally in data part of HTML content
			if($raisealert == 1 and $httprespstr =~ /<script>.(?!<\/script)*?$uservalregex.(?!<script>)*?<\/script/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /<style>.(?!<\/style)*?$uservalregex.(?!<style>)*?<\/style/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /<textarea>.(?!<\/textarea)*?$uservalregex.(?!<textarea>)*?<\/textarea/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /<title>.(?!<\/title)*?$uservalregex.(?!<title>)*?<\/title/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /<!\[CDATA\[.(?!\]\])*?$uservalregex.(?!<!\[CDATA\[)*?\]\]/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /<!--.(?!-->)*?$uservalregex.(?!<!--)*?-->/si )
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /=\s*'.(?!')*?$uservalregex.(?!')*?'.*?>/si)
			{
				$raisealert = 0;
			}
			if($raisealert == 1 and $httprespstr =~ /=\s*".(?!")*?$uservalregex.(?!")*?".*?>/si)
			{
				$raisealert = 0;
			}

		}

		#global culprit identification mechanism
		if($raisealert == 1 and $uservalsctr >= (scalar @httpreqvals) )
		{
                        $dangercode = "d1";
                        $dangerkey = $uservalstr;
			$regex = $uservalregex;
                        &culpritid;
		}
	
		#raise alert against current HTTP request
		if($raisealert == 1 and $uservalsctr < (scalar @httpreqvals) )
		{
                        $primefile = "$ARGV[2]/inputprimehttp".$psalertctr;
                        $dangercode = "d1";
                        $dangerkey = $uservalstr;
                        $primepsid = $psid;
                        $dangermatch = $uservalstr;
                        &ddalert;
                        $ddalertraised = 1;

		}

		last if $ddalertraised == 1;
		$uservalsctr++;

	}

	#print("=========================================\n");

}


sub d2
{

	@uservals = ();
	push(@uservals, @httpreqvals);


	#print("=========================================\n");
	foreach $sqlreqval (@sqlreqvals)
	{

	$sqlreqstr = pack("H*", $sqlreqval);
	#print "d2 - processing sql request $sqlreqstr\n";
	foreach $userval (@uservals)
	{


		$raisealert = 0;
		$uservalstr = pack("H*", $userval);
		$uservalregex = $uservalstr;
		$uservalregex =~ s/([\\\/\^\.\$\*\+\?\@\{\}\[\]\(\)\|])/\\$&/gs;
		#print "d2 - processing $uservalstr\n";
	
		#uservalue contains HTTP-injection sequence 
		$sqluservalstr = " ".$uservalstr;
		if($sqluservalstr =~ /(\sfrom\s)|(\svalues\s)|(\sset\s)|(\swhere\s)|(\sjoin\s)|(\sunion\s)|(\sand\s)|(\sor\s)|(\sorder\s+by\s)/si)
		{
			if($psid !~ /$uservalregex/s)
			{
				$psid .= $uservalstr;
			}
			$raisealert = 1;


			#suppress alert if uservalue is not also in sql request
			if($raisealert == 1 and $sqlreqstr !~ /$uservalregex/)
			{
				$raisealert = 0;
			}

			#suppress alert in case user value is enclosed within double or single quotes 
			if($raisealert == 1) 
			{

			while($sqlreqstr =~ /"(.*?)"/gsi)
			{
				$enquotedval = $1;
				if($enquotedval =~ /$uservalregex/si )
				{	
					$raisealert = 0;
				}
			}
			while($sqlreqstr =~ /'(.*?)'/gsi)
			{
				$enquotedval = $1;
				if($enquotedval =~ /$uservalregex/si )
				{	
					$raisealert = 0;
				}
			}

			}

			#definitely suppress alert in case we do not have an SQL statement but merely the user value - prob a PHP-MySQL gateway feature ??
			$trimsqlreqstr = $sqlreqstr;
			$trimsqlreqstr =~ s/^\s*//s;
			$trimsqlreqstr =~ s/\s*$//s;
			$trimuservalstr = $uservalstr;
			$trimuservalstr =~ s/^\s*//s;
			$trimuservalstr =~ s/\s*$//s;
			if($trimsqlreqstr eq $trimuservalstr)
			{
				$raisealert = 0;
			}

		}



		#raise alert against current HTTP request
		if($raisealert == 1)
		{
			#raise alert against current HTTP request
      			$primefile = "$ARGV[2]/inputprimehttp".$psalertctr;
		        $dangercode = "d2";
		        $dangerkey = $uservalstr;
			$primepsid = $psid;
		        $dangermatch = $uservalstr;
			&ddalert;
			$ddalertraised = 1;

		}


		last if $ddalertraised == 1;

	}
		last if $ddalertraised == 1;

	}

	#print("=========================================\n");

}



# REQUEST SET BUFFER  PROCESSING LOOP

$ctr = time;
$psalertctr = $ctr;
$ddalertctr = $ctr;


	while(1)
	{

		# process next buffer input request set file in queue if any
		@inbfiles = <$ARGV[1]/in*>;
		
		foreach $inbfile (@inbfiles)
		{
			print STDOUT ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>Handling $inbfile\n";
		

			open(BUFFERIN, "<$inbfile") or print STDERR "File opening error\n";
			$inbufferline = <BUFFERIN>;
			close(BUFFERIN);

			@httpreqvals = ();
			@sqlreqvals = ();
			@sqlrespvals = ();
			$HTTPreqfull = "";
			$httprespstr = "";
			$psid = "";
			$ddalertraised = 0;

			#extracting i/o strings from request set
			$inbufferline =~ /symhttpreq-(.*?);;sym/i;
			$httpreqhex = $1;
			$HTTPreqfull = pack("H*", $httpreqhex);
			

                        $HTTPreqfull =~ /(<proto name="http".*$)/si;
                        $HTTPreq = $1;

		        #clean up HTTPReq from the first value string (results in a qstr duplicate) and empty values
        		$tmpHTTPreq = $HTTPreq;
        		$tmpHTTPreq =~ s/.*?value=".*?"//s;
        		$tmpHTTPreq =~ s/value="\s*"//gs;
        		$tmpHTTPreq_nomime = $tmpHTTPreq;
        		$tmpHTTPreq_nomime =~ s/<proto name="mime_multipart".*$//gsi;


        		#GET/POST/COOKIE values extract + normalize

        		while($tmpHTTPreq_nomime =~ / value="(.*?)"/gs)
        		{
                		$userval = pack("H*", $1);
                		while($userval =~ /(\S+?)=(\S+?)(&|\s|$)/gsi)
                		{
                        		$getpostval = $2;
                        		$getpostval =~ tr/+/ /;
                        		$getpostval = uri_unescape($getpostval);
					$getpostval = unpack("H*", $getpostval);
                        		push(@httpreqvals, $getpostval)
                		}
        		}

		        #mime hdr/data values extract

		        while($tmpHTTPreq =~ /mimeparthdr.*?value="(.*?)"/g)
		        {
		        	$mimehdr =  pack("H*", $1);
		                while($mimehdr =~ /(.*?)(;|\r\n\r\n)/gi)
	                	{
		        		$hdrval = unpack("H*", $1);
                        		push(@httpreqvals, $hdrval)
                		}
        		}

		        while($tmpHTTPreq =~ /mimepartdata.*?value="(.*?)"/gi)
		        {
		                $dataval = $1;
		                push(@httpreqvals, $dataval)
		        }


		        #further clean-up
		        @tmphttpreqvals = ();
		        foreach $httpreqval (@httpreqvals)
		        {
		                if ($httpreqval !~/^\s*$/)
		                {
		                        push(@tmphttpreqvals, $httpreqval);
		                }
		        }

		        @httpreqvals = @tmphttpreqvals;

			$inbufferline =~ /symsqlreq-(.*?);;sym/i;
			@tmpsqlreqvals = split(/;/, $1);
			%sqlreqvalsindx = ();
			foreach $sqlreqvalentry (@tmpsqlreqvals)
			{
				$sqlreqvalsindx{"$sqlreqvalentry"}='1' if ($sqlreqvalsindx{"$sqlreqvalentry"} !='1');
			}
			@sqlreqvals = keys(%sqlreqvalsindx);
			push (@sqlreqvals, "dummy"); #enabling d2 to go through at least one loop

			$inbufferline =~ /symsqlresp-(.*?);;$/i; 
			@tmpsqlrespvals = split(/;/, $1);
			%sqlrespvalsindx = ();
			foreach $sqlrespvalentry (@tmpsqlrespvals)
			{
				$sqlrespvalsindx{"$sqlrespvalentry"}='1' if ($sqlrespvalsindx{"$sqlrespvalentry"} !='1');
			}
			@sqlrespvals = keys(%sqlrespvalsindx);


			$inbufferline =~ /symhttpresp-(.*?);;sym/i;
			$httprespval = $1;
			$httprespstr = pack("H*", $httprespval);

			&d1; #handling s1-driven alerts
			&d2 if $ddalertraised == 0; #handling s2-driven alerts
			if($psid ne "") # prime-suspect alert file creation
			{
				&psalert;
			}

			unlink $inbfile;
			#$newinbfile = $inbfile;
                        #$newinbfile =~ s/input//i;
                        #rename("$inbfile","$newinbfile");

		}

		sleep 1;

	}

