#!/usr/bin/perl

# wrt danger signals server probe


# arg0 - sandbox port set as 5011
# arg1 - input queue directory
# arg2 - alerts directory
# arg3 - prime-suspects directory

use IO::Socket::INET;
use threads;
use URI::Escape;
use IPC::Open2;

if (scalar @ARGV < 4) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#Flush all output buffers
$|=1;


#SUB-ROUTINES

#cient request processing thread, get next danger signal attribute and enque
sub getdangers {


threads->self->detach();

$session = $_[0];
$getdangersctr = time;

	while($nxtdanger = <$session>)
	{
		$tag = $getdangersctr; $getdangersctr++;
		open(FQ,">$ARGV[1]/inputdanger".$tag);
		print FQ $nxtdanger;
		close(FQ);
	}

}

#Culprit identification mechanism
sub culpritid
{

	#build regex
	$regex = "";

	
        if($dangercode eq "d1"){
                $regex = "open\\(\"(\\/var\\/www\\/.*?)\",|open\\(\"([^\\/].*?)\",";
        }


        if($dangercode eq "d2"){
                $regex = "open\\(\"(\\/var\\/www\\/.*?)\",|unlinkat\\(\\w+, \"(\\/var\\/www\\/.*?)\",|open\\(\"([^\\/].*?)\",|unlinkat\\(\\w+, \"([^\\/].*?)\",";
        }




	#invalide dangercode
	if($regex eq "")
	{
		return;
	}


	print STDOUT "Matching dangerkey: $dangerkey\n";

	# process next prime-suspect in queue if any
	@files = <$ARGV[3]/in*>;

	foreach $file (@files)
	{

		open(PRIME, "<$file") or print STDERR "File opening error\n";
		@primefile = <PRIME>;
		close(PRIME);
		$primefilestr = join("",@primefile);
		$primefilestr =~ /(.*?)={40,}(.*)/si;
		$primehttp = $1;
		$primepsid = $2;


		#patten matching of regex with psid string
		$match = 0;

		while($primepsid =~ /$regex/gsi)
		{
                        $argtmp = $&;
                        $argtmp =~ /\"(.+?)\"/;
			$arg = $1;
			$escarg  = $arg;
			$escarg =~ s/\/+/\//gi; # normalizing forward slash count
			$escarg =~ s/\.\//.*?/gi; # normalizing .
			$escarg =~ s/\.\s*$/.*?/gi; # normalizing .
			$escarg =~ s/\..\//.*?/gi; # normalizing ..
			$escarg =~ s/\..\s*$/.*?/gi; # normalizing ..
			print STDOUT "Matching regex: $escarg\n";
	

			if($dangerkey =~ $escarg)
			{	
				$match = 1;
				$dangermatch = $arg;
				last;
			}
		}


		#if match - raise alert and delete danger signal from queue
		if($match == 1)
		{
			$tag = $culpritidctr; $culpritidctr++;
			open(AQ,">$ARGV[2]/ddalert".$tag);
			print AQ "Culprit: ".$file."\n\n";
			print AQ "Code: ".$dangercode."\n\n";
			print AQ "SID: ".$dangerkey."\n\n";
                        print AQ "PID: ".$primepsid."\n\n";
			print AQ "Match: ".$dangermatch."\n\n";
			print AQ "Packet: ".$primehttp."\n\n";
			close(AQ);
			$newfile = $file;
                        $newfile =~ s/input//i;
                        rename("$file", "$newfile");
                        $newdfile = $dfile;
                        $newdfile =~ s/input//i;
                        rename("$dfile", "$newdfile");

		}


	}

}


#QUEUE PROCESSING LOOP
sub qloop {

        $culpritidctr = time;

	while(1)
	{

		%keysprocsd = ();

		#Danger signal attribute currently being processed
		#code legend: d1 - file modified  ; d2 - file created/deleted; 
		$dangercode = "";
		$dangerkey = "";
		
		# process next danger signal in queue if any
		@dfiles = <$ARGV[1]/in*>;
		
		foreach $dfile (@dfiles)
		{
			open(DANGER, "<$dfile") or print STDERR "File opening error\n";
			@dangerlines = <DANGER>;
                        $dangerline = $dangerlines[0];
			close(DANGER);

			#extract danger code and key
			$dangerline =~ /(\w*):\s*(.*)/i;
			$dangercode = $1;
			$dangerkey = $2;

                        #culprit identification mechanism only carried out for unprocessed danger keys
                        if(! exists $keysprocsd{"$dangerkey"})
                        {
                                $keysprocsd{"$dangerkey"} = 1;
                                &culpritid;
                        }

		}

		sleep 30;

	}

}


#Luanch q thread
$qthread = threads->new(\&qloop);

#Launch client server processing

my $listen_socket = IO::Socket::INET->new(LocalPort => $ARGV[0],
					Listen => 1,
					Proto => 'tcp',
					Reuse => 1) or die "Server Error\n";

print STDERR "wrtdangers listening on port $ARGV[0]\n";

while(my $conn = $listen_socket->accept())
{
	$csthread = threads->new(\&getdangers, $conn);
}



# wait for q thread
$qthread->join();



