#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

# Remote host level probe - source: wget 

#arg0 - log file
#arg1 - sampling time interval
#arg2 - remote host ip


if (scalar @ARGV < 3) {die "check usage\n";}
print "Probing host remotely...\n";

open(LOG, ">$ARGV[0]");

# setting autoflush ON
{ my $ofh = select LOG;
	$| = 1;
	select $ofh;
}


print LOG "ts\thost status\n";
print LOG "==\t===========\n\n";

system("rm", "index.html");
while(1)
{
	#read/calculate log entries

	#ts
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000;
	($y, $microsecdec) = split('\.', $microseconds);
	#$ts = "$seconds.$microsecdec";
	$ts = "$seconds";
		
	#system availability - source: wget 
	$status = 0;
	open(WGET, "wget -t1 --read-timeout 1 http://$ARGV[2] |");
	usleep($ARGV[1]);
	if(-e "index.html")
	{
		$status = 1;
		system("rm", "index.html");
	}

	print LOG "$ts\t$status\n";
}

close(LOG);
