#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

# Networkt level probe - source: /proc/net file-system
#NOTE - ASSUMING ALL TCP/UDP traffic are web app related

#arg0 - log file
#arg1 - sampling time interval


if (scalar @ARGV < 2) {die "check usage\n";}
print "Probing on the network level...\n";

open(LOG, ">$ARGV[0]");

# setting autoflush ON
{ my $ofh = select LOG;
	$| = 1;
	select $ofh;
}


print LOG "ts\t\tifin\tifout\tipin\tipout\ttcpin\ttcpout\tudpin\tudpout\ticmpin\ticmpout\n";
print LOG "==\t\t====\t=====\t====\t=====\t=====\t======\t=====\t======\t======\t=======\n\n";

while(1)
{
	#read/calculate log entries

	#ts
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000;
	($y, $microsecdec) = split('\.', $microseconds);
	#$ts = "$seconds.$microsecdec";
	$ts = "$seconds";
		
	#network traffic in terms of packets transmitted/received- source: /proc/dev
	open(DEV, "</proc/net/dev");
	@lines = <DEV>;
	($f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, @rest) = split(' ',  $lines[3]);
	$ifin = $f3;
	$ifout = $f11;

	#network traffic in terms of packets transmitted/received broken down by protocol- source: /proc/snmp
	open(SNMP, "</proc/net/snmp");
	@lines = <SNMP>;
	($f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, @rest) = split(' ',  $lines[1]);
	$ipin = $f4;
	$ipout = $f11;
	($f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, @rest) = split(' ',  $lines[7]);
	$tcpin = $f11;
	$tcpout = $f12;
	($f1, $f2, $f3, $f4, $f5,@rest) = split(' ',  $lines[9]);
	$udpin = $f2;
	$udpout = $f5;
	($f1, $f2, $f3, $f4, $f5, $f6, $f7, $f8, $f9, $f10, $f11, $f12, $f13, $f14, $f15, @rest) = split(' ',  $lines[3]);
	$icmpin = $f2;
	$icmpout = $f15;

	print LOG "$ts\t$ifin\t$ifout\t$ipin\t$ipout\t$tcpin\t$tcpout\t$udpin\t$udpout\t$icmpin\t$icmpout\n";
	usleep($ARGV[1]);
}

close(LOG);
