#!/usr/bin/perl

# ./createtcr.pl icmpin.log icmpin.rate ifout.log ifout.rate ifoutchg.rate strace.log ps.log tcr.antigen.log tcr.signals.log tcr.log

if(scalar @ARGV < 10) { die "check usage\n"; }

# call rate scripts
print "Running rate scripts\n";
system("./icmpinrate.pl","/home/mvella/workbench/logs/$ARGV[0]","/home/mvella/workbench/logs/$ARGV[1]");
system("./ifoutrate.pl","/home/mvella/workbench/logs/$ARGV[2]","/home/mvella/workbench/logs/$ARGV[3]");
system("./ifoutchgrate.pl","/home/mvella/workbench/logs/$ARGV[3]","/home/mvella/workbench/logs/$ARGV[4]");

# call tcr.antigen and tcr.signal scripts
print "Running antigen and signal scripts\n";
system("./createtcr_antigen.pl","/home/mvella/workbench/logs/$ARGV[5]","/home/mvella/workbench/logs/$ARGV[6]","/home/mvella/workbench/logs/$ARGV[7]");
system("./createtcr_signals.pl","/home/mvella/workbench/logs/$ARGV[1]","/home/mvella/workbench/logs/$ARGV[3]","/home/mvella/workbench/logs/$ARGV[4]","/home/mvella/workbench/logs/$ARGV[8]");

# combine antigen and signal into a single final tcr.log

open(TCRANTIGEN, "</home/mvella/workbench/logs/$ARGV[7]") or die "Cannot open input file: $!\n";
open(TCRSIGNALS, "</home/mvella/workbench/logs/$ARGV[8]") or die "Cannot open input file: $!\n";
open(TCRLOG, ">/home/mvella/workbench/logs/$ARGV[9]") or die "Cannot open input file: $!\n";

@tcrantigen = <TCRANTIGEN>;
@tcrsignals = <TCRSIGNALS>;

foreach $signalline (@tcrsignals)
{
	($a, $b, $c, $d, $e, $f, $g) = split(" ", $signalline);
	($secsig,$micro) = split('\.', $a);
	print TCRLOG "$signalline";  #note: $signalline already contains \n
	print "$secsig\n";
	
	@tcrantigentemp = @tcrantigen;
	foreach $antigenline (@tcrantigentemp)
	{
		$break = 0;
		($a, $b, $c, $d, $e) = split(" ", $antigenline);
		($secant,$micro) = split('\.', $a);
		
		if($secant == $secsig) {
			print TCRLOG "$antigenline"; #note: $antigenline already contains \n
			shift(@tcrantigen);
		} else {
			$break = 1;
		}

		break if $break == 1; 
	}	

}

close(TCRANTIGEN);
close(TCRSIGNALS);
close(TCRLOG);

