#!/usr/bin/perl
use Time::HiRes qw( gettimeofday usleep);

#arg0 -  logile
#arg1 -  sampling time

if (scalar @ARGV < 2) {die "check usage\n";}

open(LOG, ">$ARGV[0]");

#oubound packets = ICMP + TCP + UDP
@grep = ("ICMP messages sent", "segments send out", "packets sent");

while(1) 
{
	#utilizing netstat to get the cumulative number of packets
	$packets = 0;
	for($i=0; $i<3; $i++)
	{
		open(NETSTAT,"netstat -s | grep \"$grep[$i]\"|");
		$nets = <NETSTAT>;
		($packetsi, $cont) = split(" ",$nets);
		$packets += $packetsi;
		close(NETSTAT);
	}
	#creating timestamp
	($seconds, $nomicroseconds) = gettimeofday();
	$microseconds = $nomicroseconds/1000000; # required in order to address the leading zeros issue
	($y, $microsdec) = split('\.',$microseconds);
	print LOG "$seconds.$microsdec $packets\n";
	usleep($ARGV[1]);
}

close(LOG);

