/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* antigen api                                                                */
/******************************************************************************/

#ifndef ANTIGEN_H
#define ANTIGEN_H

#include <stdio.h>

/* an antigen */
typedef struct {
	int id;  /* antigen identifier */
	unsigned int len;  /* length */
	char *val;  /* value */
} Antigen;

/* function prototypes */
Antigen *init_antigen(const unsigned int);
void free_antigen(Antigen *);
Antigen *read_antigen(FILE *);
void write_antigen(Antigen *, FILE *);
inline Antigen *dup_antigen(Antigen *);
inline Antigen *set_antigen(Antigen *, char *);
inline void set_antigen_fast(Antigen *, char *);
inline double antigen_match_simple(Antigen *, Antigen *);
inline double antigen_match_syscall(Antigen *, Antigen *);
inline double antigen_match_string(Antigen *, Antigen *);
inline int antigentoi(Antigen *);
inline long antigentolong(Antigen *);
inline const char *antigentostr(Antigen *);

#endif
