/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* cell api                                                                   */
/******************************************************************************/

#ifndef CELL_H
#define CELL_H

#include "antigen.h"
#include "cytokine.h"
#include "receptor.h"
#include "producer.h"

/* generic cell */
typedef struct Cell {
	/* parameters */
	int id;
	unsigned int type;
	unsigned int state;
	void (*cycle)(struct Cell *);
	unsigned int iterations;
	
	/* internal storage */
	unsigned int num_antigen;
	Antigen **antigen;
	unsigned int num_cytokines;
	Cytokine **cytokine;

	/* input receptors */
	unsigned int num_antigen_receptors;
	Antigen_Receptor **antigen_receptor;
	unsigned int num_cytokine_receptors;
	Cytokine_Receptor **cytokine_receptor;
	unsigned int num_cell_receptors;
	Cell_Receptor **cell_receptor;
	unsigned int num_vr_receptors;
	VR_Receptor **vr_receptor;

	/* output producers */
	unsigned int num_cytokine_producers;
	Cytokine_Producer **cytokine_producer;
	unsigned int num_antigen_producers;
	Antigen_Producer **antigen_producer;
	unsigned int num_response_producers;
	Response_Producer **response_producer;
} Cell;

/* cell parameters (to pass to init_cell) */
typedef struct {
	int id;
	unsigned int type;
	unsigned int state;
	unsigned int num_antigen;
	unsigned int num_cytokines;
	unsigned int num_antigen_receptors;
	unsigned int num_cytokine_receptors;
	unsigned int num_cell_receptors;
	unsigned int num_vr_receptors;
	unsigned int num_cytokine_producers;
	unsigned int num_antigen_producers;
	unsigned int num_response_producers;
	void (*cycle)(Cell *);
} Cell_Param;

/* function prototypes */
Cell *init_cell(Cell_Param *);
void free_cell(Cell *);
void print_cell(Cell *);
inline void set_antigen_producers(Cell *);
inline void produce_response(Cell *);

#endif
