/******************************************************************************/
/* (c) 2006 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* tissue client api                                                          */
/******************************************************************************/

#include "client.h"
#include "misc.h"

#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/sctp.h>
#include <strings.h>
#include <unistd.h>
#include <err.h>
#include <stdlib.h>
#include <string.h>

#define CLIENT_MSG		0x00
#define CLIENT_DS		0x01

/* tissue server socket + file descriptors */
static int sd = -1;
static char *clientname;

/* connect to tissue server */
void connect_ts(Network_Info *net_info)
{
	struct hostent *he;
	struct sockaddr_in saddr;
	static char message[64];

	if(!(he = gethostbyname(net_info->hostname)))
		err(1, "couldn't resolve tissue server name");
	memset(&saddr, 0, sizeof(saddr));
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = *((unsigned int *) he->h_addr);
	saddr.sin_port = htons(net_info->port);

	if((sd = socket(AF_INET, SOCK_STREAM, IPPROTO_SCTP)) == -1)
		err(1, "couldn't create socket");
	if(connect(sd, (struct sockaddr *) &saddr, sizeof(saddr)) == -1)
		err(1, "couldn't connect socket");
//	if(sctp_setnonblocking(sd) == -1)
//		err(1, "couldn't set socket nonblocking");

	if(!(clientname = malloc(strlen(net_info->clientname) + 1)))
		err(1, "couldn't use client name");
	strcpy(clientname, net_info->clientname);
	snprintf(message, sizeof(message), "%s client connected", clientname);
	send_message(message);
}

/* disconnect from tissue server */
void disconnect_ts(void)
{
	static char message[64];

	if(sd == -1)
		return;
	snprintf(message, sizeof(message), "%s client disconnected", clientname);
	send_message(message);
	close(sd);
	sd = -1;
}

/* send datastream event to tissue server */
void send_ds(DS *ds)
{
	static char pkt[4096];
	int len;

	if(sd == -1)
		return;
	/* construct data packet to send */
	if((len = ds2pkt(ds, pkt, sizeof(pkt))) == -1)
		return;
	/* send data packet */
	if(send(sd, pkt, len, 0) != len)
		err(1, "couldn't send datastream");
}

/* send message to tissue server */
void send_message(char *message)
{
	static char pkt[4096];
	int len;

	if(sd == -1)
		return;
	/* construct data packet to send */
	pkt[0] = CLIENT_MSG;
	len = strlen(message);
	memcpy(pkt + 1, message, len + 1);
	/* send data packet */
	if(send(sd, pkt, len + 2, 0) != (len + 2))
		err(1, "couldn't send message");
}
