#!/usr/bin/perl

# wpt danger signals server probe


# arg0 - sandbox port set as 5001
# arg1 - input queue directory
# arg2 - alerts directory
# arg3 - prime-suspects directory

use IO::Socket::INET;
use threads;
use URI::Escape;
use Digest::MD5 qw(md5_hex);

if (scalar @ARGV < 4) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#Flush all output buffers
$|=1;


#SUB-ROUTINES

#cient request processing thread, get next danger signal attribute and enque
sub getdangers {


threads->self->detach();

my $session = $_[0];
my $getdangersctr = time;

	while($nxtdanger = <$session>)
	{
		#d2 requires special processing
		if($nxtdanger =~ /^\s*d1/i)
		{	
			$tag = $getdangersctr; $getdangersctr++;
			open(FQ,">$ARGV[1]/inputdanger".$tag);
			print FQ $nxtdanger;
			close(FQ);
		} else {	
			$dangerblock = $nxtdanger;
			while($nxtdanger !~ /^\s*d2:\s*contentend/i)
			{
				$nxtdanger = <$session>;
				$dangerblock .= $nxtdanger;
			}
			$tag = $getdangersctr; $getdangersctr++;
			open(FQ,">$ARGV[1]/inputdanger".$tag);
			print FQ $dangerblock;
			close(FQ);
		}

	}

}

#Culprit identification mechanism
sub culpritid
{

	if($dangercode eq "d1"){
		#build regex
		$regex = "";
		$dangerkey =~ /^(.*?):(.*)\s*/;
		$escdangerkey1 = $1;
		$escdangerkey2 = $2;
		$escdangerkey1 =~ s/([\\\/\^\.\$\*\+\?\@\{\}\[\]\(\)\<\>\|])/\\$&/g;
		$escdangerkey2 =~ s/([\\\/\^\.\$\*\+\?\@\{\}\[\]\(\)\<\>\|])/\\$&/g;
		$regex = "sa_family=AF_INET, sin_port=htons\\($escdangerkey2\\), sin_addr=inet_addr\\(\"$escdangerkey1\"\\)";
	}

	if($dangercode eq "d2"){
		#build regex
		$regex = $dangerkey;
		$regex =~ s/^\s*//;
		$regex =~ s/\s*$//;
		$regex =~ s/([\\\/\^\.\$\*\+\?\@\{\}\[\]\(\)\<\>\|])/\\$&/g;
	}


	#invalid dangercode
	if($regex eq "")
	{
		return;
	}


	print STDOUT "Matching regex: $regex\n";

	# process next prime-suspect in queue if any
	@files = <$ARGV[3]/in*>;

	foreach $file (@files)
	{
		open(PRIME, "<$file") or print STDERR "File opening error\n";
		@primefile = <PRIME>;
		close(PRIME);
		$primefilestr = join("",@primefile);
		$primefilestr =~ /(.*?)={40,}(.*)/si;
		$primehttp = $1;
		$primepsid = $2;


		#patten matching of regex with psid string
		$match = 0;

		if($primepsid =~ /($regex)/si)
		{
			$match = 1;
			$dangermatch = $1;
		}


		#if match - raise alert and delete prime-suspect and danger signal from queue
		if($match == 1)
		{
			$tag = $culpritidctr; $culpritidctr++;
			open(AQ,">$ARGV[2]/ddalert".$tag);
			print AQ "Culprit: ".$file."\n\n";
			print AQ "Code: ".$dangercode."\n\n";
			print AQ "SID: ".$dangerkey."\n\n";
			print AQ "PID: ".$primepsid."\n\n";
			print AQ "Match: ".$dangermatch."\n\n";
			print AQ "Packet: ".$primehttp."\n\n";
			close(AQ);
			$newfile = $file;
			$newfile =~ s/input//i; 
			rename("$file", "$newfile");
			$newdfile = $dfile;
			$newdfile =~ s/input//i; 
			rename("$dfile", "$newdfile");
		}


	}

}


#QUEUE PROCESSING LOOP
sub qloop {

	$culpritidctr = time;

	while(1)
	{

		%keysprocsd = ();

		#Danger signal attribute currently being processed
		#code legend: d1 - netconn ; d2 - code-block;
		$dangercode = "";
		$dangerkey = "";
		
		# process next danger signal in queue if any
		@dfiles = <$ARGV[1]/in*>;
		
		foreach $dfile (@dfiles)
		{	
			open(DANGER, "<$dfile") or print STDERR "File opening error\n";
			@dangerlines = <DANGER>;
			$dangerline = $dangerlines[0];
			close(DANGER);


			#extract danger code and key for d1 
			if($dangerline =~ /^d1:/){
				$dangerline =~ /(\w*?):\s*(.*)/i;
				$dangercode = $1;
				$dangerkey = $2;
			}

			#extract danger code and key for d2 
			if($dangerline =~ /^d2:/){
				$dangerline =~ /(\w*?):\s*(.*)/i;
				$dangercode = $1;
				$dangerkey = ''; 
				$dangerkeylines = ''; 
				foreach $dangerline (@dangerlines)
				{
					if($dangerline !~ /(d2:\s*contentstart|d2:\s*contentend)/)
					{
						$dangerkeylines .= $dangerline;
					}
				}
				$dangerkeylines =~ s/\n$//si; # removing the additional \n from wptdangercl.pl
				$dangerkey = md5_hex($dangerkeylines);
			}


			#culprit identification mechanism only carried out for unprocessed danger keys
			if(! exists $keysprocsd{"$dangerkey"})
			{
				$keysprocsd{"$dangerkey"} = 1;
				&culpritid;
			}
		}

		sleep 30;

	}

}


#Luanch q thread
$qthread = threads->new(\&qloop);

#Launch client server processing

my $listen_socket = IO::Socket::INET->new(LocalPort => $ARGV[0],
					Listen => 1,
					Proto => 'tcp',
					Reuse => 1) or die "Server Error\n";

print STDERR "wptdangers listening on port $ARGV[0]\n";

while(my $conn = $listen_socket->accept())
{
	$csthread = threads->new(\&getdangers, $conn);
}



# wait for q thread
$qthread->join();



