#!/usr/bin/perl

# signprobe - wrt prime-suspect signals client probe
# Requires tshark with dissectors: frame:sll:ip:tcp:http:mime_multipart

use IO::Socket::INET;

# arg0 - sandbox ip
# arg1 - sandbox port
# arg2 - HTTP port optional default:80

if (scalar @ARGV < 2) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#flush all outout buffers
$|=1;

# process input arguments
$port = 80;
if ($ARGV[2]) {$port = $ARGV[2]};


#create connection with server
$conn = IO::Socket::INET->new(PeerAddr => $ARGV[0],
				PeerPort => $ARGV[1],
				Proto => 'tcp') or die "Cannot connect to server\n"; 

print STDOUT "Starting wrtpampcl\n";

#launch tshark
open(TSHARK, " tshark -l -T pdml -f \"dst port $port\" -R \"http\" -i any -p |");

#start reading HTTP requests
$cumuline = ""; 

while($tsharkline = <TSHARK>)
{

	$cumuline .= $tsharkline;

        #delete duplicate data fields produced by the mime dissector
        $cumuline =~ s/<field name="data\.data".*?\/>//gsi;

        #send completed packet to output
        if($cumuline =~ /(<packet>.*?<\/proto>).*?(<proto name="http".*?)(<\/proto>\n<\/packet>)/si)
        {

                $geninfo = $1;
                $httpreq = $2;
                $endmarker = $3;

                if($httpreq !~ /proto name="mime_multipart"/si)
                {
                        #case NO MIME
			print $conn $geninfo."\n".$httpreq.$endmarker;
                } else {

                        #case MIME - filter out sub-dissector output from MIME dissector output
                        $httpreq =~ /<proto name="http".*?<\/proto>/si;
                        $httpreqhdr = $&;
                        $httpmimestr = "";
                        while($httpreq =~ /field name="mime_multipart.part".*?value="(.*?0d0a0d0a)(.*?)"/gsi)
                        {
                                $httpmimestr .= "\n<mimeparthdr value=\"$1\"/>" ;
                                $httpmimestr .= "\n<mimepartdata value=\"$2\"/>" ;
                        }
			print $conn $geninfo."\n".$httpreqhdr."\n<proto name=\"mime_multipart\">".$httpmimestr."\n".$endmarker;
                }

                $cumuline =~ s/.*?<\/proto>\n<\/packet>//si;

        }
	


}

