#!/usr/bin/perl

# webiot server probe pre-processor (creates HTTP request sets)


# arg0 - sandbox port set as 5020
# arg1 - input buffer directory (stores the individual HTTP/SQL req/resp)
# arg2 - request set (output) buffer directory
# arg3 - httpport
# arg4 - mysqlport

use IO::Socket::INET;
use threads;
use threads::shared;
use Time::HiRes;

if (scalar @ARGV < 5) {die "check usage\n";}

# Ignoring SIGPIPE rather than terminating
$SIG{PIPE} = 'IGNORE';
#Flush all output buffers
$|=1;

my $indexstr : shared;
my $httpindexstr : shared;
$httpport = $ARGV[3];
$mysqlport = $ARGV[4];
$lsttmoutclrts = time();


#SUB-ROUTINES

# INPUT BUFFER  PROCESSING LOOP
sub createreqset {

	 if($httpindexstr =~ /;(\d+)-(\d+\.\d+\.\d+\.\d+):(\d+):(\d+\.\d+\.\d+\.\d+):($httpport);.*?;(\d+)-(\d+\.\d+\.\d+\.\d+):($httpport):(\2):(\3);(?=(;.*?;){10})/) #10 should be increased in a more parallelized web server environment
	{	
                $rhost = $9;
                $rhostregex = $rhost;
                $rport = $10;
                $firstrespindex = $6;
                $rhostregex =~ s/\./\\./gi;

                # extract raw set indices
                @httpreqindexarray = ();
                @httprespindexarray = ();
                @sqlreqindexarray = ();
                @sqlrespindexarray = ();
                while($indexstr =~ /;(\d+)-(\d+\.\d+\.\d+\.\d+):(\d+):(\d+\.\d+\.\d+\.\d+):(\d+);/g)
                {
			if("$2" eq "$rhost" && "$3" eq "$rport" && "$5" eq "$httpport")
			{
                        	push(@httpreqindexarray,"$1");
			}
			elsif("$4" eq "$rhost" && "$5" eq "$rport" && "$3" eq "$httpport")
			{
                        	push(@httprespindexarray,"$1");
			}
			elsif("$5" eq "$mysqlport")
			{
                        	push(@sqlreqindexarray,"$1") if (scalar @httpreqindexarray > 0 && scalar @httprespindexarray == 0);
			}
			elsif("$3" eq "$mysqlport")
			{
                        	push(@sqlrespindexarray,"$1") if (scalar @httpreqindexarray > 0 && scalar @httprespindexarray == 0);
			}
                }

		#print join("-", @httpreqindexarray)."\n";
		#print join("-", @httprespindexarray)."\n";
		#print join("-", @sqlreqindexarray)."\n";
		#print join("-", @sqlrespindexarray)."\n";
		#print "\n\n\n";


                # fill in request set sub-strings
                $symhttpreq = 'symhttpreq-';
                $symhttpresp = 'symhttpresp-';
                $symsqlreq = 'symsqlreq-';
                $symsqlresp = 'symsqlresp-';

                foreach $httpreqbufffile (@httpreqindexarray)
                {
                	open(BUFFER, "<$ARGV[1]/webiotbuffer$httpreqbufffile");
			$bufcontent = <BUFFER>;
			$bufcontent =~ /\[.*?\]\[(.*?)\]/i;
			$content = $1;
			$symhttpreq .= $content;
		}
                foreach $httprespbufffile (@httprespindexarray)
                {
                	open(BUFFER, "<$ARGV[1]/webiotbuffer$httprespbufffile");
			$bufcontent = <BUFFER>;
			$bufcontent =~ /\[.*?\]\[(.*?)\]/i;
			$content = $1;
			$symhttpresp .= $content;
		}
                foreach $sqlreqbufffile (@sqlreqindexarray)
                {
                	open(BUFFER, "<$ARGV[1]/webiotbuffer$sqlreqbufffile");
			$bufcontent = <BUFFER>;
			$bufcontent =~ /\[.*?\]\[(.*?)\]/i;
			$content = $1;
			$symsqlreq .= $content;
		}
                foreach $sqlrespbufffile (@sqlrespindexarray)
                {
                	open(BUFFER, "<$ARGV[1]/webiotbuffer$sqlrespbufffile");
			$bufcontent = <BUFFER>;
			$bufcontent =~ /\[.*?\]\[(.*?)\]/i;
			$content = $1;
			$symsqlresp .= $content;
		}

			
                # create single request set string
                $symhttpreq .= ';;';
                $symhttpresp .= ';;';
                $symsqlreq .= ';;';
                $symsqlresp .= ';;';
                $requestsetstr = $symhttpreq.$symhttpresp.$symsqlreq.$symsqlresp;

		#create request set file
		open(BUFFER, ">$ARGV[2]/inputrequestset$requestsetctr") or die "Cannot create request file $!\n";
		print BUFFER $requestsetstr;
		close(BUFFER);
		$requestsetctr++;

                # clean-up packet index from used HTTP packets, unneccessary back-end packets
                $firsthttpindex = 0;

                $indexstr =~ s/;(\d+)-$rhostregex:$rport:\d+\.\d+\.\d+\.\d+:$httpport;//g;
                $httpindexstr =~ s/;(\d+)-$rhostregex:$rport:\d+\.\d+\.\d+\.\d+:$httpport;//g;
                for $delindex (@httpreqindexarray)
                {
                        unlink "$ARGV[1]/webiotbuffer$delindex";

                }
                $indexstr =~ s/;(\d+)-\d+\.\d+\.\d+\.\d+:$httpport:$rhostregex:$rport;//g;
                $httpindexstr =~ s/;(\d+)-\d+\.\d+\.\d+\.\d+:$httpport:$rhostregex:$rport;//g;
                for $delindex (@httprespindexarray)
                {
                        unlink "$ARGV[1]/webiotbuffer$delindex";
                }

                if($indexstr =~ s/(.*?)(;;)(\d+)(-\d+\.\d+\.\d+\.\d+:\d+:\d+\.\d+\.\d+\.\d+:$httpport)/$2$3$4/)
                {
                        $firsthttpindex = $3;
                }
                $httpindexstr =~ s/(.*?)(;;)(\d+)(-\d+\.\d+\.\d+\.\d+:\d+:\d+\.\d+\.\d+\.\d+:$httpport)/$2$3$4/;

                @allbuffs = <$ARGV[1]/*>;
                foreach $currbuff (@allbuffs)
                {
                        $currbuff =~ /webiotbuffer(\d+)/;
                        $currbuffindex = $1;
                        if($currbuffindex < $firsthttpindex)
                        {
                                unlink $currbuff;
                        }
                }

                #DEBUGGING
                #print STDOUT %httpindexarray;
                #print STDOUT "\n";
                #print STDOUT %httpreqindexarray;
                #print STDOUT "\n";
                #print STDOUT %httprespindexarray;
                #print STDOUT "\n";
                #print STDOUT %sqlreqindexarray;
                #print STDOUT "\n";
                #print STDOUT %sqlrespindexarray;
                #print STDOUT "\n\n\n";

        }

        #clear timed-out packets - more than 1min in q 

        $ts = time();
        if($ts-$lsttmoutclrts >= 60)
        {

                $lsttmoutclrts = $ts;
                %timedout = ();
                @allbuffs = <$ARGV[1]/*>;
                foreach $currbuff (@allbuffs)
                {
                        $filets = (stat($currbuff))[9];
                        if(($filets - ts) >= 60)
                        {
                                unlink $currbuff;
                                $currbuff =~ /webiotbuffer(\d+)/;
                                $timedout{"$1"} = '1';
                        }
                }

                $indexstr =~ s/^;;//;
                @packetindex = split(/;;/,$indexstr);
                @temppacketindex = ();
                foreach $indexline (@packetindex)
                {
                        $indexline =~ /^(\d+?)-/;
                        $indexnum = $1;
                        if($timedout{"$indexnum"} ne '1')
                        {
                                push(@temppacketindex,$indexline);
                        }
                }
                @packetindex = @temppacketindex;	
		$indexstr = join(';;', @packetindex);
		$indexstr = ';;'.$indexstr;

                $httpindexstr =~ s/^;;//;
                @httppacketindex = split(/;;/,$httpindexstr);
                @temphttppacketindex = ();
                foreach $httpindexline (@httppacketindex)
                {
                        $httpindexline =~ /^(\d+?)-/;
                        $httpindexnum = $1;
                        if($timedout{"$httpindexnum"} ne '1')
                        {
                                push(@temphttppacketindex,$httpindexline);
                        }
                }
                @httppacketindex = @temphttppacketindex;	
		$httpindexstr = join(';;', @httppacketindex);
		$httpindexstr = ';;'.$httpindexstr;


	} 


}


#cient symptoms processing thread, get next symptom and enque
sub getinputs {

threads->self->detach();
$requestsetctr = time;
$getinputsctr = 1;

$session = $_[0];

	while($nxtinput = <$session>)
	{
		$buffname = $getinputsctr;
		$getinputsctr++;

                $nxtinput =~ /^\[\d+?-.+?:.+?:.+?:(\d+?)\]/i;
                if ($1 eq "$httpport")
                {
                        $httpflag=1;
                }
                $nxtinput =~ /^\[\d+?-.+?:(\d+?):/i;
                if ($1 eq "$httpport")
                {
                        $httpflag=1;
                }


		$nxtinput =~ s/^\[\d+?-/[$buffname-/i;
                $nxtinput =~ /^\[(.*?)\]/i;
                $indexentry = $1;
		#print "$buffname-for-$indexentry\n";

		#create buffer file
		open(BUFFER, ">$ARGV[1]/webiotbuffer$buffname");
		print BUFFER $nxtinput;
		close(BUFFER);
	
		$indexstr .= ";;$indexentry";
		if($httpflag == 1)
		{
			$httpindexstr .= ";;$indexentry";
			$httpflag=0;
		}
		&createreqset;

	}

}

# clearance of buffer files from previous run

@prevbuffs = <$ARGV[1]/*>;
foreach $prevbuf (@prevbuffs)
{
        unlink $prevbuf;
}


#Launch client server processing

my $listen_socket = IO::Socket::INET->new(LocalPort => $ARGV[0],
					Listen => 1,
					Proto => 'tcp',
					Reuse => 1) or die "Server Error\n";

print STDERR "webiotpreporcs listening on port $ARGV[0]\n";

while(my $conn = $listen_socket->accept())
{
	$csthread = threads->new(\&getinputs, $conn);
}


