#!/usr/bin/perl

if(scalar @ARGV < 3) { die "check usage\n"; }

#arg0 - strace.log
#arg1 - ps.log
#arg2 - tcr.antigen.log

# create associative array storing pid-pname elements
sub createhash {

	open(PSLOG, "<$ARGV[1]") or die "Cannot open input file: $!\n";
	@inps = reverse <PSLOG>;  # due to the fact that certain pids start as one process and fork into another
	foreach $inpsline (@inps)
	{
		($pid, $x, $y, $pname) = split(" ", $inpsline);	
		if ( !( exists($ps{$pid}) )) {   $ps{$pid} = $pname;     }

	}


}

open(STRACELOG, "<$ARGV[0]") or die "Cannot open input file: $!\n";
open(ANTIGENTCRLOG, ">$ARGV[2]") or die "Cannot open input file: $!\n";

# associative array storing pid-pname elements
%ps = ();
&createhash;

while($instrace = <STRACELOG>)
{
	($pid, $ts, $eip, $syscall) = split(" ", $instrace);
	if ($ps{$pid} )
		{print ANTIGENTCRLOG "$ts antigen $pid 1 $ps{$pid}\n";}
	else 
		{print ANTIGENTCRLOG "$ts antigen $pid 1 $pid\n";}
}

close(STRACELOG);
close(PSLOG);
close(ANTIGENTCRLOG);
