/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* tissue client api                                                          */
/******************************************************************************/

#ifndef CLIENT_H
#define CLIENT_H

#include <stdio.h>

#include "ds.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <stdarg.h>

#define TS_DEFAULT_PORT	5050  /* default port tissue server listens on */
#define RC_DEFAULT_PORT 5049  /* default port response client listens on */

/* network information about tissue server/client */
typedef struct {
	char hostname[256];
	int16_t port;
	char clientname[256];
} Network_Info;

/* function prototypes */
void connect_ts(Network_Info *);
void disconnect_ts(void);
void send_ds(DS *);
void send_message(char *);

#endif
