/******************************************************************************/
/* (c) 2005 jamie twycross, jpt AT cs.nott.ac.uk                              */
/* released under gnu gpl v2                                                  */
/* datastream api                                                             */
/******************************************************************************/

#ifndef DS_H
#define DS_H

#define _XOPEN_SOURCE

#include <stdio.h>
#include <sys/time.h>
#include <time.h>

#include "signal.h"
#include "antigen.h"

/* datastream event structure */
typedef struct {
	struct timeval tm; /* timestamp */
	int id; /* unique id */
	unsigned int num_signals; /* number of signals */
	unsigned int num_antigen; /* number of antigen */
	Signal **signal; /* signals */
	Antigen **antigen; /* antigen */
} DS;

/* function prototypes */
DS *init_ds(const unsigned int, const unsigned int);
void free_ds(DS *);
DS *read_ds(FILE *);
void write_ds(DS *, FILE *);
void print_ds(const DS *);
inline DS *pkt2ds(char *, int);
inline int ds2pkt(DS *, char *, int);
inline void log_ds(DS *ds);

#endif
